/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityLocker
extends TileEntityLockable {
    private static final ForgeDirection[] neighbors = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP};
    public boolean mirror = false;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getResource() {
        return this.isConnected() ? Resources.textureLockerLarge : Resources.textureLocker;
    }

    @Override
    public boolean canHaveLock() {
        return false;
    }

    @Override
    public boolean canHaveMaterial() {
        return false;
    }

    @Override
    public void setAttachmentPosition() {
    }

    @Override
    public ForgeDirection[] getPossibleNeighbors() {
        return neighbors;
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.locker";
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        if (!(connectable instanceof TileEntityLocker)) {
            return false;
        }
        TileEntityLocker locker = (TileEntityLocker)connectable;
        return super.canConnect(connectable) && this.mirror == locker.mirror;
    }

    @Override
    public void onBlockPlacedBeforeCheckingConnections(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBeforeCheckingConnections(player, stack);
        double angle = DirectionUtils.getRotation(this.getOrientation().getOpposite());
        double yaw = (player.field_70177_z % 360.0f + 360.0f) % 360.0f;
        this.mirror = DirectionUtils.angleDifference(angle, yaw) > 0.0;
        this.setAttachmentPosition();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.getOrientation().ordinal() != side) {
            return true;
        }
        return super.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    @Override
    public Packet func_70319_e() {
        Packet132TileEntityData packet = (Packet132TileEntityData)super.func_70319_e();
        NBTTagCompound compound = packet.field_73331_e;
        compound.func_74757_a("mirror", this.mirror);
        return packet;
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.field_73331_e;
        this.mirror = compound.func_74767_n("mirror");
        this.setAttachmentPosition();
    }

    @Override
    public void func_70307_a(NBTTagCompound compound) {
        super.func_70307_a(compound);
        this.mirror = compound.func_74767_n("mirror");
        this.setAttachmentPosition();
    }

    @Override
    public void func_70310_b(NBTTagCompound compound) {
        super.func_70310_b(compound);
        compound.func_74757_a("mirror", this.mirror);
    }
}

