/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.ProjectRedIntegration;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.GateLogic;
import mrtjp.projectred.integration.GatePart;

public class IntegrationSPH
implements PacketCustom.IServerPacketHandler {
    public static Object channel = ProjectRedIntegration.instance;

    public void handlePacket(PacketCustom packet, ka nethandler, jv player) {
        switch (packet.getType()) {
            case 1: {
                this.incrTimer(player.q, packet);
                break;
            }
            case 2: {
                this.incCounter(player.q, packet);
            }
        }
    }

    private void incCounter(abw world, PacketCustom packet) {
        GatePart gate;
        TMultiPart part = IntegrationSPH.readPartIndex(world, packet);
        if (part instanceof GatePart && (gate = (GatePart)part).getLogic() instanceof GateLogic.ICounterGuiLogic) {
            GateLogic.ICounterGuiLogic t = (GateLogic.ICounterGuiLogic)((Object)gate.getLogic());
            byte actionID = packet.readByte();
            if (actionID == 0) {
                t.setCounterMax(gate, t.getCounterMax() + packet.readShort());
            } else if (actionID == 1) {
                t.setCounterIncr(gate, t.getCounterIncr() + packet.readShort());
            } else if (actionID == 2) {
                t.setCounterDecr(gate, t.getCounterDecr() + packet.readShort());
            }
        }
    }

    private void incrTimer(abw world, PacketCustom packet) {
        GatePart gate;
        TMultiPart part = IntegrationSPH.readPartIndex(world, packet);
        if (part instanceof GatePart && (gate = (GatePart)part).getLogic() instanceof GateLogic.ITimerGuiLogic) {
            GateLogic.ITimerGuiLogic t = (GateLogic.ITimerGuiLogic)((Object)gate.getLogic());
            t.setTimerMax(gate, t.getTimerMax() + packet.readShort());
        }
    }

    public static PacketCustom writePartIndex(PacketCustom out, TMultiPart part) {
        return out.writeCoord(new BlockCoord((asp)part.tile())).writeByte(part.tile().jPartList().indexOf(part));
    }

    public static TMultiPart readPartIndex(abw world, PacketCustom in) {
        TileMultipart tile = BasicUtils.getMultipartTile((acf)world, (BlockCoord)in.readCoord());
        try {
            return (TMultiPart)tile.jPartList().get(in.readUByte());
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static void openTimerGui(uf player, GatePart part) {
        PacketCustom packet = new PacketCustom(channel, 1);
        IntegrationSPH.writePartIndex(packet, (TMultiPart)part);
        packet.sendToPlayer(player);
    }

    public static void openCounterGui(uf player, GatePart part) {
        PacketCustom packet = new PacketCustom(channel, 2);
        IntegrationSPH.writePartIndex(packet, (TMultiPart)part);
        packet.sendToPlayer(player);
    }
}

