/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.scalatraits.TRedstoneTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.core.Messenger;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.WirePart;
import mrtjp.projectred.transmission.WirePropogator;

public abstract class RedwirePart
extends WirePart
implements IRedwirePart,
IFaceRedstonePart {
    public byte signal;

    @Override
    public void save(by tag) {
        super.save(tag);
        tag.a("signal", this.signal);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.signal = tag.c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal = packet.readByte();
    }

    @Override
    public void read(MCDataInput packet, int switch_key) {
        if (switch_key == 10) {
            this.signal = packet.readByte();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        } else {
            super.read(packet, switch_key);
        }
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        if ((side & 6) != (this.side & 6) && (this.connMap & 256 << Rotation.rotationTo((int)this.side, (int)side)) != 0) {
            return 0;
        }
        return this.rsLevel();
    }

    public boolean canConnectRedstone(int side) {
        return WirePropogator.redwiresConnectable();
    }

    public int rsLevel() {
        if (WirePropogator.redwiresProvidePower) {
            return ((this.signal & 0xFF) + 16) / 17;
        }
        return 0;
    }

    public int getFace() {
        return this.side;
    }

    @Override
    public boolean connectionOpen(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        return (((TRedstoneTile)this.tile()).openConnections(absDir) & 1 << Rotation.rotationTo((int)(absDir & 6), (int)this.side)) != 0;
    }

    @Override
    public boolean canConnectToType(IConnectable wire) {
        return wire instanceof IRedwireEmitter || wire instanceof IRedstonePart;
    }

    @Override
    public boolean connectStraightOverride(int absDir) {
        return (RedstoneInteractions.otherConnectionMask((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)absDir, (boolean)false) & RedstoneInteractions.connectionMask((TMultiPart)this, (int)absDir)) != 0;
    }

    @Override
    public boolean connectInternalOverride(TMultiPart p, int r) {
        if (p instanceof IFaceRedstonePart) {
            IRedstonePart rsPart = (IRedstonePart)p;
            return rsPart.canConnectRedstone((int)this.side);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart prev, int mode) {
        if (mode == 1 && this.signal == 0) {
            return;
        }
        int newSignal = this.calculateSignal();
        if (newSignal < this.getRedwireSignal()) {
            if (newSignal > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(prev, 1);
        } else if (newSignal > this.getRedwireSignal()) {
            this.signal = (byte)newSignal;
            if (mode == 1) {
                this.propogate(null, 0);
            } else {
                this.propogate(prev, 0);
            }
        } else if (mode == 1) {
            this.propogateTo(prev, 0);
        } else if (mode == 2) {
            this.propogate(prev, 3);
        }
    }

    @Override
    public void onSignalUpdate() {
        super.onSignalUpdate();
        this.tile().getWriteStream((TMultiPart)this).writeByte(10).writeByte((int)this.signal);
    }

    public int calculateSignal() {
        int i;
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int s = 0;
        for (int r = 0; r < 4; ++r) {
            if (!this.maskConnects(r)) continue;
            if ((this.connMap & 1 << r) != 0) {
                i = this.calculateCornerSignal(r);
                if (i <= s) continue;
                s = i;
                continue;
            }
            if ((this.connMap & 16 << r) != 0 && (i = this.calculateStraightSignal(r)) > s) {
                s = i;
            }
            if ((i = this.calculateInternalSignal(r)) <= s) continue;
            s = i;
        }
        i = this.calculateUndersideSignal();
        if (i > s) {
            s = i;
        }
        if ((this.connMap & 0x10000) != 0 && (i = this.calculateCenterSignal()) > s) {
            s = i;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return s;
    }

    public int calculateCornerSignal(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord cnrPos = new BlockCoord((asp)this.tile()).offset(absDir);
        BlockCoord pos = cnrPos.copy().offset((int)this.side);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap(absDir ^ 1)) != null) {
            return this.getPartSignal(tp, Rotation.rotationTo((int)(absDir ^ 1), (int)(this.side ^ 1)));
        }
        return 0;
    }

    public int calculateStraightSignal(int r) {
        TMultiPart tp;
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(absDir);
        TileMultipart t = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)pos);
        if (t != null && (tp = t.partMap((int)this.side)) != null) {
            return this.getPartSignal(tp, (r + 2) % 4);
        }
        int blockID = this.world().a(pos.x, pos.y, pos.z);
        if (blockID == aqz.aA.cF) {
            return this.world().h(pos.x, pos.y, pos.z) - 1;
        }
        return RedstoneInteractions.getPowerTo((TMultiPart)this, (int)absDir) * 17;
    }

    public int calculateInternalSignal(int r) {
        int absDir = Rotation.rotateSide((int)this.side, (int)r);
        TMultiPart tp = this.tile().partMap(absDir);
        return this.getPartSignal(tp, Rotation.rotationTo((int)absDir, (int)this.side));
    }

    public int calculateCenterSignal() {
        return this.getPartSignal(this.tile().partMap(6), this.side);
    }

    public int calculateUndersideSignal() {
        return 0;
    }

    public int getPartSignal(TMultiPart part, int r) {
        if (part instanceof IRedwirePart && ((IRedwirePart)part).isWireSide(r)) {
            return ((IRedwirePart)part).getRedwireSignal(r) - 1;
        }
        if (part instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)part).getRedwireSignal(r);
        }
        if (part instanceof IFaceRedstonePart) {
            IFaceRedstonePart rp = (IFaceRedstonePart)part;
            int side = Rotation.rotateSide((int)rp.getFace(), (int)r);
            return Math.max(rp.strongPowerLevel(side), rp.weakPowerLevel(side)) * 17;
        }
        return 0;
    }

    public int getRedwireSignal() {
        return this.signal & 0xFF;
    }

    @Override
    public int getRedwireSignal(int side) {
        return this.getRedwireSignal();
    }

    @Override
    protected boolean debug(uf ply) {
        ply.a(cv.e((String)((this.world().I ? "Client" : "Server") + " signal strength: " + this.getRedwireSignal())));
        return true;
    }

    @Override
    protected boolean test(uf player) {
        if (BasicUtils.isClient((abw)this.world())) {
            Messenger.addMessage((double)(this.x() + 0), (double)((float)this.y() + 0.5f), (double)(this.z() + 0), (String)("/#f/#c[c] = " + this.getRedwireSignal()));
        } else {
            PacketCustom packet = new PacketCustom(CoreSPH.channel, 2);
            packet.writeDouble((double)this.x() + 0.0);
            packet.writeDouble((double)this.y() + 0.5);
            packet.writeDouble((double)this.z() + 0.0);
            packet.writeString("/#c[s] = " + this.getRedwireSignal());
            packet.sendToPlayer(player);
        }
        return true;
    }
}

