/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.api.prefab;

import li.cil.oc.api.Network;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEntitySidedEnvironment
extends TileEntity
implements SidedEnvironment {
    protected Node[] nodes = new Node[6];
    protected boolean addedToNetwork = false;

    protected TileEntitySidedEnvironment(Node ... nodes) {
        System.arraycopy(nodes, 0, this.nodes, 0, Math.min(nodes.length, this.nodes.length));
    }

    @Override
    public Node sidedNode(ForgeDirection side) {
        return side == ForgeDirection.UNKNOWN ? null : this.nodes[side.ordinal()];
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork(this);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        for (Node node : this.nodes) {
            if (node == null) continue;
            node.remove();
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        for (Node node : this.nodes) {
            if (node == null) continue;
            node.remove();
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        int index = 0;
        for (Node node : this.nodes) {
            if (node != null && node.host() == this) {
                node.load(nbt.func_74775_l("oc:node" + index));
            }
            ++index;
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        int index = 0;
        for (Node node : this.nodes) {
            if (node != null && node.host() == this) {
                NBTTagCompound nodeNbt = new NBTTagCompound();
                node.save(nodeNbt);
                nbt.func_74766_a("oc:node" + index, nodeNbt);
            }
            ++index;
        }
    }
}

