/*
 * Decompiled with CFR 0.152.
 */
package resonant.api.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Cancelable;
import net.minecraftforge.event.Event;
import resonant.lib.utility.WorldUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class LaserEvent
extends Event {
    public World world;
    public Vector3 spot;
    public Vector3 target;

    public LaserEvent(World world, Vector3 spot, Vector3 target) {
        this.world = world;
        this.spot = spot;
        this.target = target;
    }

    public static boolean doLaserHarvestCheck(World world, Vector3 pos, Object player, Vector3 hit) {
        Block block = Block.field_71973_m[pos.getBlockID((IBlockAccess)world)];
        LaserMineBlockEvent event = new LaserMineBlockEvent(world, pos, hit, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static void onLaserHitBlock(World world, Object player, Vector3 vec, ForgeDirection side) {
        LaserEvent.onLaserHitBlock(world, player, vec, side, true);
    }

    public static void onLaserHitBlock(World world, Object player, Vector3 vec, ForgeDirection side, boolean doDamage) {
        int id = vec.getBlockID((IBlockAccess)world);
        int meta = vec.getBlockMetadata((IBlockAccess)world);
        Block block = Block.field_71973_m[id];
        Vector3 faceVec = vec.clone().translate(side);
        int id2 = faceVec.getBlockID((IBlockAccess)world);
        Block block2 = Block.field_71973_m[id2];
        Vector3 start = null;
        if (player instanceof Entity) {
            start = new Vector3((Entity)player);
        } else if (player instanceof TileEntity) {
            start = new Vector3((TileEntity)player);
        }
        if (block != null && block.field_71989_cb > -1.0f) {
            if (doDamage) {
                float chance = world.field_73012_v.nextFloat();
                int fireChance = block.getFlammability((IBlockAccess)world, vec.intX(), vec.intY(), vec.intZ(), meta, side);
                if ((float)(fireChance / 300) >= chance && (block2 == null || block2.isAirBlock(world, vec.intX(), vec.intY(), vec.intZ()))) {
                    world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), Block.field_72067_ar.field_71990_ca, 0, 3);
                    return;
                }
                if (block.field_71990_ca == Block.field_71980_u.field_71990_ca && (block2 == null || block2.isAirBlock(world, vec.intX(), vec.intY() + 1, vec.intZ()))) {
                    world.func_72832_d(vec.intX(), vec.intY() + 1, vec.intZ(), Block.field_72067_ar.field_71990_ca, 0, 3);
                    world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), Block.field_71979_v.field_71990_ca, 0, 3);
                    return;
                }
                if (chance > 0.8f) {
                    if (block.field_71990_ca == Block.field_71939_E.field_71990_ca) {
                        world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), Block.field_71946_M.field_71990_ca, 0, 3);
                        return;
                    }
                    if (block.field_71990_ca == Block.field_71978_w.field_71990_ca) {
                        world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), 1, 0, 3);
                        return;
                    }
                    if (block.field_71990_ca == Block.field_72036_aT.field_71990_ca) {
                        world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), Block.field_71943_B.field_71990_ca, 15, 3);
                        return;
                    }
                    if (block.field_71990_ca == Block.field_72089_ap.field_71990_ca) {
                        world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), Block.field_71938_D.field_71990_ca, 15, 3);
                        return;
                    }
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new LaserMeltBlockEvent(world, start, vec, player));
        }
    }

    public static void onBlockMinedByLaser(World world, Object player, Vector3 vec) {
        if (!world.field_72995_K) {
            Block b;
            int id = vec.getBlockID((IBlockAccess)world);
            int meta = vec.getBlockID((IBlockAccess)world);
            Block block = Block.field_71973_m[id];
            Vector3 start = null;
            if (player instanceof Entity) {
                start = new Vector3((Entity)player);
            } else if (player instanceof TileEntity) {
                start = new Vector3((TileEntity)player);
            }
            List<ItemStack> items = null;
            if (block != null && block.func_71934_m(world, vec.intX(), vec.intY(), vec.intZ()) >= 0.0f && LaserEvent.doLaserHarvestCheck(world, start, player, vec)) {
                items = WorldUtility.getItemStackFromBlock(world, vec.intX(), vec.intY(), vec.intZ());
                try {
                    Block blockBellow = Block.field_71973_m[vec.clone().translate(ForgeDirection.DOWN).getBlockID((IBlockAccess)world)];
                    if (block.field_71990_ca == Block.field_72091_am.field_71990_ca) {
                        world.func_72832_d(vec.intX(), vec.intY(), vec.intZ(), 0, 0, 3);
                        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)((float)vec.intX() + 0.5f), (double)((float)vec.intY() + 0.5f), (double)((float)vec.intZ() + 0.5f), player instanceof EntityLivingBase ? (EntityLivingBase)player : null);
                        entitytntprimed.field_70516_a = world.field_73012_v.nextInt(entitytntprimed.field_70516_a / 4) + entitytntprimed.field_70516_a / 8;
                        world.func_72838_d((Entity)entitytntprimed);
                        return;
                    }
                    if (block.field_72018_cp == Material.field_76245_d || block.field_72018_cp == Material.field_76254_j || block.field_72018_cp == Material.field_76255_k || block.field_72018_cp == Material.field_76254_j || block.field_72018_cp == Material.field_76266_z || block.field_72018_cp == Material.field_76253_m || block.field_72018_cp == Material.field_76232_D) {
                        if (blockBellow != null && blockBellow.field_71990_ca == Block.field_72050_aA.field_71990_ca && block instanceof IPlantable) {
                            vec.clone().translate((IVector3)new Vector3(0.0, -1.0, 0.0)).setBlock(world, Block.field_71979_v.field_71990_ca, 0, 3);
                        }
                        vec.setBlock(world, Block.field_72067_ar.field_71990_ca, 0, 3);
                        return;
                    }
                    if (items == null) {
                        items = new ArrayList<ItemStack>();
                    }
                    if (id == Block.field_71946_M.field_71990_ca) {
                        items.add(new ItemStack(Block.field_71946_M, 1, meta));
                    }
                    if (id == Block.field_72003_bq.field_71990_ca) {
                        items.add(new ItemStack(Block.field_72003_bq, 1));
                    }
                    ArrayList<ItemStack> removeList = new ArrayList<ItemStack>();
                    for (int i = 0; i < items.size(); ++i) {
                        if (items.get((int)i).field_77993_c == Block.field_71951_J.field_71990_ca) {
                            items.set(i, new ItemStack(Item.field_77705_m, 1, 1));
                            continue;
                        }
                        if (items.get((int)i).field_77993_c != Block.field_71951_J.field_71990_ca) continue;
                        if (world.field_73012_v.nextFloat() < 0.25f) {
                            items.set(i, new ItemStack(Item.field_77705_m, 1, 1));
                            continue;
                        }
                        removeList.add(items.get(i));
                    }
                    items.removeAll(removeList);
                    LaserDropItemEvent event = new LaserDropItemEvent(world, start, vec, items);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    items = event.items;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (player instanceof EntityPlayer) {
                if (block != null) {
                    block.func_71846_a(world, vec.intX(), vec.intY(), vec.intZ(), meta, (EntityPlayer)player);
                    boolean flag = block.removeBlockByPlayer(world, (EntityPlayer)player, vec.intX(), vec.intY(), vec.intZ());
                    if (flag) {
                        block.func_71898_d(world, vec.intX(), vec.intY(), vec.intZ(), meta);
                    }
                }
            } else {
                world.func_94578_a(vec.intX(), vec.intY(), vec.intZ(), false);
                world.func_72888_f(player instanceof Entity ? ((Entity)player).field_70157_k : 0, vec.intX(), vec.intY(), vec.intZ(), -1);
            }
            if (((b = Block.field_71973_m[world.func_72798_a(vec.intX(), vec.intY(), vec.intZ())]) == null || b.isAirBlock(world, vec.intX(), vec.intY(), vec.intZ())) && items != null) {
                for (ItemStack stack : items) {
                    InventoryUtility.dropItemStack(world, vec.translate(0.5), stack);
                }
            }
        }
    }

    @Cancelable
    public static class LaserMineBlockEvent
    extends LaserEvent {
        public Object shooter;

        public LaserMineBlockEvent(World world, Vector3 spot, Vector3 hit, Object shooter) {
            super(world, spot, hit);
            this.shooter = shooter;
        }
    }

    public static class LaserDropItemEvent
    extends LaserEvent {
        public List<ItemStack> items;

        public LaserDropItemEvent(World world, Vector3 spot, Vector3 hit, List<ItemStack> items) {
            super(world, spot, hit);
            this.items = items;
        }
    }

    public static class LaserMeltBlockEvent
    extends LaserEvent {
        public Object shooter;

        public LaserMeltBlockEvent(World world, Vector3 spot, Vector3 hit, Object shooter) {
            super(world, spot, hit);
            this.shooter = shooter;
        }
    }

    @Cancelable
    public static class LaserFiredPlayerEvent
    extends LaserFireEvent {
        public ItemStack laserItem;
        public MovingObjectPosition hit;

        public LaserFiredPlayerEvent(EntityPlayer player, MovingObjectPosition hit, ItemStack stack) {
            super(player.field_70170_p, new Vector3((Entity)player), new Vector3(hit), player);
            this.laserItem = stack;
            this.hit = hit;
        }
    }

    @Cancelable
    public static class LaserFireEvent
    extends LaserEvent {
        public Object shooter;

        public LaserFireEvent(World world, Vector3 spot, Vector3 target, Object shooter) {
            super(world, spot, target);
            this.shooter = shooter;
        }

        public LaserFireEvent(TileEntity tileEntity, MovingObjectPosition hit) {
            super(tileEntity.field_70331_k, new Vector3(tileEntity), new Vector3(hit));
            this.shooter = tileEntity;
        }
    }
}

