/*
 * Decompiled with CFR 0.152.
 */
package resonant.api.event;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Cancelable;
import net.minecraftforge.event.Event;
import resonant.api.event.MachineEvent;
import universalelectricity.api.vector.Vector3;

public class MachineMiningEvent
extends MachineEvent {
    public final Vector3 targetBlock;

    public MachineMiningEvent(World world, Vector3 spot, Vector3 target) {
        super(world, spot);
        this.targetBlock = target;
    }

    public static boolean doMachineMiningCheck(World world, Vector3 target, TileEntity machine) {
        Block block = Block.field_71973_m[target.getBlockID((IBlockAccess)world)];
        return block != null && target.getTileEntity((IBlockAccess)world) == null && !block.isAirBlock(world, target.intX(), target.intY(), target.intZ()) && block.func_71934_m(world, target.intX(), target.intY(), target.intZ()) >= 0.0f;
    }

    public static List<ItemStack> getItemsMined(World world, Vector3 spot, Vector3 target) {
        List<Object> items;
        Block block = Block.field_71973_m[target.getBlockID((IBlockAccess)world)];
        if (block != null && (items = block.getBlockDropped(world, target.intX(), target.intY(), target.intZ(), target.getBlockMetadata((IBlockAccess)world), 1)) != null) {
            MiningDrop event = new MiningDrop(world, spot, target, items);
            MinecraftForge.EVENT_BUS.post((Event)event);
            items = event.items;
            return items;
        }
        return null;
    }

    public static List<ItemStack> getItemsMined(TileEntity entity, Vector3 target) {
        return MachineMiningEvent.getItemsMined(entity.field_70331_k, new Vector3(entity), target);
    }

    public static class PostMine
    extends MachineMiningEvent {
        public PostMine(World world, Vector3 spot, Vector3 target) {
            super(world, spot, target);
        }
    }

    public static class MiningDrop
    extends MachineMiningEvent {
        List<ItemStack> items;

        public MiningDrop(World world, Vector3 spot, Vector3 target, List<ItemStack> items) {
            super(world, spot, target);
            this.items = items;
        }
    }

    @Cancelable
    public static class PreMine
    extends MachineMiningEvent {
        public PreMine(World world, Vector3 spot, Vector3 target) {
            super(world, spot, target);
        }
    }
}

