/*
 * Decompiled with CFR 0.152.
 */
package resonant.api.recipe;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class RecipeResource {
    public final boolean hasChance;
    public final float chance;

    protected RecipeResource() {
        this.hasChance = false;
        this.chance = 100.0f;
    }

    protected RecipeResource(float chance) {
        this.hasChance = true;
        this.chance = chance;
    }

    public boolean hasChance() {
        return this.hasChance;
    }

    public float getChance() {
        return this.chance;
    }

    public abstract ItemStack getItemStack();

    public static class FluidStackResource
    extends RecipeResource {
        public final FluidStack fluidStack;

        public FluidStackResource(FluidStack fs) {
            this.fluidStack = fs;
        }

        public FluidStackResource(FluidStack fs, float chance) {
            super(chance);
            this.fluidStack = fs;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FluidStackResource) {
                return this.equals(((FluidStackResource)obj).fluidStack);
            }
            return obj instanceof FluidStack ? ((FluidStack)obj).equals((Object)this.fluidStack) : false;
        }

        @Override
        public ItemStack getItemStack() {
            return null;
        }

        public String toString() {
            return "[FluidStackResource: " + this.fluidStack.getFluid().getName() + "]";
        }
    }

    public static class OreDictResource
    extends RecipeResource {
        public final String name;

        public OreDictResource(String s) {
            this.name = s;
            if (OreDictionary.getOres((String)this.name).size() <= 0) {
                throw new RuntimeException("Added invalid OreDictResource recipe: " + this.name);
            }
        }

        public OreDictResource(String s, float chance) {
            super(chance);
            this.name = s;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OreDictResource) {
                return this.name.equals(((OreDictResource)obj).name);
            }
            if (obj instanceof ItemStackResource) {
                return this.equals(((ItemStackResource)obj).itemStack);
            }
            if (obj instanceof ItemStack) {
                for (ItemStack is : OreDictionary.getOres((String)this.name).toArray(new ItemStack[0])) {
                    if (!is.func_77969_a((ItemStack)obj)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public ItemStack getItemStack() {
            return ((ItemStack)OreDictionary.getOres((String)this.name).get(0)).func_77946_l();
        }

        public String toString() {
            return "[OreDictResource: " + this.name + "]";
        }
    }

    public static class ItemStackResource
    extends RecipeResource {
        public final ItemStack itemStack;

        public ItemStackResource(ItemStack is) {
            this.itemStack = is;
        }

        public ItemStackResource(ItemStack is, float chance) {
            super(chance);
            this.itemStack = is;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemStackResource) {
                return this.itemStack.func_77969_a(((ItemStackResource)obj).itemStack);
            }
            if (obj instanceof ItemStack) {
                return this.itemStack.func_77969_a((ItemStack)obj);
            }
            return false;
        }

        @Override
        public ItemStack getItemStack() {
            return this.itemStack.func_77946_l();
        }

        public String toString() {
            return "[ItemStackResource: " + this.itemStack.toString() + "]";
        }
    }
}

