/*
 * Decompiled with CFR 0.152.
 */
package resonant.core.content.debug;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.core.ResonantEngine;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.prefab.block.BlockRotatable;
import resonant.lib.schematic.Schematic;
import resonant.lib.type.Pair;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlockCreativeBuilder
extends BlockRotatable
implements IPacketReceiver {
    public static final List<Schematic> REGISTRY = new ArrayList<Schematic>();

    public static int register(Schematic schematic) {
        REGISTRY.add(schematic);
        return REGISTRY.size() - 1;
    }

    public BlockCreativeBuilder(int id) {
        super(id, UniversalElectricity.machine);
        this.func_71849_a(CreativeTabs.field_78040_i);
        this.rotationMask = Byte.parseByte("111111", 2);
    }

    @Override
    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (REGISTRY.size() > 0) {
            par5EntityPlayer.openGui((Object)ResonantEngine.INSTANCE, -1, par1World, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        World world = player.field_70170_p;
        if (!world.field_72995_K && MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(player.field_71092_bJ)) {
            try {
                int schematicID = data.readInt();
                int size = data.readInt();
                Vector3 position = new Vector3((double)((Integer)extra[0]).intValue(), (double)((Integer)extra[1]).intValue(), (double)((Integer)extra[2]).intValue());
                if (size > 0) {
                    HashMap<Vector3, Pair<Integer, Integer>> map = REGISTRY.get(schematicID).getStructure(ForgeDirection.getOrientation((int)position.getBlockMetadata((IBlockAccess)world)), size);
                    for (Map.Entry<Vector3, Pair<Integer, Integer>> entry : map.entrySet()) {
                        Vector3 placePos = entry.getKey().clone();
                        placePos.translate((IVector3)position);
                        placePos.setBlock(world, entry.getValue().left().intValue(), entry.getValue().right().intValue());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

