/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.access;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonant.lib.access.AccessGroup;
import resonant.lib.access.User;
import resonant.lib.utility.nbt.ISaveObj;

public class AccessUser
extends User
implements ISaveObj {
    protected boolean isTempary = false;
    protected NBTTagCompound extraData;
    protected AccessGroup group;
    protected List<String> nodes = new ArrayList<String>();

    public AccessUser(String username) {
        super(username);
    }

    public AccessUser(EntityPlayer player) {
        super(player.field_71092_bJ);
    }

    public AccessGroup getGroup() {
        return this.group;
    }

    public AccessUser setGroup(AccessGroup group) {
        this.group = group;
        return this;
    }

    public boolean hasNode(String node) {
        if (node != null && !node.isEmpty()) {
            String newNode = node;
            String[] sub_nodes = (newNode = newNode.replaceAll(".*", "")).split(".");
            if (sub_nodes != null && sub_nodes.length > 0) {
                newNode = "";
                for (int i = 0; i < sub_nodes.length; ++i) {
                    if (!this.nodes.contains((newNode = newNode + (i != 0 ? "." : "") + sub_nodes[i]) + ".*") && (this.group == null || !this.group.hasNode(newNode + ".*")) && !this.nodes.contains(newNode) && (this.group == null || !this.group.hasNode(newNode))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74778_a("username", this.username);
        nbt.func_74766_a("extraData", this.userData());
        NBTTagList usersTag = new NBTTagList();
        for (String str : this.nodes) {
            NBTTagCompound accessData = new NBTTagCompound();
            accessData.func_74778_a("name", str);
            usersTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("nodes", (NBTBase)usersTag);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.username = nbt.func_74779_i("username");
        this.extraData = nbt.func_74775_l("extraData");
        NBTTagList userList = nbt.func_74761_m("nodes");
        this.nodes.clear();
        for (int i = 0; i < userList.func_74745_c(); ++i) {
            this.nodes.add(((NBTTagCompound)userList.func_74743_b(i)).func_74779_i("name"));
        }
    }

    public static AccessUser loadFromNBT(NBTTagCompound nbt) {
        AccessUser user = new AccessUser("");
        user.load(nbt);
        return user;
    }

    public AccessUser setTempary(boolean si) {
        this.isTempary = si;
        return this;
    }

    public NBTTagCompound userData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }
}

