/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import resonant.lib.access.AccessGroup;
import resonant.lib.access.AccessProfile;
import resonant.lib.access.AccessUser;
import resonant.lib.access.IProfileContainer;

public class AccessUtility {
    public static final Set<String> nodes = new LinkedHashSet<String>();
    public static final HashMap<String, List<String>> groupDefaultNodes = new LinkedHashMap<String, List<String>>();
    public static final HashMap<String, String> groupDefaultExtends = new LinkedHashMap<String, String>();

    public static void createDefaultGroup(String name, String prefabGroup, List<String> nodes) {
        if (name != null) {
            groupDefaultNodes.put(name, nodes);
            groupDefaultExtends.put(name, prefabGroup);
        }
    }

    public static void createDefaultGroup(String name, String prefabGroup, String ... nodes) {
        AccessUtility.createDefaultGroup(name, prefabGroup, nodes != null ? Arrays.asList(nodes) : null);
    }

    public static List<AccessGroup> buildNewGroup() {
        AccessGroup group;
        ArrayList<AccessGroup> groups = new ArrayList<AccessGroup>();
        for (Map.Entry<String, List<String>> entry : groupDefaultNodes.entrySet()) {
            group = new AccessGroup(entry.getKey(), new AccessUser[0]);
            if (entry.getValue() != null) {
                for (String string : entry.getValue()) {
                    group.addNode(string);
                }
            }
            groups.add(group);
        }
        for (Map.Entry<String, Object> entry : groupDefaultExtends.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty()) continue;
            group = AccessUtility.getGroup(groups, entry.getKey());
            AccessGroup groupToExtend = AccessUtility.getGroup(groups, (String)entry.getValue());
            if (group == null || groupToExtend == null) continue;
            group.setToExtend(groupToExtend);
        }
        return groups;
    }

    public static void loadNewGroupSet(IProfileContainer container) {
        if (container != null) {
            AccessUtility.loadNewGroupSet(container.getAccessProfile());
        }
    }

    public static void loadNewGroupSet(AccessProfile profile) {
        if (profile != null) {
            List<AccessGroup> groups = AccessUtility.buildNewGroup();
            for (AccessGroup group : groups) {
                profile.addGroup(group);
            }
        }
    }

    public static AccessGroup getGroup(Collection<AccessGroup> groups, String name) {
        for (AccessGroup group : groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    public static void register(String node) {
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("profile.owner");
        list.add("inv.disable");
        list.add("inv.enable");
        list.add("profile.*");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("profile.admin");
        list2.add("inv.edit");
        list2.add("inv.lock");
        list2.add("inv.unlock");
        list2.add("inv.change");
        list2.add("group.*");
        ArrayList<String> list3 = new ArrayList<String>();
        list3.add("profile.user");
        list3.add("inv.open");
        list3.add("inv.take");
        list3.add("inv.give");
        AccessUtility.createDefaultGroup("user", null, list3);
        AccessUtility.createDefaultGroup("admin", "user", list2);
        AccessUtility.createDefaultGroup("owner", "admin", list);
    }
}

