/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.content.module;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRotatable;
import resonant.lib.content.module.BlockDummy;
import resonant.lib.content.module.TileRender;
import resonant.lib.prefab.item.ItemBlockTooltip;
import resonant.lib.prefab.vector.Cuboid;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.WrenchUtility;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public abstract class TileBlock
extends TileEntity {
    public final String name;
    public final Material material;
    public Class<? extends ItemBlock> itemBlock = ItemBlockTooltip.class;
    public CreativeTabs creativeTab = null;
    public Cuboid bounds = Cuboid.full();
    public BlockDummy block;
    public float blockHardness = 1.0f;
    public float blockResistance = 1.0f;
    public boolean canProvidePower = false;
    public boolean tickRandomly = false;
    public boolean normalRender = true;
    public boolean forceStandardRender = false;
    public boolean customItemRender = false;
    public boolean isOpaqueCube = true;
    public IBlockAccess access;
    protected String textureName;
    protected String domain;
    protected byte rotationMask = Byte.parseByte("111100", 2);
    protected boolean isFlipPlacement = false;

    public TileBlock(String newName, Material newMaterial) {
        this.name = newName;
        this.material = newMaterial;
        this.textureName = this.name;
    }

    public TileBlock(Material newMaterial) {
        this.name = LanguageUtility.decapitalizeFirst(((Object)((Object)this)).getClass().getSimpleName().replaceFirst("Tile", ""));
        this.material = newMaterial;
        this.textureName = this.name;
    }

    public static Vector2 getClickedFace(byte hitSide, float hitX, float hitY, float hitZ) {
        switch (hitSide) {
            case 0: {
                return new Vector2((double)(1.0f - hitX), (double)hitZ);
            }
            case 1: {
                return new Vector2((double)hitX, (double)hitZ);
            }
            case 2: {
                return new Vector2((double)(1.0f - hitX), (double)(1.0f - hitY));
            }
            case 3: {
                return new Vector2((double)hitX, (double)(1.0f - hitY));
            }
            case 4: {
                return new Vector2((double)hitZ, (double)(1.0f - hitY));
            }
            case 5: {
                return new Vector2((double)(1.0f - hitZ), (double)(1.0f - hitY));
            }
        }
        return new Vector2(0.5, 0.5);
    }

    public void onInstantiate() {
    }

    public World world() {
        return this.field_70331_k;
    }

    public IBlockAccess access() {
        if (this.world() != null) {
            return this.world();
        }
        return this.access;
    }

    public int x() {
        assert (this.world() != null) : "TileBlock [" + ((Object)((Object)this)).getClass().getSimpleName() + "] attempted to access invalid method.";
        return this.field_70329_l;
    }

    public int y() {
        assert (this.world() != null) : "TileBlock [" + ((Object)((Object)this)).getClass().getSimpleName() + "] attempted to access invalid method.";
        return this.field_70330_m;
    }

    public int z() {
        assert (this.world() != null) : "TileBlock [" + ((Object)((Object)this)).getClass().getSimpleName() + "] attempted to access invalid method.";
        return this.field_70327_n;
    }

    public VectorWorld position() {
        assert (this.world() != null) : "TileBlock [" + ((Object)((Object)this)).getClass().getSimpleName() + "] attempted to access invalid method.";
        return new VectorWorld((TileEntity)this);
    }

    protected VectorWorld center() {
        assert (this.world() != null) : "TileBlock [" + ((Object)((Object)this)).getClass().getSimpleName() + "] attempted to access invalid method.";
        return (VectorWorld)this.position().translate(0.5);
    }

    public Block func_70311_o() {
        if (this.access() != null) {
            Block b = Block.field_71973_m[this.access().func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)];
            if (b == null) {
                return this.block;
            }
            return b;
        }
        return this.block;
    }

    public TileBlock tile() {
        return null;
    }

    public Block block() {
        return Block.field_71973_m[this.blockID()];
    }

    public int blockID() {
        if (this.access() != null) {
            return this.access().func_72798_a(this.x(), this.y(), this.z());
        }
        return this.block.field_71990_ca;
    }

    public int metadata() {
        return this.access().func_72805_g(this.x(), this.y(), this.z());
    }

    public ArrayList<ItemStack> getDrops(int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.func_70311_o() != null) {
            drops.add(new ItemStack(this.func_70311_o(), this.quantityDropped(metadata, fortune), this.metadataDropped(metadata, fortune)));
        }
        return drops;
    }

    public int quantityDropped(int meta, int fortune) {
        return 1;
    }

    public int metadataDropped(int meta, int fortune) {
        return 0;
    }

    public boolean isControlDown(EntityPlayer player) {
        try {
            Class<?> ckm = Class.forName("codechicken.multipart.ControlKeyModifer");
            Method m = ckm.getMethod("isControlDown", EntityPlayer.class);
            return (Boolean)m.invoke(null, player);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void getSubBlocks(int id, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(id, 1, 0));
    }

    public ItemStack getPickBlock(MovingObjectPosition target) {
        return new ItemStack(this.func_70311_o(), 1, this.metadataDropped(this.metadata(), 0));
    }

    public int getLightValue(IBlockAccess access) {
        return Block.field_71984_q[access.func_72798_a(this.x(), this.y(), this.z())];
    }

    public void click(EntityPlayer player) {
    }

    public boolean activate(EntityPlayer player, int side, Vector3 hit) {
        if (WrenchUtility.isUsableWrench(player, player.field_71071_by.func_70448_g(), this.x(), this.y(), this.z())) {
            if (this.configure(player, side, hit)) {
                WrenchUtility.damageWrench(player, player.field_71071_by.func_70448_g(), this.x(), this.y(), this.z());
                return true;
            }
            return false;
        }
        return this.use(player, side, hit);
    }

    protected boolean use(EntityPlayer player, int side, Vector3 hit) {
        return false;
    }

    protected boolean configure(EntityPlayer player, int side, Vector3 hit) {
        return this.tryRotate(side, hit);
    }

    protected boolean tryRotate(int side, Vector3 hit) {
        byte result;
        if (this instanceof IRotatable && (result = this.getSideToRotate((byte)side, hit.x, hit.y, hit.z)) != -1) {
            this.setDirection(ForgeDirection.getOrientation((int)result));
            return true;
        }
        return false;
    }

    public byte getSideToRotate(byte hitSide, double hitX, double hitY, double hitZ) {
        byte tBack = (byte)(hitSide ^ 1);
        switch (hitSide) {
            case 0: 
            case 1: {
                if (hitX < 0.25) {
                    if (hitZ < 0.25 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (hitZ > 0.75 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (this.canRotate(4)) {
                        return 4;
                    }
                }
                if (hitX > 0.75) {
                    if (hitZ < 0.25 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (hitZ > 0.75 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (this.canRotate(5)) {
                        return 5;
                    }
                }
                if (hitZ < 0.25 && this.canRotate(2)) {
                    return 2;
                }
                if (hitZ > 0.75 && this.canRotate(3)) {
                    return 3;
                }
                if (this.canRotate(hitSide)) {
                    return hitSide;
                }
            }
            case 2: 
            case 3: {
                if (hitX < 0.25) {
                    if (hitY < 0.25 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (hitY > 0.75 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (this.canRotate(4)) {
                        return 4;
                    }
                }
                if (hitX > 0.75) {
                    if (hitY < 0.25 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (hitY > 0.75 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (this.canRotate(5)) {
                        return 5;
                    }
                }
                if (hitY < 0.25 && this.canRotate(0)) {
                    return 0;
                }
                if (hitY > 0.75 && this.canRotate(1)) {
                    return 1;
                }
                if (this.canRotate(hitSide)) {
                    return hitSide;
                }
            }
            case 4: 
            case 5: {
                if (hitZ < 0.25) {
                    if (hitY < 0.25 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (hitY > 0.75 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (this.canRotate(2)) {
                        return 2;
                    }
                }
                if (hitZ > 0.75) {
                    if (hitY < 0.25 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (hitY > 0.75 && this.canRotate(tBack)) {
                        return tBack;
                    }
                    if (this.canRotate(3)) {
                        return 3;
                    }
                }
                if (hitY < 0.25 && this.canRotate(0)) {
                    return 0;
                }
                if (hitY > 0.75 && this.canRotate(1)) {
                    return 1;
                }
                if (!this.canRotate(hitSide)) break;
                return hitSide;
            }
        }
        return -1;
    }

    public ForgeDirection determineOrientation(EntityLivingBase entityLiving) {
        int returnSide;
        int playerSide;
        if (MathHelper.func_76135_e((float)((float)entityLiving.field_70165_t - (float)this.x())) < 2.0f && MathHelper.func_76135_e((float)((float)entityLiving.field_70161_v - (float)this.z())) < 2.0f) {
            double d0 = entityLiving.field_70163_u + 1.82 - (double)entityLiving.field_70129_M;
            if (this.canRotate(1) && d0 - (double)this.y() > 2.0) {
                return ForgeDirection.UP;
            }
            if (this.canRotate(0) && (double)this.y() - d0 > 0.0) {
                return ForgeDirection.DOWN;
            }
        }
        int n = (playerSide = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 && this.canRotate(2) ? 2 : (playerSide == 1 && this.canRotate(5) ? 5 : (playerSide == 2 && this.canRotate(3) ? 3 : (returnSide = playerSide == 3 && this.canRotate(4) ? 4 : 0)));
        if (this.isFlipPlacement) {
            return ForgeDirection.getOrientation((int)returnSide).getOpposite();
        }
        return ForgeDirection.getOrientation((int)returnSide);
    }

    public boolean canRotate(int ord) {
        return (this.rotationMask & 1 << ord) != 0;
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.metadata());
    }

    public void setDirection(ForgeDirection direction) {
        this.world().func_72921_c(this.x(), this.y(), this.z(), direction.ordinal(), 3);
    }

    protected void onAdded() {
        this.onWorldJoin();
    }

    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        if (this instanceof IRotatable) {
            ((IRotatable)((Object)this)).setDirection(this.determineOrientation(entityLiving));
        }
    }

    public void onRemove(int par5, int par6) {
        this.onWorldSeparate();
    }

    protected void onWorldJoin() {
    }

    protected void onWorldSeparate() {
    }

    protected void onNeighborChanged() {
    }

    protected void notifyChange() {
        this.world().func_72898_h(this.x(), this.y(), this.z(), this.blockID());
    }

    protected void markRender() {
        this.world().func_72902_n(this.x(), this.y(), this.z());
    }

    protected void markUpdate() {
        this.world().func_72845_h(this.x(), this.y(), this.z());
    }

    protected void updateLight() {
        this.world().func_72969_x(this.x(), this.y(), this.z());
    }

    protected void scheduelTick(int delay) {
        this.world().func_72836_a(this.x(), this.y(), this.z(), this.blockID(), delay);
    }

    public void collide(Entity entity) {
    }

    public Iterable<Cuboid> getCollisionBoxes(Cuboid intersect, Entity entity) {
        ArrayList<Cuboid> boxes = new ArrayList<Cuboid>();
        for (Cuboid cuboid : this.getCollisionBoxes()) {
            if (intersect == null || !cuboid.intersects(intersect)) continue;
            boxes.add(cuboid);
        }
        return boxes;
    }

    public Iterable<Cuboid> getCollisionBoxes() {
        return Arrays.asList(this.bounds);
    }

    public Cuboid getSelectBounds() {
        return this.bounds;
    }

    public Cuboid getCollisionBounds() {
        return this.bounds;
    }

    @SideOnly(value=Side.CLIENT)
    public final TileRender getRenderer() {
        if (!RenderInfo.renderer.containsKey((Object)this)) {
            RenderInfo.renderer.put(this, this.newRenderer());
        }
        return (TileRender)RenderInfo.renderer.get((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(IBlockAccess access, int side) {
        return this.getIcon(side, access.func_72805_g(this.x(), this.y(), this.z()));
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        return this.getIcon();
    }

    public Icon getIcon() {
        return (Icon)RenderInfo.icon.get(this.getTextureName());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        RenderInfo.icon.put(this.getTextureName(), iconRegister.func_94245_a(this.getTextureName()));
    }

    @SideOnly(value=Side.CLIENT)
    protected String getTextureName() {
        return this.textureName == null ? "MISSING_ICON_TILE_" + this.func_70311_o().field_71990_ca + "_" + this.name : this.block.dummyTile.domain + this.textureName;
    }

    public boolean shouldSideBeRendered(IBlockAccess access, int x, int y, int z, int side) {
        return side == 0 && this.bounds.min.y > 0.0 ? true : (side == 1 && this.bounds.max.y < 1.0 ? true : (side == 2 && this.bounds.min.z > 0.0 ? true : (side == 3 && this.bounds.max.z < 1.0 ? true : (side == 4 && this.bounds.min.x > 0.0 ? true : (side == 5 && this.bounds.max.x < 1.0 ? true : !access.func_72804_r(x, y, z))))));
    }

    public void onFillRain() {
    }

    public boolean isIndirectlyPowered() {
        return this.world().func_72864_z(this.x(), this.y(), this.z());
    }

    public int getStrongestIndirectPower() {
        return this.world().func_94572_D(this.x(), this.y(), this.z());
    }

    public int getWeakRedstonePower(IBlockAccess access, int side) {
        return this.getStrongRedstonePower(access, side);
    }

    public int getStrongRedstonePower(IBlockAccess access, int side) {
        return 0;
    }

    public boolean isSolid(IBlockAccess access, int side) {
        return this.material.func_76220_a();
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public int tickRate(World world) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public static class RenderInfo {
        @SideOnly(value=Side.CLIENT)
        private static final WeakHashMap<TileBlock, TileRender> renderer = new WeakHashMap();
        @SideOnly(value=Side.CLIENT)
        private static final HashMap<String, Icon> icon = new HashMap();
    }

    public static interface IComparatorInputOverride {
        public int getComparatorInputOverride(int var1);
    }
}

