/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.flag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import resonant.lib.flag.Flag;
import resonant.lib.flag.FlagBase;
import resonant.lib.flag.FlagRegion;
import resonant.lib.prefab.vector.Cuboid;
import universalelectricity.api.vector.Vector3;

public class FlagWorld
extends FlagBase {
    public static final String GLOBAL_REGION = "dimension";
    public World world;
    private final List<FlagRegion> regions = new ArrayList<FlagRegion>();

    public FlagWorld(World world) {
        this.world = world;
    }

    public FlagWorld(NBTTagCompound nbt) {
        this.load(nbt);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Dim")) {
            this.world = WorldProvider.func_76570_a((int)nbt.func_74762_e((String)"Dim")).field_76579_a;
            NBTTagList nbtList = nbt.func_74761_m("Regions");
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = (NBTTagCompound)nbtList.func_74743_b(i);
                FlagRegion flagRegion = new FlagRegion(this);
                flagRegion.load(stackTag);
                this.regions.add(flagRegion);
            }
        } else {
            for (NBTTagCompound childCompound : nbt.func_74758_c()) {
                try {
                    FlagRegion flagRegion = new FlagRegion(this);
                    flagRegion.load(childCompound);
                    this.regions.add(flagRegion);
                }
                catch (Exception e) {
                    System.out.println("Mod Flag: Failed to read flag data: " + childCompound.func_74740_e());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74768_a("Dim", this.world.field_73011_w.field_76574_g);
        NBTTagList nbtRegionList = new NBTTagList();
        for (FlagRegion region : this.regions) {
            try {
                NBTTagCompound flagCompound = new NBTTagCompound();
                region.save(flagCompound);
                nbtRegionList.func_74742_a((NBTBase)flagCompound);
            }
            catch (Exception e) {
                System.out.println("Failed to save world flag data: " + region.name);
                e.printStackTrace();
            }
        }
        nbt.func_74782_a("Regions", (NBTBase)nbtRegionList);
    }

    public List<Flag> getFlagsInPosition(Vector3 position) {
        ArrayList<Flag> returnFlags = new ArrayList<Flag>();
        for (FlagRegion flagRegion : this.regions) {
            if (!flagRegion.region.isIn(position) && !flagRegion.name.equalsIgnoreCase(GLOBAL_REGION)) continue;
            for (Flag flag : flagRegion.getFlags()) {
                returnFlags.add(flag);
            }
        }
        return returnFlags;
    }

    public List<String> getValues(String flagName, Vector3 position) {
        ArrayList<String> values = new ArrayList<String>();
        for (Flag flag : this.getFlagsInPosition(position)) {
            values.add(flag.value);
        }
        return values;
    }

    public boolean containsValue(String flagName, String checkValue, Vector3 position) {
        for (Flag flag : this.getFlagsInPosition(position)) {
            if (!flag.name.equalsIgnoreCase(flagName) || !flag.value.equalsIgnoreCase(checkValue)) continue;
            return true;
        }
        return false;
    }

    public boolean addRegion(String name, Vector3 position, int radius) {
        Vector3 minVec = new Vector3((double)(position.intX() - radius), 0.0, (double)(position.intZ() - radius));
        Vector3 maxVec = new Vector3((double)(position.intX() + radius), (double)this.world.func_72800_K(), (double)(position.intZ() + radius));
        return this.regions.add(new FlagRegion(this, name, new Cuboid(minVec, maxVec)));
    }

    public FlagRegion getRegion(String name) {
        for (FlagRegion region : this.regions) {
            if (!region.name.equals(name)) continue;
            return region;
        }
        return null;
    }

    public List<FlagRegion> getRegions(Vector3 position) {
        ArrayList<FlagRegion> returnRegions = new ArrayList<FlagRegion>();
        for (FlagRegion region : this.regions) {
            if (!region.region.isIn(position)) continue;
            returnRegions.add(region);
        }
        return returnRegions;
    }

    public boolean removeRegion(String name) {
        for (FlagRegion region : this.regions) {
            if (!region.name.equals(name)) continue;
            this.regions.remove(region);
            return true;
        }
        return false;
    }

    public List<FlagRegion> getRegions() {
        Iterator<FlagRegion> it = this.regions.iterator();
        while (it.hasNext()) {
            FlagRegion region = it.next();
            if (region == null) {
                it.remove();
                continue;
            }
            if (region.name != null && region.name != "") continue;
            it.remove();
        }
        return this.regions;
    }
}

