/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.flag;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import resonant.lib.References;
import resonant.lib.flag.FlagBase;
import resonant.lib.flag.FlagWorld;
import resonant.lib.utility.nbt.IVirtualObject;
import resonant.lib.utility.nbt.NBTUtility;
import resonant.lib.utility.nbt.SaveManager;
import universalelectricity.api.vector.Vector3;

public class ModFlag
extends FlagBase
implements IVirtualObject {
    private final HashMap<Integer, FlagWorld> flagWorlds = new HashMap();
    private String name = "ModFlags";

    public ModFlag() {
        SaveManager.register(this);
    }

    public ModFlag(String name) {
        this();
        this.name = name;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
            NBTTagList nbtList = nbt.func_74761_m("WorldFlags");
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = (NBTTagCompound)nbtList.func_74743_b(i);
                FlagWorld flagWorld = new FlagWorld(stackTag);
                this.flagWorlds.put(flagWorld.world.field_73011_w.field_76574_g, flagWorld);
            }
        } else {
            for (Object tag : nbt.func_74758_c()) {
                if (!(tag instanceof NBTTagCompound)) continue;
                NBTTagCompound dimensionCompound = (NBTTagCompound)tag;
                try {
                    int dimensionID = Integer.parseInt(dimensionCompound.func_74740_e().replace("dim_", ""));
                    WorldServer world = DimensionManager.getWorld((int)dimensionID);
                    FlagWorld flagWorld = new FlagWorld((World)world);
                    flagWorld.load(dimensionCompound);
                    this.flagWorlds.put(dimensionID, flagWorld);
                }
                catch (Exception e) {
                    References.LOGGER.severe("Mod Flag: Failed to read dimension data: " + dimensionCompound.func_74740_e());
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        NBTTagList nbtFlagWorldList = new NBTTagList();
        for (Map.Entry<Integer, FlagWorld> entry : this.flagWorlds.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                NBTTagCompound worldFlagNBT = new NBTTagCompound();
                entry.getValue().save(worldFlagNBT);
                nbtFlagWorldList.func_74742_a((NBTBase)worldFlagNBT);
            }
            catch (Exception e) {
                References.LOGGER.severe("Mod Flag: Failed to save world flag data: " + entry.getValue().world.field_73011_w.field_76574_g);
                e.printStackTrace();
            }
        }
        nbt.func_74782_a("WorldFlags", (NBTBase)nbtFlagWorldList);
    }

    public FlagWorld getFlagWorld(World world) {
        FlagWorld worldData = null;
        if (world != null && (worldData = this.flagWorlds.get(world.field_73011_w.field_76574_g)) == null) {
            worldData = new FlagWorld(world);
            this.flagWorlds.put(world.field_73011_w.field_76574_g, worldData);
        }
        return worldData;
    }

    public boolean containsValue(World world, String flagName, String checkValue, Vector3 position) {
        return this.getFlagWorld(world).containsValue(flagName, checkValue, position);
    }

    public HashMap<Integer, FlagWorld> getFlagWorlds() {
        return this.flagWorlds;
    }

    @Override
    public File getSaveFile() {
        return new File(NBTUtility.getSaveDirectory(), this.name + ".dat");
    }

    @Override
    public void setSaveFile(File file) {
    }
}

