/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.grid;

import java.util.AbstractMap;
import java.util.WeakHashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonant.lib.grid.Grid;

public abstract class Node<P extends INodeProvider, G extends Grid, N>
implements INode {
    public final P parent;
    protected final AbstractMap<N, ForgeDirection> connections = new WeakHashMap<N, ForgeDirection>();
    public G grid = null;

    public Node(P parent) {
        this.parent = parent;
    }

    public final G getGrid() {
        if (this.grid == null) {
            this.grid = this.newGrid();
        }
        return this.grid;
    }

    protected abstract G newGrid();

    public final void setGrid(G grid) {
        this.grid = grid;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public void reconstruct() {
        this.recache();
        ((Grid)this.getGrid()).add((Node)this);
        ((Grid)this.getGrid()).reconstruct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deconstruct() {
        AbstractMap<N, ForgeDirection> abstractMap = this.connections;
        synchronized (abstractMap) {
            for (N connection : this.connections.keySet()) {
                if (!((Grid)this.getGrid()).isValidNode(connection)) continue;
                ((Node)connection).getConnections().remove(this);
            }
            ((Grid)this.getGrid()).remove((Node)this);
            ((Grid)this.getGrid()).deconstruct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recache() {
        AbstractMap<N, ForgeDirection> abstractMap = this.connections;
        synchronized (abstractMap) {
            this.doRecache();
        }
    }

    protected void doRecache() {
    }

    public AbstractMap<N, ForgeDirection> getConnections() {
        return this.connections;
    }

    public boolean canConnect(ForgeDirection from, Object source) {
        return false;
    }

    public void load(NBTTagCompound nbt) {
    }

    public void save(NBTTagCompound nbt) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.hashCode() + ", Connections: " + this.connections.size() + ", Grid:" + this.getGrid() + "]";
    }
}

