/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.grid;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.api.net.IUpdate;

public class UpdateTicker
extends Thread {
    public static final UpdateTicker INSTANCE = new UpdateTicker();
    private final Set<IUpdate> updaters = Collections.newSetFromMap(new WeakHashMap());
    private final Queue<Event> queuedEvents = new ConcurrentLinkedQueue<Event>();
    public boolean pause = false;
    private long deltaTime;

    public UpdateTicker() {
        this.setName("Universal Electricity");
        this.setPriority(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNetwork(IUpdate updater) {
        Set<IUpdate> set = UpdateTicker.INSTANCE.updaters;
        synchronized (set) {
            UpdateTicker.INSTANCE.updaters.add(updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void queueEvent(Event event) {
        Queue<Event> queue = UpdateTicker.INSTANCE.queuedEvents;
        synchronized (queue) {
            UpdateTicker.INSTANCE.queuedEvents.add(event);
        }
    }

    public long getDeltaTime() {
        return this.deltaTime;
    }

    public int getUpdaterCount() {
        return this.updaters.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long last = System.currentTimeMillis();
            while (true) {
                if (!this.pause) {
                    long current = System.currentTimeMillis();
                    this.deltaTime = current - last;
                    Collection<Object> collection = this.updaters;
                    synchronized (collection) {
                        Set removeUpdaters = Collections.newSetFromMap(new WeakHashMap());
                        Iterator<IUpdate> updaterIt = new HashSet<IUpdate>(this.updaters).iterator();
                        try {
                            while (updaterIt.hasNext()) {
                                IUpdate updater = updaterIt.next();
                                if (updater.canUpdate()) {
                                    updater.update();
                                }
                                if (updater.continueUpdate()) continue;
                                removeUpdaters.add(updater);
                            }
                            this.updaters.removeAll(removeUpdaters);
                        }
                        catch (Exception e) {
                            System.out.println("Universal Electricity Threaded Ticker: Failed while tcking updater. This is a bug! Clearing all tickers for self repair.");
                            this.updaters.clear();
                            e.printStackTrace();
                        }
                    }
                    collection = this.queuedEvents;
                    synchronized (collection) {
                        while (!this.queuedEvents.isEmpty()) {
                            MinecraftForge.EVENT_BUS.post(this.queuedEvents.poll());
                        }
                    }
                    last = current;
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

