/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.modproxy;

import cpw.mods.fml.common.Loader;
import java.util.LinkedList;
import java.util.List;
import resonant.lib.modproxy.ICompatProxy;
import resonant.lib.modproxy.LoadPhase;

public class ProxyHandler {
    private List<ICompatProxy> compatModulesList = new LinkedList<ICompatProxy>();
    private LoadPhase phase = LoadPhase.PRELAUNCH;

    public void applyModule(Class<?> clazz, boolean load) {
        if (!load) {
            return;
        }
        ICompatProxy subProxy = null;
        try {
            Object module = clazz.newInstance();
            if (module instanceof ICompatProxy) {
                subProxy = (ICompatProxy)module;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (subProxy != null && Loader.isModLoaded((String)subProxy.modId())) {
            this.compatModulesList.add(subProxy);
        }
    }

    @Deprecated
    public void applyModule(ICompatProxy module) {
        boolean registered = false;
        if (Loader.isModLoaded((String)module.modId())) {
            this.compatModulesList.add(module);
            registered = true;
        }
        if (registered) {
            switch (this.phase) {
                case DONE: {
                    break;
                }
                case POSTINIT: {
                    module.preInit();
                    module.init();
                    module.preInit();
                    break;
                }
                case INIT: {
                    module.preInit();
                    module.init();
                    break;
                }
            }
        }
    }

    public void preInit() {
        this.phase = LoadPhase.PREINIT;
        for (ICompatProxy proxy : this.compatModulesList) {
            proxy.preInit();
        }
        System.out.println("subProxy list: " + this.compatModulesList);
    }

    public void init() {
        this.phase = LoadPhase.INIT;
        for (ICompatProxy proxy : this.compatModulesList) {
            proxy.init();
        }
    }

    public void postInit() {
        this.phase = LoadPhase.POSTINIT;
        for (ICompatProxy proxy : this.compatModulesList) {
            proxy.postInit();
        }
        this.phase = LoadPhase.DONE;
    }
}

