/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.multiblock;

import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import resonant.lib.multiblock.IMultiBlockStructure;
import resonant.lib.utility.nbt.ISaveObj;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class MultiBlockHandler<W extends IMultiBlockStructure>
implements ISaveObj {
    protected WeakReference<W> prim = null;
    protected Vector3 newPrimary = null;
    protected final W self;
    protected Class<? extends W> wrapperClass;

    public MultiBlockHandler(W wrapper) {
        this.self = wrapper;
        this.wrapperClass = wrapper.getClass();
    }

    public void update() {
        W checkWrapper;
        if (this.self.getWorld() != null && this.newPrimary != null && (checkWrapper = this.getWrapperAt(this.newPrimary.clone().translate((IVector3)this.self.getPosition()))) != null) {
            this.newPrimary = null;
            if (checkWrapper != this.getPrimary()) {
                this.prim = new WeakReference<W>(checkWrapper);
                this.self.onMultiBlockChanged();
            }
        }
    }

    public boolean toggleConstruct() {
        if (!this.construct()) {
            return this.deconstruct();
        }
        return true;
    }

    public Set<W> getStructure() {
        Vector3[] vectors;
        LinkedHashSet<W> structure = new LinkedHashSet<W>();
        for (Vector3 vector : vectors = this.self.getMultiBlockVectors()) {
            W checkWrapper = this.getWrapperAt(vector.translate((IVector3)this.self.getPosition()));
            if (checkWrapper == null) {
                structure.clear();
                return null;
            }
            structure.add(checkWrapper);
        }
        return structure;
    }

    public boolean construct() {
        Set<W> structures;
        if (!this.isConstructed() && (structures = this.getStructure()) != null) {
            for (IMultiBlockStructure structure : structures) {
                if (!structure.getMultiBlock().isConstructed()) continue;
                return false;
            }
            this.prim = new WeakReference<W>(this.self);
            for (IMultiBlockStructure structure : structures) {
                structure.getMultiBlock().prim = this.prim;
            }
            for (IMultiBlockStructure structure : structures) {
                structure.onMultiBlockChanged();
            }
            return true;
        }
        return false;
    }

    public boolean deconstruct() {
        if (this.isConstructed()) {
            if (this.isPrimary()) {
                Set<W> structures = this.getStructure();
                if (structures != null) {
                    for (IMultiBlockStructure structure : structures) {
                        structure.getMultiBlock().prim = null;
                    }
                    for (IMultiBlockStructure structure : structures) {
                        structure.onMultiBlockChanged();
                    }
                }
            } else {
                this.getPrimary().getMultiBlock().deconstruct();
            }
            return true;
        }
        return false;
    }

    public W getWrapperAt(Vector3 position) {
        TileEntity tile = position.getTileEntity((IBlockAccess)this.self.getWorld());
        if (tile != null && this.wrapperClass.isAssignableFrom(tile.getClass())) {
            return (W)((IMultiBlockStructure)tile);
        }
        return null;
    }

    public boolean isConstructed() {
        return this.prim != null;
    }

    public boolean isPrimary() {
        return !this.isConstructed() || this.getPrimary() == this.self;
    }

    public W getPrimary() {
        return (W)(this.prim == null ? null : (IMultiBlockStructure)this.prim.get());
    }

    public W get() {
        return this.getPrimary() != null ? this.getPrimary() : this.self;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("primaryMultiBlock")) {
            this.newPrimary = new Vector3(nbt.func_74775_l("primaryMultiBlock"));
            this.update();
        } else {
            this.prim = null;
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        if (this.isConstructed()) {
            nbt.func_74782_a("primaryMultiBlock", (NBTBase)this.getPrimary().getPosition().subtract((IVector3)this.self.getPosition()).writeToNBT(new NBTTagCompound()));
        }
    }
}

