/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import resonant.lib.References;
import resonant.lib.network.PacketType;
import resonant.lib.utility.nbt.ISaveObj;
import universalelectricity.api.vector.IVector2;
import universalelectricity.api.vector.IVector3;

public class PacketHandler
implements IPacketHandler {
    public static final ArrayList<PacketType> registeredPackets = new ArrayList();

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.field_73629_c);
            byte packetID = data.readByte();
            EntityPlayer entityPlayer = (EntityPlayer)player;
            registeredPackets.get(packetID).receivePacket(data, entityPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeData(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (dataValue instanceof IVector3) {
                    data.writeDouble(((IVector3)dataValue).x());
                    data.writeDouble(((IVector3)dataValue).y());
                    data.writeDouble(((IVector3)dataValue).z());
                    continue;
                }
                if (dataValue instanceof IVector2) {
                    data.writeDouble(((IVector2)dataValue).x());
                    data.writeDouble(((IVector2)dataValue).y());
                    continue;
                }
                if (dataValue instanceof NBTTagCompound) {
                    PacketHandler.writeNBTTagCompound((NBTTagCompound)dataValue, data);
                    continue;
                }
                if (dataValue instanceof FluidTank) {
                    data.writeInt(((FluidTank)dataValue).getCapacity());
                    PacketHandler.writeNBTTagCompound(((FluidTank)dataValue).writeToNBT(new NBTTagCompound()), data);
                    continue;
                }
                if (dataValue instanceof ISaveObj) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    ((ISaveObj)dataValue).save(nbt);
                    PacketHandler.writeNBTTagCompound(nbt, data);
                    continue;
                }
                References.LOGGER.severe("Resonant Engine packet attempt to write an invalid type: " + dataValue.getClass());
            }
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
        }
    }

    public static NBTTagCompound readNBTTagCompound(DataInput reader) throws IOException {
        Short short1 = reader.readShort();
        if (short1 == null || short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1.shortValue()];
        reader.readFully(abyte);
        return CompressedStreamTools.func_74792_a((byte[])abyte);
    }

    public static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutput par1DataOutput) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutput.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutput.writeShort((short)abyte.length);
            par1DataOutput.write(abyte);
        }
    }

    public static void sendPacketToClients(Packet packet, World worldObj, IVector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x(), (double)position.y(), (double)position.z(), (double)range, (int)worldObj.field_73011_w.field_76574_g, (Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(Packet packet, World worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((Packet)packet, (int)worldObj.field_73011_w.field_76574_g);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(Packet packet) {
        try {
            PacketDispatcher.sendPacketToAllPlayers((Packet)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }
}

