/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.References;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.IPacketReceiverWithID;
import resonant.lib.network.PacketType;

public class PacketTile
extends PacketType {
    public PacketTile(String channel) {
        super(channel);
    }

    public Packet getPacket(TileEntity tileEntity, Object ... args) {
        return this.getPacket(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, args);
    }

    public Packet getPacketWithID(int id, TileEntity tileEntity, Object ... args) {
        return this.getPacketWithID(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, id, args);
    }

    public Packet getPacket(int x, int y, int z, Object ... args) {
        ArrayList<Object> newArgs = new ArrayList<Object>();
        newArgs.add(x);
        newArgs.add(y);
        newArgs.add(z);
        for (Object obj : args) {
            newArgs.add(obj);
        }
        return super.getPacket(newArgs.toArray());
    }

    public Packet getPacketWithID(int x, int y, int z, int id, Object ... args) {
        ArrayList<Object> newArgs = new ArrayList<Object>();
        newArgs.add(x);
        newArgs.add(y);
        newArgs.add(z);
        newArgs.add(id);
        for (Object obj : args) {
            newArgs.add(obj);
        }
        return super.getPacket(newArgs.toArray());
    }

    @Override
    public void receivePacket(ByteArrayDataInput data, EntityPlayer player) {
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        TileEntity tileEntity = player.field_70170_p.func_72796_p(x, y, z);
        try {
            if (tileEntity instanceof IPacketReceiverWithID) {
                ((IPacketReceiverWithID)tileEntity).onReceivePacket(data.readInt(), data, player, new Object[0]);
            } else if (tileEntity instanceof IPacketReceiver) {
                ((IPacketReceiver)tileEntity).onReceivePacket(data, player, new Object[0]);
            } else {
                int blockID = player.field_70170_p.func_72798_a(x, y, z);
                if (Block.field_71973_m[blockID] instanceof IPacketReceiver) {
                    ((IPacketReceiver)Block.field_71973_m[blockID]).onReceivePacket(data, player, x, y, z);
                }
            }
        }
        catch (Exception e) {
            References.LOGGER.severe("Resonant Engine packet failed at: " + tileEntity + " in " + x + ", " + y + ", " + z);
            e.printStackTrace();
        }
    }
}

