/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.path;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import resonant.lib.path.IPathCallBack;
import universalelectricity.api.vector.Vector3;

public class Pathfinder {
    public IPathCallBack callBackCheck;
    public Set<Vector3> closedSet;
    public List<Vector3> results;
    private Vector3 start;

    public Pathfinder(IPathCallBack callBack) {
        this.callBackCheck = callBack;
        this.reset();
    }

    public boolean findNodes(Vector3 currentNode) {
        if (this.start == null) {
            this.start = currentNode;
        }
        this.closedSet.add(currentNode);
        if (this.callBackCheck.onSearch(this, this.start, currentNode)) {
            return false;
        }
        for (Vector3 node : this.callBackCheck.getConnectedNodes(this, currentNode)) {
            if (this.closedSet.contains(node) || !this.findNodes(node)) continue;
            return true;
        }
        return false;
    }

    public Pathfinder init(Vector3 startNode) {
        this.findNodes(startNode);
        return this;
    }

    public Pathfinder reset() {
        this.closedSet = new LinkedHashSet<Vector3>();
        this.results = new LinkedList<Vector3>();
        return this;
    }
}

