/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.fluid;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import resonant.lib.type.Pair;
import resonant.lib.type.Triple;

public class FluidRecipeInfo {

    public static class ComplexFluidRecipe {
        public int numberOfSteps;
        public SimpleFluidRecipe[] stepArray;

        public ComplexFluidRecipe(int numberOfSteps) {
            this.numberOfSteps = numberOfSteps;
            this.stepArray = new SimpleFluidRecipe[this.numberOfSteps];
        }

        public ComplexFluidRecipe createStep(int step, SimpleFluidRecipe stepRecipe) {
            if (step < this.numberOfSteps) {
                this.stepArray[step] = stepRecipe;
            }
            return this;
        }

        public boolean canCompleteStep(int step, Object receiving, Object input) {
            if (this.getStep(step) != null) {
                return this.getStep(step).canComplete(receiving, input);
            }
            return false;
        }

        public SimpleFluidRecipe getStep(int step) {
            if (step < this.numberOfSteps) {
                return this.stepArray[step];
            }
            return null;
        }
    }

    public static class SimpleFluidRecipe {
        public Object recipeObjectA;
        public Object recipeObjectB;
        public Object recipeObjectC;
        public int ratioOfA = 1;
        public int ratioOfB = 1;
        public int ratioOfC = 1;
        public float mixingPercentMin = 0.1f;
        public boolean canBeReversed = false;

        public SimpleFluidRecipe(Object receiving, Object input, Object output) {
            this.recipeObjectA = receiving;
            this.recipeObjectB = input;
            this.recipeObjectC = output;
        }

        public SimpleFluidRecipe setRatio(int receivingVolume, int inputVolume, int result) {
            this.ratioOfA = receivingVolume;
            this.ratioOfB = inputVolume;
            this.ratioOfC = result;
            return this;
        }

        public SimpleFluidRecipe setIsReversable(boolean canBeReversed) {
            this.canBeReversed = canBeReversed;
            return this;
        }

        public Object getResult() {
            return this.recipeObjectC;
        }

        public boolean canComplete(Object receiving, Object input) {
            int countReceiving = 0;
            int countInput = 0;
            float percent = 0.0f;
            if (receiving != null && input != null && this.recipeObjectA.equals(receiving) && this.recipeObjectB.equals(input)) {
                countReceiving = this.getObjectVolume(receiving);
                countInput = this.getObjectVolume(input);
                if (countReceiving > 0 && countInput > 0) {
                    float per = countInput / countReceiving;
                    float per2 = countReceiving / countInput;
                    float f = percent = per > per2 ? per2 : per;
                    if (percent >= this.mixingPercentMin) {
                        return true;
                    }
                }
            }
            return false;
        }

        public int getObjectVolume(Object object) {
            int volume = 0;
            if (object instanceof Item) {
                volume = 1;
            } else if (object instanceof ItemStack) {
                volume = ((ItemStack)object).field_77994_a;
            } else if (object instanceof FluidStack) {
                volume = ((FluidStack)object).amount;
            } else if (object instanceof Fluid) {
                volume = 1;
            }
            return volume;
        }

        public Triple<Integer, Integer, Pair<Object, Integer>> mix(Object receiving, Object input) {
            if (this.canComplete(receiving, input)) {
                int volumeReceiving = this.getObjectVolume(receiving);
                int volumeInput = this.getObjectVolume(input);
                if (volumeReceiving > this.ratioOfA && volumeInput > this.ratioOfB) {
                    int ratioA = volumeReceiving / this.ratioOfA;
                    int ratioB = volumeInput / this.ratioOfB;
                    int outputVolume = ratioA > ratioB ? ratioB * this.ratioOfC : ratioA * this.ratioOfC;
                    int volAUsed = outputVolume / this.ratioOfC * this.ratioOfA;
                    int volBUsed = outputVolume / this.ratioOfC * this.ratioOfB;
                    return new Triple<Integer, Integer, Pair<Object, Integer>>(volAUsed, volBUsed, new Pair<Object, Integer>(this.recipeObjectC, outputVolume));
                }
            }
            return null;
        }
    }

    public static class BoilingFluidRecipe {
        public Object boiledObject;
        public Object boiledResult;
        public float heatLevel = 0.0f;
        public float energyPerMb = 1.0f;

        public BoilingFluidRecipe(Object unboiled, Object boiled, float boilingTempature, float energyPerUnitBoiled) {
            this.boiledObject = unboiled;
            this.boiledResult = boiled;
            this.heatLevel = boilingTempature;
            this.energyPerMb = energyPerUnitBoiled;
        }

        public String toString() {
            return "[BoilingFluidRecipe] UnboiledObject: " + (this.boiledObject != null ? this.boiledObject.toString() : "null") + " | BoiledObject: " + (this.boiledResult != null ? this.boiledResult.toString() : "null") + " | BoilingTemp: " + this.heatLevel + "k | EnergyPerUnit: " + this.energyPerMb + "j";
        }
    }
}

