/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.tile;

import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.prefab.tile.TileIO;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.UniversalClass;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.energy.IEnergyContainer;
import universalelectricity.api.energy.IEnergyInterface;
import universalelectricity.api.vector.Vector3;

@UniversalClass
public class TileElectrical
extends TileIO
implements IEnergyInterface,
IEnergyContainer {
    protected EnergyStorageHandler energy;

    public TileElectrical() {
        super(null);
    }

    public TileElectrical(Material material) {
        super(material);
    }

    public void recharge(ItemStack itemStack) {
        if (this.getEnergyHandler() != null) {
            this.getEnergyHandler().extractEnergy(CompatibilityModule.chargeItem((ItemStack)itemStack, (long)this.getEnergyHandler().getEnergy(), (boolean)true), true);
        }
    }

    public void discharge(ItemStack itemStack) {
        if (this.getEnergyHandler() != null) {
            this.getEnergyHandler().receiveEnergy(CompatibilityModule.dischargeItem((ItemStack)itemStack, (long)this.getEnergyHandler().getEmptySpace(), (boolean)true), true);
        }
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        if (CompatibilityModule.isHandler((Object)obj)) {
            if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN)) {
                return false;
            }
            return this.getInputDirections().contains(direction) || this.getOutputDirections().contains(direction);
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        if (this.getEnergyHandler() != null) {
            this.getEnergyHandler().readFromNBT(nbt);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.getEnergyHandler() != null) {
            this.getEnergyHandler().writeToNBT(nbt);
        }
    }

    public long getEnergy(ForgeDirection from) {
        if (this.getEnergyHandler() != null) {
            return this.getEnergyHandler().getEnergy();
        }
        return -1L;
    }

    public long getEnergyCapacity(ForgeDirection from) {
        if (this.getEnergyHandler() != null) {
            return this.getEnergyHandler().getEnergyCapacity();
        }
        return -1L;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        if (this.getEnergyHandler() != null && (from == ForgeDirection.UNKNOWN || this.getInputDirections().contains(from))) {
            return this.getEnergyHandler().receiveEnergy(receive, doReceive);
        }
        return 0L;
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        if (this.getEnergyHandler() != null && (from == ForgeDirection.UNKNOWN || this.getOutputDirections().contains(from))) {
            return this.getEnergyHandler().extractEnergy(extract, doExtract);
        }
        return 0L;
    }

    public void setEnergy(ForgeDirection from, long energy) {
        if (this.getEnergyHandler() != null) {
            this.getEnergyHandler().setEnergy(energy);
        }
    }

    protected long produce(long outputEnergy) {
        long usedEnergy = 0L;
        for (ForgeDirection direction : this.getOutputDirections()) {
            TileEntity tileEntity;
            if (outputEnergy <= 0L || (tileEntity = new Vector3((TileEntity)this).translate(direction).getTileEntity((IBlockAccess)this.field_70331_k)) == null) continue;
            usedEnergy += CompatibilityModule.receiveEnergy((Object)tileEntity, (ForgeDirection)direction.getOpposite(), (long)outputEnergy, (boolean)true);
        }
        return usedEnergy;
    }

    protected long produce() {
        long totalUsed = 0L;
        for (ForgeDirection direction : this.getOutputDirections()) {
            TileEntity tileEntity;
            if (this.getEnergyHandler().getEnergy() <= 0L || (tileEntity = new Vector3((TileEntity)this).translate(direction).getTileEntity((IBlockAccess)this.field_70331_k)) == null) continue;
            long used = CompatibilityModule.receiveEnergy((Object)tileEntity, (ForgeDirection)direction.getOpposite(), (long)this.getEnergyHandler().extractEnergy(this.getEnergyHandler().getEnergy(), false), (boolean)true);
            totalUsed += this.getEnergyHandler().extractEnergy(used, true);
        }
        return totalUsed;
    }

    public EnergyStorageHandler getEnergyHandler() {
        return this.energy;
    }

    public void setEnergyHandler(EnergyStorageHandler energy) {
        this.energy = energy;
    }
}

