/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.vector;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import resonant.lib.prefab.vector.Rectangle;
import universalelectricity.api.vector.EulerAngle;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class Cuboid {
    public Vector3 min;
    public Vector3 max;

    public Cuboid() {
        this(new Vector3(), new Vector3());
    }

    public Cuboid(Cuboid cuboid) {
        this(cuboid.min.clone(), cuboid.max.clone());
    }

    public Cuboid(Vector3 min, Vector3 max) {
        this.min = min.clone();
        this.max = max.clone();
    }

    public Cuboid(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min = new Vector3(minx, miny, minz);
        this.max = new Vector3(maxx, maxy, maxz);
    }

    public Cuboid(AxisAlignedBB aabb) {
        this(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public Cuboid(Block block) {
        this(block.func_83009_v(), block.func_83008_x(), block.func_83005_z(), block.func_83007_w(), block.func_83010_y(), block.func_83006_A());
    }

    public AxisAlignedBB toAABB() {
        return AxisAlignedBB.func_72332_a().func_72299_a(this.min.x, this.min.y, this.min.z, this.max.x, this.max.y, this.max.z);
    }

    public static Cuboid full() {
        return new Cuboid(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.min.toVector2(), this.max.toVector2());
    }

    public Cuboid add(Vector3 vec) {
        this.min.add((IVector3)vec);
        this.max.add((IVector3)vec);
        return this;
    }

    public Cuboid subtract(Vector3 vec) {
        this.min.subtract((IVector3)vec);
        this.max.subtract((IVector3)vec);
        return this;
    }

    public Cuboid rotate(EulerAngle angle) {
        this.min.rotate(angle);
        this.max.rotate(angle);
        return this;
    }

    public Cuboid setBounds(Block block) {
        block.func_71905_a((float)this.min.x, (float)this.min.y, (float)this.min.z, (float)this.max.x, (float)this.max.y, (float)this.max.z);
        return this;
    }

    @Deprecated
    public boolean isIn(Vector3 point) {
        return this.intersects(point);
    }

    @Deprecated
    public boolean isIn(Cuboid other) {
        return other.max.x > this.min.x && other.min.x < this.max.x ? (other.max.y > this.min.y && other.min.y < this.max.y ? other.max.z > this.min.z && other.min.z < this.max.z : false) : false;
    }

    public boolean intersects(Vector3 point) {
        return point.x > this.min.x && point.x < this.max.x && point.y > this.min.y && point.y < this.max.y && point.z > this.min.z && point.z < this.max.z;
    }

    public boolean intersects(Cuboid other) {
        return this.max.x - 1.0E-5 > other.min.x && other.max.x - 1.0E-5 > this.min.x && this.max.y - 1.0E-5 > other.min.y && other.max.y - 1.0E-5 > this.min.y && this.max.z - 1.0E-5 > other.min.z && other.max.z - 1.0E-5 > this.min.z;
    }

    public Cuboid offset(Cuboid o) {
        this.min.translate((IVector3)o.min);
        this.max.translate((IVector3)o.max);
        return this;
    }

    public Cuboid translate(Vector3 vec) {
        this.min.translate((IVector3)vec);
        this.max.translate((IVector3)vec);
        return this;
    }

    public Vector3 center() {
        return this.min.clone().add((IVector3)this.max).scale(0.5);
    }

    public Cuboid expand(Vector3 difference) {
        this.min.subtract((IVector3)difference);
        this.max.add((IVector3)difference);
        return this;
    }

    public Cuboid expand(double difference) {
        this.min.subtract(difference);
        this.max.add(difference);
        return this;
    }

    public List<Vector3> getVectors() {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        for (int x = this.min.intX(); x < this.max.intX(); ++x) {
            int y = this.min.intY();
            while (x < this.max.intY()) {
                int z = this.min.intZ();
                while (x < this.max.intZ()) {
                    vectors.add(new Vector3((double)x, (double)y, (double)z));
                    ++z;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List<Vector3> getVectors(Vector3 center, int radius) {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        for (int x = this.min.intX(); x < this.max.intX(); ++x) {
            int y = this.min.intY();
            while (x < this.max.intY()) {
                int z = this.min.intZ();
                while (x < this.max.intZ()) {
                    Vector3 vector3 = new Vector3((double)x, (double)y, (double)z);
                    if (center.distance((IVector3)vector3) <= (double)radius) {
                        vectors.add(vector3);
                    }
                    ++z;
                }
                ++y;
            }
        }
        return vectors;
    }

    public List<Entity> getEntities(World world, Class<? extends Entity> entityClass) {
        return world.func_72872_a(entityClass, this.toAABB());
    }

    public List<Entity> getEntitiesExlude(World world, Entity entity) {
        return world.func_72839_b(entity, this.toAABB());
    }

    public List<Entity> getEntities(World world) {
        return this.getEntities(world, Entity.class);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Cuboid: [" + new BigDecimal(this.min.x, cont) + ", " + new BigDecimal(this.min.y, cont) + ", " + new BigDecimal(this.min.z, cont) + "] -> [" + new BigDecimal(this.max.x, cont) + ", " + new BigDecimal(this.max.y, cont) + ", " + new BigDecimal(this.max.z, cont) + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof Cuboid) {
            return this.min.equals((Object)((Cuboid)o).min) && this.max.equals((Object)((Cuboid)o).max);
        }
        return false;
    }

    public Cuboid clone() {
        return new Cuboid(this);
    }
}

