/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.vector;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class RayTraceHelper {
    public static MovingObjectPosition raytraceEntities_fromAnEntity(World world, Entity entity, Vec3 error, double reachDistance, boolean collisionFlag) {
        MovingObjectPosition pickedEntity = null;
        Vec3 playerPosition = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        Vec3 playerLook = entity.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance + error.field_72450_a), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance + error.field_72448_b), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance + error.field_72449_c));
        double playerBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = entity.field_70121_D.func_72314_b(playerBorder, playerBorder, playerBorder);
        List entitiesHit = world.func_72839_b(entity, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.field_70121_D == null || (hitMOP = (aabb = entityHit.field_70121_D.func_72314_b((double)(border = entityHit.func_70111_Y()), (double)border, (double)border)).func_72327_a(playerPosition, playerViewOffset)) == null) continue;
            if (aabb.func_72318_a(playerPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(entityHit)) == null) continue;
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = playerPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public static MovingObjectPosition raytraceEntities(World world, Vec3 start, Vec3 end, double range, boolean collisionFlag, Entity exclude) {
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72330_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c, (double)end.field_72450_a, (double)end.field_72448_b, (double)end.field_72449_c);
        List entitiesHit = null;
        entitiesHit = exclude != null ? world.func_72839_b(exclude, boxToScan) : world.func_72872_a(Entity.class, boxToScan);
        MovingObjectPosition pickedEntity = null;
        double closestEntity = range;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.field_70121_D == null || (hitMOP = (aabb = entityHit.field_70121_D.func_72314_b((double)(border = entityHit.func_70111_Y()), (double)border, (double)border)).func_72327_a(start, end)) == null) continue;
            if (aabb.func_72318_a(start)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(entityHit)) == null) continue;
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = start.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public static MovingObjectPosition raytraceBlocks_fromAnEntity(World world, Entity entity, Vec3 error, double reachDistance, boolean collisionFlag) {
        Vec3 playerPosition = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        Vec3 playerLook = entity.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance + error.field_72450_a), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance + error.field_72448_b), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance + error.field_72449_c));
        return RayTraceHelper.raytraceBlocks(world, playerPosition, playerViewOffset, collisionFlag);
    }

    public static MovingObjectPosition raytraceBlocks_fromAnEntity(World world, Entity entity, double reachDistance, boolean collisionFlag) {
        Vec3 playerPosition = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        Vec3 playerLook = entity.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance));
        return RayTraceHelper.raytraceBlocks(world, playerPosition, playerViewOffset, collisionFlag);
    }

    public static MovingObjectPosition raytraceBlocks(World world, Vec3 start, Vec3 end, boolean collisionFlag) {
        return world.func_72831_a(start, end, collisionFlag, !collisionFlag);
    }

    public static Vector3 getPosFromRotation(Vector3 center, float reachDistance, float yaw, float pitch) {
        return center.clone().translate((IVector3)RayTraceHelper.getLook(yaw, pitch, 1.0f).scale((double)reachDistance));
    }

    public static MovingObjectPosition ray_trace_do(World world, Vec3 start, Vec3 end, float range, boolean collisionFlag) {
        MovingObjectPosition hitBlock = RayTraceHelper.raytraceBlocks(world, new Vector3(start).toVec3(), new Vector3(end).toVec3(), collisionFlag);
        MovingObjectPosition hitEntity = RayTraceHelper.raytraceEntities(world, start, end, range, collisionFlag, null);
        if (hitEntity == null) {
            return hitBlock;
        }
        if (hitBlock == null) {
            return hitEntity;
        }
        if (hitEntity.field_72307_f.func_72438_d(start) < hitBlock.field_72307_f.func_72438_d(start)) {
            return hitEntity;
        }
        return hitBlock;
    }

    public static MovingObjectPosition do_rayTraceFromEntity(Entity entity, Vec3 e, double reachDistance, boolean collisionFlag) {
        MovingObjectPosition hitBlock = RayTraceHelper.raytraceBlocks_fromAnEntity(entity.field_70170_p, entity, e, reachDistance, collisionFlag);
        MovingObjectPosition hitEntity = RayTraceHelper.raytraceEntities_fromAnEntity(entity.field_70170_p, entity, e, reachDistance, collisionFlag);
        if (hitEntity == null) {
            return hitBlock;
        }
        if (hitBlock == null) {
            return hitEntity;
        }
        Vec3 playerPosition = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        if (hitEntity.field_72307_f.func_72438_d(playerPosition) < hitBlock.field_72307_f.func_72438_d(playerPosition)) {
            return hitEntity;
        }
        return hitBlock;
    }

    public static Vec3 getLook(Entity entity, float par1) {
        if (par1 == 1.0f) {
            float f1 = MathHelper.func_76134_b((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-entity.field_70125_A * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-entity.field_70125_A * ((float)Math.PI / 180)));
            return entity.field_70170_p.func_82732_R().func_72345_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        }
        float f1 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * par1;
        float f2 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * par1;
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        return entity.field_70170_p.func_82732_R().func_72345_a((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }

    public static Vector3 getLook(float yaw, float pitch, float distance) {
        if (distance == 1.0f) {
            float f1 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
            return new Vector3((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        }
        float f1 = pitch * distance;
        float f2 = yaw * distance;
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        return new Vector3((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }
}

