/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.recipe;

import ic2.api.item.Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class UniversalRecipe {
    public static final ArrayList<UniversalRecipe> RECIPES = new ArrayList();
    public static final UniversalRecipe PRIMARY_METAL = new UniversalRecipe("ingotSteel", "ingotRefinedIron", new ItemStack(Item.field_77703_o));
    public static final UniversalRecipe PRIMARY_PLATE;
    public static final UniversalRecipe SECONDARY_METAL;
    public static final UniversalRecipe SECONDARY_PLATE;
    public static final UniversalRecipe CIRCUIT_T1;
    public static final UniversalRecipe CIRCUIT_T2;
    public static final UniversalRecipe CIRCUIT_T3;
    public static final UniversalRecipe BATTERY;
    public static final UniversalRecipe ADVANCED_BATTERY;
    public static final UniversalRecipe BATTERY_BOX;
    public static final UniversalRecipe WRENCH;
    public static final UniversalRecipe WIRE;
    public static final UniversalRecipe MOTOR;
    public static final UniversalRecipe RUBBER;
    public String defaultRecipe;
    private final ArrayList alternatives = new ArrayList();
    private final Object[] originalRecipes;
    private boolean didGenerate = false;

    public UniversalRecipe(String defaultRecipe, Object ... alternativeRecipes) {
        this.defaultRecipe = defaultRecipe;
        this.originalRecipes = alternativeRecipes;
        RECIPES.add(this);
    }

    public void generate() {
        if (UniversalRecipe.recipeExists(this.defaultRecipe)) {
            this.alternatives.add(this.defaultRecipe);
        }
        for (Object alternative : this.originalRecipes) {
            if (alternative instanceof ItemStack) {
                if (!UniversalRecipe.recipeExists((ItemStack)alternative)) continue;
                this.alternatives.add(alternative);
                continue;
            }
            if (!(alternative instanceof String) || !UniversalRecipe.recipeExists((String)alternative)) continue;
            this.alternatives.add(alternative);
        }
        this.didGenerate = true;
    }

    public Object get(boolean allowAlternatives) {
        if (!this.didGenerate) {
            this.generate();
        }
        if (allowAlternatives) {
            return this.alternatives.get(0);
        }
        return UniversalRecipe.recipeExists(this.defaultRecipe) ? this.defaultRecipe : this.alternatives.get(this.alternatives.size() - 1);
    }

    public Object get() {
        return this.get(true);
    }

    public static boolean recipeExists(List<ItemStack> itemStacks) {
        if (itemStacks != null && itemStacks.size() > 0) {
            for (ItemStack stack : itemStacks) {
                if (stack != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean recipeExists(ItemStack ... itemStacks) {
        return UniversalRecipe.recipeExists(Arrays.asList(itemStacks));
    }

    public static boolean recipeExists(String stackName) {
        return UniversalRecipe.recipeExists(OreDictionary.getOres((String)stackName));
    }

    static {
        SECONDARY_METAL = new UniversalRecipe("ingotBronze", new ItemStack(Item.field_77772_aH));
        PRIMARY_PLATE = new UniversalRecipe("plateSteel", Items.getItem((String)"advancedAlloy"), new ItemStack(Block.field_72083_ai));
        SECONDARY_PLATE = new UniversalRecipe("plateBronze", Items.getItem((String)"carbonPlate"), new ItemStack(Block.field_72081_al));
        CIRCUIT_T1 = new UniversalRecipe("circuitBasic", Items.getItem((String)"electronicCircuit"), new ItemStack(Block.field_72035_aQ));
        CIRCUIT_T2 = new UniversalRecipe("circuitAdvanced", Items.getItem((String)"advancedCircuit"), new ItemStack(Item.field_77742_bb));
        CIRCUIT_T3 = new UniversalRecipe("circuitElite", Items.getItem((String)"iridiumPlate"), new ItemStack(Item.field_94585_bY));
        ADVANCED_BATTERY = new UniversalRecipe("advancedBattery", Items.getItem((String)"energyCrystal"), "battery", new ItemStack(Item.field_77742_bb));
        BATTERY = new UniversalRecipe("battery", Items.getItem((String)"reBattery"), new ItemStack(Item.field_77742_bb));
        BATTERY_BOX = new UniversalRecipe("batteryBox", Items.getItem((String)"batBox"), new ItemStack(Block.field_72105_ah));
        WRENCH = new UniversalRecipe("wrench", Items.getItem((String)"wrench"), new ItemStack(Item.field_77708_h));
        WIRE = new UniversalRecipe("wire", "ironWire", "copperCableBlock", new ItemStack(Item.field_77767_aC));
        MOTOR = new UniversalRecipe("motor", "gear", Items.getItem((String)"generator"), new ItemStack((Block)Block.field_71963_Z));
        RUBBER = new UniversalRecipe("rubber", "itemRubber", new ItemStack(Item.field_77761_aM));
    }
}

