/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import resonant.lib.render.BlockRenderInfo;
import resonant.lib.render.RenderUtility;
import resonant.lib.render.block.RenderBlockEntity;

public class FluidRenderUtility {
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    public static final int DISPLAY_STAGES = 100;
    private static final BlockRenderInfo liquidBlock = new BlockRenderInfo();

    public static ResourceLocation getFluidSheet(FluidStack fluidStack) {
        return FluidRenderUtility.getFluidSheet(fluidStack.getFluid());
    }

    public static ResourceLocation getFluidSheet(Fluid fluid) {
        return RenderUtility.getSpriteTexture(fluid.getSpriteNumber());
    }

    public static Icon getFluidTexture(Fluid fluid, boolean flowing) {
        Icon icon;
        if (fluid == null) {
            return null;
        }
        Icon icon2 = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, World world, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        if (fluid.getBlockID() > 0) {
            FluidRenderUtility.liquidBlock.baseBlock = Block.field_71973_m[fluid.getBlockID()];
            FluidRenderUtility.liquidBlock.texture = FluidRenderUtility.getFluidTexture(fluidStack.getFluid(), flowing);
        } else {
            FluidRenderUtility.liquidBlock.baseBlock = Block.field_71943_B;
            FluidRenderUtility.liquidBlock.texture = FluidRenderUtility.getFluidTexture(fluidStack.getFluid(), flowing);
        }
        cache.put(fluid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidRenderUtility.liquidBlock.min.x = 0.01f;
            FluidRenderUtility.liquidBlock.min.y = 0.0;
            FluidRenderUtility.liquidBlock.min.z = 0.01f;
            FluidRenderUtility.liquidBlock.max.x = 0.99f;
            FluidRenderUtility.liquidBlock.max.y = (float)s / 100.0f;
            FluidRenderUtility.liquidBlock.max.z = 0.99f;
            RenderBlockEntity.INSTANCE.renderBlock(liquidBlock, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }

    public static void renderFluidTesselation(IFluidTank tank, double ySouthEast, double yNorthEast, double ySouthWest, double yNorthWest) {
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            Fluid fluid = fluidStack.getFluid();
            Icon texture = fluid.getStillIcon();
            RenderUtility.bind(FluidRenderUtility.getFluidSheet(fluid));
            int color = fluid.getColor(fluidStack);
            Tessellator t = Tessellator.field_78398_a;
            double uMin = texture.func_94214_a(0.0);
            double uMax = texture.func_94214_a(16.0);
            double vMin = texture.func_94207_b(0.0);
            double vMax = texture.func_94207_b(16.0);
            double vHeight = vMax - vMin;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(-0.5, -0.5, -0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMin + vHeight * yNorthWest);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMax, vMin + vHeight * yNorthEast);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMin, vMin + vHeight * ySouthEast);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMin + vHeight * ySouthWest);
            t.func_78374_a(-0.5, -0.5, 0.5, uMax, vMin);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMin, vMin);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin + vHeight * yNorthEast);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin + vHeight * ySouthEast);
            t.func_78374_a(0.5, -0.5, 0.5, uMax, vMin);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMin, vMin + vHeight * ySouthWest);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMax, vMin + vHeight * yNorthWest);
            t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMin);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMax);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMax);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMax);
            t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMax);
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }
}

