/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.schematic;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.schematic.Schematic;
import resonant.lib.type.Pair;
import resonant.lib.utility.nbt.ISaveObj;
import resonant.lib.utility.nbt.NBTUtility;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class SchematicMap
extends Schematic
implements ISaveObj {
    public static final String BLOCK_LIST_SAVE_NAME = "BlockList";
    public static final String BLOCK_REF_SAVE_NAME = "BlockRef";
    public static final String BLOCK_MAP_SAVE_NAME = "BlockMap";
    private static final LinkedHashMap<String, Block> BLOCK_SAVE_MAP = new LinkedHashMap();
    private static final LinkedHashMap<Block, String> BLOCK_SAVE_MAP_REV = new LinkedHashMap();
    protected String name;
    public Vector3 schematicSize;
    public Vector3 schematicCenter;
    public LinkedHashMap<Vector3, Pair<Integer, Integer>> block_map = new LinkedHashMap();
    public boolean init = false;

    public static void registerSaveBlock(String name, Block block) {
        BLOCK_SAVE_MAP.put(name, block);
        BLOCK_SAVE_MAP_REV.put(block, name);
    }

    public void init() {
        if (this.schematicSize != null) {
            this.init = true;
            this.schematicCenter = new Vector3();
            this.schematicCenter.x = this.schematicSize.x / 2.0;
            this.schematicCenter.z = this.schematicSize.z / 2.0;
        }
    }

    public void build(VectorWorld spot, boolean doWorldCheck) {
        if (this.block_map != null) {
            HashMap<Vector3, ItemStack> blocksToPlace = new HashMap<Vector3, ItemStack>();
            this.getBlocksToPlace(spot, blocksToPlace, doWorldCheck, doWorldCheck);
            for (Map.Entry<Vector3, ItemStack> entry : blocksToPlace.entrySet()) {
                entry.getKey().setBlock(spot.world, entry.getValue().field_77993_c, entry.getValue().func_77960_j());
            }
        }
    }

    public void getBlocksToPlace(VectorWorld spot, HashMap<Vector3, ItemStack> blockMap, boolean checkWorld, boolean checkIfWorldIsLoaded) {
        if (this.block_map != null) {
            for (Map.Entry<Vector3, Pair<Integer, Integer>> entry : this.block_map.entrySet()) {
                int blockID = entry.getValue().left();
                int meta = entry.getValue().right();
                Block block = Block.field_71973_m[blockID];
                if (block != null && block == Block.field_71945_L) continue;
                if (meta > 15) {
                    meta = 15;
                } else if (meta < 0) {
                    meta = 0;
                }
                Vector3 setPos = spot.clone().subtract((IVector3)this.schematicCenter).add((IVector3)entry.getKey());
                if (checkWorld) {
                    if (checkIfWorldIsLoaded) {
                        Chunk chunk = spot.world.func_72938_d(setPos.intX(), setPos.intZ());
                        if (!chunk.field_76636_d) continue;
                    }
                    int checkID = setPos.getBlockID((IBlockAccess)spot.world);
                    int checkMeta = setPos.getBlockID((IBlockAccess)spot.world);
                    if (checkID == blockID && checkMeta == meta) continue;
                }
                blockMap.put(setPos, new ItemStack(blockID, 1, meta));
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        if (!this.init) {
            this.init();
        }
        NBTTagCompound blockNBT = nbt.func_74775_l(BLOCK_LIST_SAVE_NAME);
        if (this.schematicSize != null) {
            nbt.func_74768_a("sizeX", (int)this.schematicSize.x);
            nbt.func_74768_a("sizeY", (int)this.schematicSize.y);
            nbt.func_74768_a("sizeZ", (int)this.schematicSize.z);
        }
        if (this.schematicCenter != null) {
            nbt.func_74768_a("centerX", (int)this.schematicCenter.x);
            nbt.func_74768_a("centerY", (int)this.schematicCenter.y);
            nbt.func_74768_a("centerZ", (int)this.schematicCenter.z);
        }
        int i = 0;
        for (Map.Entry<Vector3, Pair<Integer, Integer>> entry : this.block_map.entrySet()) {
            String output = "";
            Block block = Block.field_71973_m[entry.getValue().left()];
            output = block != null && BLOCK_SAVE_MAP_REV.containsKey(block) ? output + BLOCK_SAVE_MAP_REV.get(block) : output + entry.getValue().left();
            output = output + ":" + entry.getValue().right();
            output = output + ":" + (int)entry.getKey().x + ":" + (int)entry.getKey().y + ":" + (int)entry.getKey().z;
            blockNBT.func_74778_a("Block" + i, output);
            ++i;
        }
        blockNBT.func_74768_a("count", i);
        nbt.func_74766_a(BLOCK_LIST_SAVE_NAME, blockNBT);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.schematicSize = new Vector3((double)nbt.func_74762_e("sizeX"), (double)nbt.func_74762_e("sizeY"), (double)nbt.func_74762_e("sizeZ"));
        this.schematicCenter = new Vector3((double)nbt.func_74762_e("centerX"), (double)nbt.func_74762_e("centerY"), (double)nbt.func_74762_e("centerZ"));
        NBTTagCompound blockDataSave = nbt.func_74775_l(BLOCK_LIST_SAVE_NAME);
        for (int blockCount = 0; blockCount < blockDataSave.func_74762_e("count"); ++blockCount) {
            String blockString = blockDataSave.func_74779_i("Block" + blockCount);
            String[] blockData = blockString.split(":");
            int blockID = 0;
            int blockMeta = 0;
            Vector3 blockPostion = new Vector3();
            if (blockData == null) continue;
            try {
                if (blockData.length > 0) {
                    blockID = BLOCK_SAVE_MAP.containsKey(blockData[0]) ? SchematicMap.BLOCK_SAVE_MAP.get((Object)blockData[0]).field_71990_ca : Integer.parseInt(blockData[0]);
                }
                if (blockData.length > 1) {
                    blockMeta = Integer.parseInt(blockData[1]);
                }
                if (blockData.length > 2) {
                    blockPostion.x = Integer.parseInt(blockData[2]);
                }
                if (blockData.length > 3) {
                    blockPostion.y = Integer.parseInt(blockData[3]);
                }
                if (blockData.length > 4) {
                    blockPostion.z = Integer.parseInt(blockData[4]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.block_map.put(blockPostion, new Pair<Integer, Integer>(blockID, blockMeta));
        }
        if (!this.init) {
            this.init();
        }
    }

    public void getFromResourceFolder(String fileName) {
        try {
            this.load(CompressedStreamTools.func_74796_a((InputStream)SchematicMap.class.getResource("/assets/artillects/schematics/" + fileName + ".dat").openStream()));
            this.name = fileName;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveToBaseDirectory(String fileName) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.save(nbt);
            NBTUtility.saveData(new File(NBTUtility.getBaseDirectory(), "schematics"), fileName, nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SchematicMap loadWorldSelection(World world, Vector3 pos, Vector3 pos2) {
        Vector3 start = new Vector3(pos.x > pos2.x ? pos2.x : pos.x, pos.y > pos2.y ? pos2.y : pos.y, pos.z > pos2.z ? pos2.z : pos.z);
        SchematicMap sch = new SchematicMap();
        int deltaX = pos.x < pos2.x ? (int)(pos2.x - pos.x + 1.0) : (int)(pos.x - pos2.x + 1.0);
        int deltaY = pos.y < pos2.y ? (int)(pos2.y - pos.y + 1.0) : (int)(pos.y - pos2.y + 1.0);
        int deltaZ = pos.z < pos2.z ? (int)(pos2.z - pos.z + 1.0) : (int)(pos.z - pos2.z + 1.0);
        sch.schematicSize = new Vector3((double)deltaX, (double)deltaY, (double)deltaZ);
        for (int x = 0; x < deltaX; ++x) {
            for (int y = 0; y < deltaY; ++y) {
                for (int z = 0; z < deltaZ; ++z) {
                    int blockID = world.func_72798_a((int)start.x + x, (int)start.y + y, (int)start.z + z);
                    int blockMeta = world.func_72805_g((int)start.x + x, (int)start.y + y, (int)start.z + z);
                    sch.block_map.put(new Vector3((double)x, (double)y, (double)z), new Pair<Integer, Integer>(blockID, blockMeta));
                }
            }
        }
        return sch;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HashMap<Vector3, Pair<Integer, Integer>> getStructure(ForgeDirection dir, int size) {
        return this.block_map;
    }
}

