/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.thermal;

import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.prefab.tile.TileAdvanced;

public abstract class TileThermal
extends TileAdvanced {
    private int temperature = 293;

    public boolean canUpdate() {
        return false;
    }

    public int addThermalEnergy(long energy) {
        float mass = this.getMass();
        int changeInTemperature = (int)((float)energy / (mass * (float)this.specificHeatCapacity()));
        this.temperature = (int)((long)this.temperature + energy);
        this.onTemperatureChanged();
        return changeInTemperature;
    }

    protected void onTemperatureChanged() {
        if (this.temperature > this.boilingPoint()) {
            this.boil();
        } else if (this.temperature < this.meltingPoint()) {
            this.melt();
        }
    }

    public float getMass() {
        return 1.0f;
    }

    public abstract int boilingPoint();

    protected void boil() {
    }

    public abstract int meltingPoint();

    protected void melt() {
    }

    public abstract int specificHeatCapacity();

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.temperature = nbt.func_74762_e("temperature");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("temperature", this.temperature);
    }
}

