/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import resonant.lib.type.Pair;
import resonant.lib.utility.inventory.AutoCraftingManager;
import resonant.lib.utility.inventory.InventoryUtility;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class FluidUtility {
    public static List<Pair<Integer, Integer>> replacableBlockMeta = new ArrayList<Pair<Integer, Integer>>();
    public static List<Block> replacableBlocks = new ArrayList<Block>();
    public static List<Block> nonBlockDropList = new ArrayList<Block>();

    public static int getFluidAmountFromBlock(World world, Vector3 vector) {
        FluidStack fluidStack = FluidUtility.getFluidStackFromBlock(world, vector);
        return fluidStack != null ? fluidStack.amount : 0;
    }

    public static FluidStack getFluidStackFromBlock(World world, Vector3 vector) {
        int id = vector.getBlockID((IBlockAccess)world);
        int meta = vector.getBlockMetadata((IBlockAccess)world);
        if (Block.field_71973_m[id] instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)Block.field_71973_m[id];
            return new FluidStack(fluidBlock.getFluid(), (int)(1000.0f * fluidBlock.getFilledPercentage(world, vector.intX(), vector.intY(), vector.intZ())));
        }
        if (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) {
            if (meta == 0) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
        } else if ((id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) && meta == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    public static FluidTankInfo[] getTankInfo(World world, Vector3 posiiton, ForgeDirection from) {
        TileEntity tile = posiiton.getTileEntity((IBlockAccess)world);
        if (tile instanceof IFluidHandler && ((IFluidHandler)tile).getTankInfo(from) != null) {
            return ((IFluidHandler)tile).getTankInfo(from);
        }
        return new FluidTankInfo[0];
    }

    public static double getFilledPercentage(FluidTankInfo ... info) {
        int amount = 0;
        int capacity = 0;
        for (FluidTankInfo tankInfo : info) {
            if (tankInfo == null || tankInfo.fluid == null) continue;
            amount += tankInfo.fluid.amount;
            capacity += tankInfo.capacity;
        }
        if (capacity > 0) {
            return (double)amount / (double)capacity;
        }
        return 0.0;
    }

    public static double getAveragePercentageFilledForSides(Class classMask, double defaultFill, World world, Vector3 position, ForgeDirection ... sides) {
        if (defaultFill > 0.98) {
            return 1.0;
        }
        double fullness = defaultFill;
        int count = 1;
        for (ForgeDirection side : sides) {
            FluidTankInfo[] info;
            TileEntity tile = position.clone().translate(side).getTileEntity((IBlockAccess)world);
            if (tile == null || classMask != null && !classMask.isAssignableFrom(tile.getClass()) || (info = FluidUtility.getTankInfo(world, position.clone().translate(side), side)).length <= 0) continue;
            fullness += FluidUtility.getFilledPercentage(info);
            ++count;
        }
        return Math.max(0.0, Math.min(1.0, fullness / (double)count));
    }

    public static Fluid getFluidFromBlock(World world, Vector3 vector) {
        return FluidUtility.getFluidFromBlockID(vector.getBlockID((IBlockAccess)world));
    }

    public static Fluid getFluidFromBlockID(int id) {
        if (Block.field_71973_m[id] instanceof IFluidBlock) {
            return ((IFluidBlock)Block.field_71973_m[id]).getFluid();
        }
        if (id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca) {
            return FluidRegistry.WATER;
        }
        if (id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca) {
            return FluidRegistry.LAVA;
        }
        return null;
    }

    public static FluidStack getStack(FluidStack stack, int amount) {
        if (stack != null) {
            FluidStack newStack = stack.copy();
            newStack.amount = amount;
            return newStack;
        }
        return stack;
    }

    public static boolean matchExact(FluidStack stack, FluidStack stack2) {
        if (stack == null && stack2 == null) {
            return true;
        }
        if (stack != null && stack.isFluidEqual(stack2)) {
            return stack.amount == stack2.amount;
        }
        return false;
    }

    public static FluidStack drainBlock(World world, Vector3 position, boolean doDrain) {
        return FluidUtility.drainBlock(world, position, doDrain, 3);
    }

    public static FluidStack drainBlock(World world, Vector3 position, boolean doDrain, int update) {
        if (world == null || position == null) {
            return null;
        }
        int blockID = position.getBlockID((IBlockAccess)world);
        int meta = position.getBlockMetadata((IBlockAccess)world);
        Block block = Block.field_71973_m[blockID];
        if (block != null) {
            if (block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, position.intX(), position.intY(), position.intZ())) {
                return ((IFluidBlock)block).drain(world, position.intX(), position.intY(), position.intZ(), doDrain);
            }
            if ((block.field_71990_ca == Block.field_71943_B.field_71990_ca || block.field_71990_ca == Block.field_71942_A.field_71990_ca) && position.getBlockMetadata((IBlockAccess)world) == 0) {
                if (doDrain) {
                    Vector3 vec = position.clone().translate(ForgeDirection.UP);
                    if (vec.getBlockID((IBlockAccess)world) == Block.field_71991_bz.field_71990_ca) {
                        vec.setBlock(world, 0, 0, update);
                        position.setBlock(world, blockID, meta);
                    } else {
                        position.setBlock(world, 0, 0, update);
                    }
                }
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if ((block.field_71990_ca == Block.field_71938_D.field_71990_ca || block.field_71990_ca == Block.field_71944_C.field_71990_ca) && position.getBlockMetadata((IBlockAccess)world) == 0) {
                if (doDrain) {
                    position.setBlock(world, 0, 0, update);
                }
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }

    public static boolean isFillableBlock(World world, Vector3 node) {
        if (world == null || node == null) {
            return false;
        }
        int blockID = node.getBlockID((IBlockAccess)world);
        int meta = node.getBlockMetadata((IBlockAccess)world);
        Block block = Block.field_71973_m[blockID];
        if (FluidUtility.drainBlock(world, node, false) != null) {
            return false;
        }
        if (block == null || block.field_71990_ca == 0 || block.isAirBlock(world, node.intX(), node.intY(), node.intZ())) {
            return true;
        }
        return !(block instanceof IFluidBlock) && !(block instanceof BlockFluid) && block.isBlockReplaceable(world, node.intX(), node.intY(), node.intZ()) || replacableBlockMeta.contains(new Pair<Integer, Integer>(blockID, meta)) || replacableBlocks.contains(block);
    }

    public static boolean isFillableFluid(World world, Vector3 node) {
        if (world == null || node == null) {
            return false;
        }
        int blockID = node.getBlockID((IBlockAccess)world);
        int meta = node.getBlockMetadata((IBlockAccess)world);
        Block block = Block.field_71973_m[blockID];
        if (FluidUtility.drainBlock(world, node, false) != null) {
            return false;
        }
        if (block instanceof IFluidBlock || block instanceof BlockFluid) {
            return meta != 0;
        }
        return false;
    }

    public static int fillBlock(World world, Vector3 node, FluidStack stack, boolean doFill) {
        if ((FluidUtility.isFillableBlock(world, node) || FluidUtility.isFillableFluid(world, node)) && stack != null && stack.amount >= 1000) {
            if (doFill) {
                int blockID = node.getBlockID((IBlockAccess)world);
                int meta = node.getBlockMetadata((IBlockAccess)world);
                Block block = Block.field_71973_m[blockID];
                Vector3 vec = node.clone().translate(ForgeDirection.UP);
                if (block != null) {
                    if (block.field_71990_ca == Block.field_71991_bz.field_71990_ca && vec.getBlockID((IBlockAccess)world) == 0) {
                        vec.setBlock(world, blockID, meta);
                    } else if (block != null && replacableBlocks.contains(block) && !nonBlockDropList.contains(block)) {
                        block.func_71897_c(world, node.intX(), node.intY(), node.intZ(), meta, 1);
                        block.func_71852_a(world, node.intX(), node.intY(), node.intZ(), blockID, meta);
                    }
                }
                node.setBlock(world, stack.getFluid().getBlockID());
            }
            return 1000;
        }
        return 0;
    }

    public static int fillTanksAllSides(World world, Vector3 origin, FluidStack stack, boolean doFill, ForgeDirection ... ignore) {
        int filled = 0;
        FluidStack fillStack = stack != null ? stack.copy() : null;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (fillStack == null || fillStack.amount <= 0) {
                return filled;
            }
            if (ignore != null) {
                for (int i = 0; i < ignore.length; ++i) {
                    if (direction != ignore[i]) continue;
                }
            }
            fillStack = FluidUtility.getStack(stack, stack.amount - (filled += FluidUtility.fillTankSide(world, origin, stack, doFill, direction)));
        }
        return filled;
    }

    public static int fillTankSide(World world, Vector3 origin, FluidStack stack, boolean doFill, ForgeDirection direction) {
        TileEntity entity = origin.clone().translate(direction).getTileEntity((IBlockAccess)world);
        if (entity instanceof IFluidHandler && ((IFluidHandler)entity).canFill(direction.getOpposite(), stack.getFluid())) {
            return ((IFluidHandler)entity).fill(direction.getOpposite(), stack, doFill);
        }
        return 0;
    }

    public static int fillAllTanks(List<IFluidTank> tanks, FluidStack resource, boolean doFill) {
        int totalFilled = 0;
        FluidStack fill = resource.copy();
        for (IFluidTank tank : tanks) {
            if (fill.amount <= 0) break;
            int filled = tank.fill(fill, doFill);
            totalFilled += filled;
            fill.amount -= filled;
        }
        return totalFilled;
    }

    public static FluidStack drainAllTanks(List<IFluidTank> tanks, int amount, boolean doDrain) {
        FluidStack drain = null;
        for (IFluidTank tank : tanks) {
            if (drain != null && drain.amount >= amount) break;
            FluidStack drained = tank.drain(amount, false);
            if (drained == null) continue;
            if (drain == null) {
                drain = drained;
                tank.drain(amount, doDrain);
                continue;
            }
            if (!drain.equals((Object)drained)) continue;
            drain.amount += drained.amount;
            tank.drain(amount, doDrain);
        }
        return drain;
    }

    public static boolean playerActivatedFluidItem(World world, int x, int y, int z, EntityPlayer entityplayer, int side) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null && world.func_72796_p(x, y, z) instanceof IFluidHandler) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            IFluidHandler tank = (IFluidHandler)world.func_72796_p(x, y, z);
            if (fluid != null) {
                if (tank.fill(ForgeDirection.getOrientation((int)side), fluid.copy(), false) == fluid.amount) {
                    tank.fill(ForgeDirection.getOrientation((int)side), fluid.copy(), true);
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        InventoryUtility.consumeHeldItem(entityplayer);
                    }
                    return true;
                }
            } else {
                ItemStack filled;
                FluidStack available = tank.drain(ForgeDirection.getOrientation((int)side), Integer.MAX_VALUE, false);
                if (available != null && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                            return false;
                        }
                        InventoryUtility.dropItemStack(new VectorWorld((Entity)entityplayer), filled);
                    }
                    tank.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean playerActivatedFluidItem(List<IFluidTank> tanks, EntityPlayer entityplayer, int side) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null) {
            FluidStack resource = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (resource != null) {
                if (FluidUtility.fillAllTanks(tanks, resource, false) >= resource.amount) {
                    FluidUtility.fillAllTanks(tanks, resource, true);
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, AutoCraftingManager.consumeItem(current, 1));
                    }
                    return true;
                }
            } else {
                ItemStack filled;
                FluidStack available = FluidUtility.drainAllTanks(tanks, Integer.MAX_VALUE, false);
                if (available != null && (resource = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, AutoCraftingManager.consumeItem(current, 1));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, AutoCraftingManager.consumeItem(current, 1));
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, filled);
                        }
                    }
                    FluidUtility.drainAllTanks(tanks, resource.amount, true);
                    return true;
                }
            }
        }
        return false;
    }

    public static ItemStack drainItem(ItemStack stack, IFluidHandler tank, ForgeDirection side) {
        FluidStack liquid;
        if (stack != null && tank != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null && tank.fill(side, liquid, true) > 0) {
            return stack.func_77973_b().getContainerItemStack(stack);
        }
        return stack;
    }

    public static ItemStack fillItem(ItemStack stack, IFluidHandler tank, ForgeDirection side) {
        if (stack != null && tank != null) {
            ItemStack liquidItem;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            FluidStack drainStack = tank.drain(side, Integer.MAX_VALUE, false);
            if (liquid == null && drainStack != null && tank.drain(side, FluidContainerRegistry.getFluidForFilledItem((ItemStack)(liquidItem = FluidContainerRegistry.fillFluidContainer((FluidStack)drainStack, (ItemStack)stack))), true) != null) {
                return liquidItem;
            }
        }
        return stack;
    }

    public static List<FluidStack> getFluidList(FluidTankInfo ... fluidTankInfos) {
        ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
        HashMap<FluidStack, Integer> map = new HashMap<FluidStack, Integer>();
        if (fluidTankInfos != null) {
            for (int i = 0; i < fluidTankInfos.length; ++i) {
                FluidTankInfo info = fluidTankInfos[i];
                if (info == null || info.fluid == null) continue;
                FluidStack stack = info.fluid;
                if (map.containsKey(FluidUtility.getStack(stack, 0))) {
                    map.put(FluidUtility.getStack(stack, 0), (Integer)map.get(FluidUtility.getStack(stack, 0)) + stack.amount);
                    continue;
                }
                map.put(FluidUtility.getStack(stack, 0), stack.amount);
            }
            for (Map.Entry entry : map.entrySet()) {
                stackList.add(FluidUtility.getStack((FluidStack)entry.getKey(), (Integer)entry.getValue()));
            }
        }
        return stackList;
    }

    static {
        replacableBlocks.add(Block.field_72058_az);
        replacableBlocks.add((Block)Block.field_71961_Y);
        nonBlockDropList.add((Block)Block.field_71961_Y);
        replacableBlocks.add(Block.field_71991_bz);
        replacableBlocks.add((Block)Block.field_72103_ag);
        replacableBlocks.add((Block)Block.field_72109_af);
        replacableBlocks.add(Block.field_72094_bD);
        replacableBlocks.add(Block.field_71987_y);
        replacableBlocks.add(Block.field_71999_bt);
        nonBlockDropList.add(Block.field_71999_bt);
        replacableBlocks.add(Block.field_71996_bs);
        nonBlockDropList.add(Block.field_71996_bs);
        replacableBlocks.add((Block)Block.field_71962_X);
        replacableBlocks.add(Block.field_72069_aq);
    }
}

