/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import resonant.lib.References;
import resonant.lib.utility.MachinePlayer;
import universalelectricity.api.vector.Vector3;

public class WorldUtility {
    public static void rotateVectorFromDirection(Vector3 vec, ForgeDirection dir) {
        switch (dir) {
            default: {
                break;
            }
            case UP: {
                vec.rotate(180.0f, Vector3.EAST());
                break;
            }
            case NORTH: {
                vec.rotate(90.0f, Vector3.WEST());
                break;
            }
            case SOUTH: {
                vec.rotate(90.0f, Vector3.EAST());
                break;
            }
            case WEST: {
                vec.rotate(90.0f, Vector3.NORTH());
                break;
            }
            case EAST: {
                vec.rotate(90.0f, Vector3.SOUTH());
            }
        }
    }

    public static int getAngleFromForgeDirection(ForgeDirection dir) {
        switch (dir) {
            default: {
                break;
            }
            case NORTH: {
                return 90;
            }
            case SOUTH: {
                return -90;
            }
            case WEST: {
                return -180;
            }
            case EAST: {
                return 0;
            }
        }
        return 0;
    }

    public static ForgeDirection invertX(ForgeDirection dir) {
        switch (dir) {
            case NORTH: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.NORTH;
            }
        }
        return dir;
    }

    public static ForgeDirection invertY(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return ForgeDirection.DOWN;
            }
            case DOWN: {
                return ForgeDirection.UP;
            }
        }
        return dir;
    }

    public static ForgeDirection invertZ(ForgeDirection dir) {
        switch (dir) {
            case WEST: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.WEST;
            }
        }
        return dir;
    }

    public static TileEntity[] getSurroundingTileEntities(TileEntity ent) {
        return WorldUtility.getSurroundingTileEntities(ent.field_70331_k, ent.field_70329_l, ent.field_70330_m, ent.field_70327_n);
    }

    public static TileEntity[] getSurroundingTileEntities(World world, Vector3 vec) {
        return WorldUtility.getSurroundingTileEntities(world, vec.intX(), vec.intY(), vec.intZ());
    }

    public static TileEntity[] getSurroundingTileEntities(World world, int x, int y, int z) {
        TileEntity[] list = new TileEntity[6];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            list[direction.ordinal()] = world.func_72796_p(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
        }
        return list;
    }

    public static int corner(TileEntity entity) {
        TileEntity[] en = WorldUtility.getSurroundingTileEntities(entity.field_70331_k, entity.field_70329_l, entity.field_70330_m, entity.field_70327_n);
        TileEntity north = en[ForgeDirection.NORTH.ordinal()];
        TileEntity south = en[ForgeDirection.SOUTH.ordinal()];
        TileEntity east = en[ForgeDirection.EAST.ordinal()];
        TileEntity west = en[ForgeDirection.WEST.ordinal()];
        if (west != null && north != null && east == null && south == null) {
            return 3;
        }
        if (north != null && east != null && south == null && west == null) {
            return 4;
        }
        if (east != null && south != null && west == null && north == null) {
            return 1;
        }
        if (south != null && west != null && north == null && east == null) {
            return 2;
        }
        return 0;
    }

    public static List<EntityItem> findAllItemsIn(World world, Vector3 start, Vector3 end) {
        return world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)start.x, (double)start.y, (double)start.z, (double)end.x, (double)end.y, (double)end.z));
    }

    public static List<EntityItem> getEntitiesInDirection(World world, Vector3 center, ForgeDirection dir) {
        List list = world.func_82733_a(EntityItem.class, AxisAlignedBB.func_72332_a().func_72299_a(center.x + (double)dir.offsetX, center.y + (double)dir.offsetY, center.z + (double)dir.offsetZ, center.x + (double)dir.offsetX + 1.0, center.y + (double)dir.offsetY + 1.0, center.z + (double)dir.offsetZ + 1.0), IEntitySelector.field_94557_a);
        return list.size() > 0 ? list : null;
    }

    public static List<EntityItem> findSelectItems(World world, Vector3 start, Vector3 end, List<ItemStack> disiredItems) {
        List<EntityItem> entityItems = WorldUtility.findAllItemsIn(world, start, end);
        return WorldUtility.filterEntityItemsList(entityItems, disiredItems);
    }

    public static List<EntityItem> filterEntityItemsList(List<EntityItem> entityItems, List<ItemStack> disiredItems) {
        ArrayList<EntityItem> newItemList = new ArrayList<EntityItem>();
        block0: for (ItemStack itemStack : disiredItems) {
            for (EntityItem entityItem : entityItems) {
                if (!entityItem.func_92059_d().func_77969_a(itemStack) || newItemList.contains(entityItem)) continue;
                newItemList.add(entityItem);
                continue block0;
            }
        }
        return newItemList;
    }

    public static List<EntityItem> filterOutEntityItems(List<Entity> entities) {
        ArrayList<EntityItem> newEntityList = new ArrayList<EntityItem>();
        for (Entity entity : entities) {
            if (!(entity instanceof EntityItem)) continue;
            newEntityList.add((EntityItem)entity);
        }
        return newEntityList;
    }

    public static List<ItemStack> filterItems(List<ItemStack> totalItems, List<ItemStack> desiredItems) {
        ArrayList<ItemStack> newItemList = new ArrayList<ItemStack>();
        block0: for (ItemStack entityItem : totalItems) {
            for (ItemStack itemStack : desiredItems) {
                if (entityItem.field_77993_c != itemStack.field_77993_c || entityItem.func_77960_j() != itemStack.func_77960_j() || newItemList.contains(entityItem)) continue;
                newItemList.add(entityItem);
                continue block0;
            }
        }
        return newItemList;
    }

    public static void replaceTileEntity(Class<? extends TileEntity> findTile, Class<? extends TileEntity> replaceTile) {
        try {
            Map nameToClassMap = (Map)ObfuscationReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"field_70326_a", "nameToClassMap", "a"});
            Map classToNameMap = (Map)ObfuscationReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"field_70326_b", "classToNameMap", "b"});
            String findTileID = (String)classToNameMap.get(findTile);
            if (findTileID != null) {
                nameToClassMap.put(findTileID, replaceTile);
                classToNameMap.put(replaceTile, findTileID);
                classToNameMap.remove(findTile);
                References.LOGGER.fine("Replaced TileEntity: " + findTile);
            } else {
                References.LOGGER.severe("Failed to replace TileEntity: " + findTile);
            }
        }
        catch (Exception e) {
            References.LOGGER.severe("Failed to replace TileEntity: " + findTile);
            e.printStackTrace();
        }
    }

    public static boolean isEnabledSide(byte sideMap, ForgeDirection direction) {
        return (sideMap & 1 << direction.ordinal()) != 0;
    }

    public static byte setEnableSide(byte sideMap, ForgeDirection direction, boolean doEnable) {
        sideMap = doEnable ? (byte)(sideMap | 1 << direction.ordinal()) : (byte)(sideMap & ~(1 << direction.ordinal()));
        return sideMap;
    }

    public static List<ItemStack> getItemStackFromBlock(World world, int i, int j, int k) {
        Block block = Block.field_71973_m[world.func_72798_a(i, j, k)];
        if (block == null) {
            return null;
        }
        if (block.isAirBlock(world, i, j, k)) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        ArrayList dropsList = block.getBlockDropped(world, i, j, k, meta, 0);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((ArrayList)dropsList, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)MachinePlayer.get(world));
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack s : dropsList) {
            if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
            returnList.add(s);
        }
        return returnList;
    }
}

