/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility.inventory;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.utility.MachinePlayer;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class InventoryUtility {
    public static IInventory checkChestInv(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest main = (TileEntityChest)inv;
            TileEntityChest adj = null;
            if (main.field_70421_d != null) {
                adj = main.field_70421_d;
            } else if (main.field_70424_c != null) {
                adj = main.field_70424_c;
            } else if (main.field_70423_b != null) {
                adj = main.field_70423_b;
            } else if (main.field_70422_e != null) {
                adj = main.field_70422_e;
            }
            if (adj != null) {
                return new InventoryLargeChest("", (IInventory)main, (IInventory)adj);
            }
        }
        return inv;
    }

    public static ItemStack putStackInInventory(IInventory inventory, ItemStack toInsert, boolean force) {
        inventory = InventoryUtility.checkChestInv(inventory);
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (!force && !inventory.func_94041_b(slot, toInsert)) continue;
            ItemStack slot_stack = inventory.func_70301_a(slot);
            if (slot_stack == null) {
                inventory.func_70299_a(slot, toInsert);
                return null;
            }
            if (!slot_stack.func_77969_a(toInsert) || slot_stack.field_77994_a >= slot_stack.func_77976_d()) continue;
            if (slot_stack.field_77994_a + toInsert.field_77994_a <= slot_stack.func_77976_d()) {
                ItemStack toSet = toInsert.func_77946_l();
                toSet.field_77994_a += slot_stack.field_77994_a;
                inventory.func_70299_a(slot, toSet);
                return null;
            }
            int rejects = slot_stack.field_77994_a + toInsert.field_77994_a - slot_stack.func_77976_d();
            ItemStack toSet = toInsert.func_77946_l();
            toSet.field_77994_a = slot_stack.func_77976_d();
            ItemStack remains = toInsert.func_77946_l();
            remains.field_77994_a = rejects;
            inventory.func_70299_a(slot, toSet);
            toInsert = remains;
        }
        return toInsert;
    }

    public static ItemStack putStackInInventory(VectorWorld position, ItemStack toInsert, int side, boolean force) {
        TileEntity tile = position.getTileEntity();
        if (tile instanceof IInventory) {
            return InventoryUtility.putStackInInventory((IInventory)tile, toInsert, force);
        }
        InventoryUtility.dropItemStack(position.world, (Vector3)position, toInsert, 20, 0.0f);
        return null;
    }

    public static ItemStack putStackInInventory(IInventory inventory, ItemStack itemStack, int side, boolean force) {
        ItemStack toInsert;
        ItemStack itemStack2 = toInsert = itemStack != null ? itemStack.func_77946_l() : null;
        if (toInsert != null) {
            if (!(inventory instanceof ISidedInventory)) {
                return InventoryUtility.putStackInInventory(inventory, toInsert, force);
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.getOrientation((int)side).getOpposite().ordinal());
            if (slots != null && slots.length != 0) {
                for (int get = 0; get <= slots.length - 1; ++get) {
                    int slotID = slots[get];
                    if (!force && !sidedInventory.func_94041_b(slotID, toInsert) && !sidedInventory.func_102007_a(slotID, toInsert, ForgeDirection.getOrientation((int)side).getOpposite().ordinal())) continue;
                    ItemStack inSlot = inventory.func_70301_a(slotID);
                    if (inSlot == null) {
                        inventory.func_70299_a(slotID, toInsert);
                        return null;
                    }
                    if (!inSlot.func_77969_a(toInsert) || inSlot.field_77994_a >= inSlot.func_77976_d()) continue;
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= inSlot.func_77976_d()) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot.field_77994_a;
                        inventory.func_70299_a(slotID, toSet);
                        return null;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - inSlot.func_77976_d();
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a = inSlot.func_77976_d();
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    inventory.func_70299_a(slotID, toSet);
                    toInsert = remains;
                }
            }
        }
        return toInsert;
    }

    public static ItemStack takeTopItemFromInventory(IInventory inventory, int side) {
        block3: {
            block2: {
                if (inventory instanceof ISidedInventory) break block2;
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    toSend.field_77994_a = 1;
                    inventory.func_70298_a(i, 1);
                    return toSend;
                }
                break block3;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(side);
            if (slots == null) break block3;
            for (int get = slots.length - 1; get >= 0; --get) {
                int slotID = slots[get];
                if (sidedInventory.func_70301_a(slotID) == null) continue;
                ItemStack toSend = sidedInventory.func_70301_a(slotID);
                toSend.field_77994_a = 1;
                if (!sidedInventory.func_102008_b(slotID, toSend, side)) continue;
                sidedInventory.func_70298_a(slotID, 1);
                return toSend;
            }
        }
        return null;
    }

    public static ItemStack takeTopBlockFromInventory(IInventory inventory, int side) {
        block3: {
            block2: {
                if (inventory instanceof ISidedInventory) break block2;
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof ItemBlock)) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    toSend.field_77994_a = 1;
                    inventory.func_70298_a(i, 1);
                    return toSend;
                }
                break block3;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(side);
            if (slots == null) break block3;
            for (int get = slots.length - 1; get >= 0; --get) {
                int slotID = slots[get];
                if (sidedInventory.func_70301_a(slotID) == null || !(inventory.func_70301_a(slotID).func_77973_b() instanceof ItemBlock)) continue;
                ItemStack toSend = sidedInventory.func_70301_a(slotID);
                toSend.field_77994_a = 1;
                if (!sidedInventory.func_102008_b(slotID, toSend, side)) continue;
                sidedInventory.func_70298_a(slotID, 1);
                return toSend;
            }
        }
        return null;
    }

    public static void dropBlockAsItem(World world, Vector3 position) {
        InventoryUtility.dropBlockAsItem(world, position.intX(), position.intY(), position.intZ(), false);
    }

    public static void dropBlockAsItem(World world, int x, int y, int z, boolean destroy) {
        if (!world.field_72995_K) {
            int meta = world.func_72805_g(x, y, z);
            int id = world.func_72798_a(x, y, z);
            if (Block.field_71973_m[id] != null) {
                ArrayList items = Block.field_71973_m[id].getBlockDropped(world, x, y, z, meta, 0);
                for (ItemStack itemStack : items) {
                    InventoryUtility.dropItemStack(world, new Vector3((double)x, (double)y, (double)z), itemStack, 10);
                }
            }
            if (destroy) {
                world.func_94571_i(x, y, z);
            }
        }
    }

    public static void dropItemStack(VectorWorld position, ItemStack itemStack) {
        InventoryUtility.dropItemStack(position.world, (Vector3)position, itemStack);
    }

    public static void dropItemStack(World world, Vector3 position, ItemStack itemStack) {
        InventoryUtility.dropItemStack(world, position, itemStack, 10);
    }

    public static void dropItemStack(World world, Vector3 position, ItemStack itemStack, int delay) {
        InventoryUtility.dropItemStack(world, position, itemStack, delay, 0.0f);
    }

    public static void dropItemStack(World world, Vector3 position, ItemStack itemStack, int delay, float randomAmount) {
        InventoryUtility.dropItemStack(world, position.x, position.y, position.z, itemStack, delay, randomAmount);
    }

    public static void dropItemStack(World world, double x, double y, double z, ItemStack itemStack, int delay, float randomAmount) {
        assert (world.field_72995_K) : "Inventory Utility [Can not drop ItemStacks client side @" + x + "x " + y + "y " + z + "z]";
        assert (itemStack == null) : "Inventory Utility [Can not drop null ItemStacks @" + x + "x " + y + "y " + z + "z]";
        if (!world.field_72995_K && itemStack != null) {
            double randomX = 0.0;
            double randomY = 0.0;
            double randomZ = 0.0;
            if (randomAmount > 0.0f) {
                randomX = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
                randomY = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
                randomZ = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
            }
            EntityItem entityitem = new EntityItem(world, x + randomX, y + randomY, z + randomZ, itemStack);
            if (randomAmount <= 0.0f) {
                entityitem.field_70159_w = 0.0;
                entityitem.field_70181_x = 0.0;
                entityitem.field_70179_y = 0.0;
            }
            if (itemStack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            entityitem.field_70293_c = delay;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static boolean placeItemBlock(World world, int x, int y, int z, ItemStack itemStack, int side) {
        block4: {
            if (itemStack != null) {
                try {
                    Vector3 rightClickPos = new Vector3((double)x, (double)y, (double)z);
                    if (world.func_72799_c(x, y, z)) {
                        rightClickPos.translate(ForgeDirection.getOrientation((int)side));
                    }
                    return MachinePlayer.useItemAt(itemStack, world, x, y - 1, z, side ^= 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (world.func_72798_a(x, y, z) != itemStack.field_77993_c) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    public static ItemStack decrStackSize(ItemStack stack, int amount) {
        if (stack != null) {
            ItemStack itemStack = stack.func_77946_l();
            if (itemStack.field_77994_a <= amount) {
                return null;
            }
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a <= 0) {
                return null;
            }
            return itemStack;
        }
        return null;
    }

    public static void consumeHeldItem(EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (player != null && stack != null) {
            if ((stack = stack.func_77946_l()).func_77973_b().func_77634_r()) {
                if (stack.field_77994_a == 1) {
                    stack = stack.func_77973_b().getContainerItemStack(stack);
                } else {
                    player.field_71071_by.func_70441_a(stack.func_77973_b().getContainerItemStack(stack.func_77979_a(1)));
                }
            } else if (stack.field_77994_a == 1) {
                stack = null;
            } else {
                stack.func_77979_a(1);
            }
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
        }
    }

    public static ItemStack consumeStack(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
        } else {
            return stack.func_77979_a(1);
        }
        return null;
    }

    public static boolean stacksMatchExact(ItemStack stackA, ItemStack stackB) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            return stackA.func_77969_a(stackB) && stackA.field_77994_a == stackB.field_77994_a;
        }
        return false;
    }

    public static int getStackCount(ItemStack stack, IInventory inv, int[] slots) {
        int count = 0;
        if (stack != null) {
            ArrayList<Integer> slot_list = new ArrayList<Integer>();
            if (slots != null & slots.length > 0) {
                for (int i = 0; i < slots.length; ++i) {
                    slot_list.add(slots[i]);
                }
            }
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                if (!slot_list.isEmpty() && !slot_list.contains(slot) || inv.func_70301_a(slot) == null || !inv.func_70301_a(slot).func_77969_a(stack)) continue;
                count += inv.func_70301_a((int)slot).field_77994_a;
            }
        }
        return count;
    }

    public static int getStackCount(Class<?> compare, IInventory inv) {
        return InventoryUtility.getStackCount(compare, inv);
    }

    public static int getStackCount(Class<?> compare, IInventory inv, int[] slots) {
        int count = 0;
        if (compare != null) {
            ArrayList<Integer> slot_list = new ArrayList<Integer>();
            if (slots != null & slots.length > 0) {
                for (int i = 0; i < slots.length; ++i) {
                    slot_list.add(slots[i]);
                }
            }
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                if (!slot_list.isEmpty() && !slot_list.contains(slot) || inv.func_70301_a(slot) == null || !compare.isInstance(inv.func_70301_a(slot).func_77973_b())) continue;
                count += inv.func_70301_a((int)slot).field_77994_a;
            }
        }
        return count;
    }
}

