/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.Event;

import com.advGenetics.API.Ability;
import com.advGenetics.API.ILivingJoin;
import com.advGenetics.DNA.AbilityRegistry;
import com.advGenetics.DNA.DNA;
import com.advGenetics.Event.DNAChangeEvent;
import com.advGenetics.Lib.EntityUpdater;
import com.advGenetics.Lib.EventWrapper;
import com.advGenetics.Lib.GeneHelper;
import com.advGenetics.Lib.PacketWrapper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class JoinEventHandler {
    public static Map<Integer, NBTTagCompound> entityDimBuffer = new HashMap<Integer, NBTTagCompound>();

    @ForgeSubscribe
    public void onLivingJoin(EntityJoinWorldEvent event) {
        DNA dna = new DNA(event.entity.getEntityData());
        for (Ability ability : AbilityRegistry.ab_event_join) {
            if (!dna.hasGene(ability) || !EventWrapper.canDebugEvent(GeneHelper.getAbility(ability.getClass()), event.entity)) continue;
            ((ILivingJoin)((Object)ability)).onLivingJoin(event);
        }
        PacketWrapper.sendDNASyncPacket(10, dna.getTransmutators(), event.entity.field_70157_k);
    }

    @ForgeSubscribe
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayer) {
            if (entityDimBuffer.containsKey(event.entity.field_70157_k)) {
                DNA dna = new DNA(entityDimBuffer.get(event.entity.field_70157_k));
                event.entity.getEntityData().func_74778_a("dna_transmutators", dna.getTransmutators());
                EntityUpdater.updatePlayerCapatilities(dna, event.entity);
                PacketWrapper.sendDNASyncPacket(10, dna.getTransmutators(), event.entity.field_70157_k);
            } else {
                entityDimBuffer.put(event.entity.field_70157_k, event.entity.getEntityData());
            }
        }
    }

    public static void removeEntityFromDimBuffer(Entity entity) {
        if (entityDimBuffer.containsKey(entity.field_70157_k)) {
            entityDimBuffer.remove(entity.field_70157_k);
        }
    }

    public static void updateEntityDimBuffer(Entity entity) {
        entityDimBuffer.put(entity.field_70157_k, entity.getEntityData());
    }

    @ForgeSubscribe
    public void onDNAChange(DNAChangeEvent event) {
        JoinEventHandler.updateEntityDimBuffer(event.target);
    }
}

