/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectricBlock;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import micdoodle8.mods.galacticraft.mars.GCMarsConfigManager;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;

public class GCMarsTileEntityLaunchController
extends GCCoreTileEntityElectricBlock
implements IChunkLoader,
IElectrical,
IInventory,
ISidedInventory,
ILandingPadAttachable {
    public static final float WATTS_PER_TICK = 0.05000001f;
    private ItemStack[] containingItems = new ItemStack[1];
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchPadRemovalDisabled = true;
    private ForgeChunkManager.Ticket chunkLoadTicket;
    private List<ChunkCoordinates> connectedPads = new ArrayList<ChunkCoordinates>();
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int frequency = -1;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int destFrequency = -1;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerName = "";
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean frequencyValid;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean destFrequencyValid;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int launchDropdownSelection;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchSchedulingEnabled;
    public boolean requiresClientUpdate;

    public GCMarsTileEntityLaunchController() {
        super(0.05000001f, 50.0f);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.requiresClientUpdate) {
                this.requiresClientUpdate = false;
            }
            if (this.ticks % 40L == 0L) {
                this.setFrequency(this.frequency);
                this.setDestinationFrequency(this.destFrequency);
            }
            if (this.ticks % 20L == 0L && this.chunkLoadTicket != null) {
                for (int i = 0; i < this.connectedPads.size(); ++i) {
                    ChunkCoordinates coords = this.connectedPads.get(i);
                    int blockID = this.field_70331_k.func_72798_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    if (blockID == GCCoreBlocks.landingPadFull.field_71990_ca) continue;
                    this.connectedPads.remove(i);
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(coords.field_71574_a >> 4, coords.field_71573_c >> 4));
                }
            }
        } else if (this.frequency == -1 && this.destFrequency == -1) {
            PacketDispatcher.sendPacketToServer((Packet)PacketUtil.createPacket((String)"GalacticraftMars", (int)5, (Object[])new Object[]{5, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0}));
        }
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.chunkLoadTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkLoadTicket);
        }
    }

    public void onTicketLoaded(ForgeChunkManager.Ticket ticket, boolean placed) {
        if (!this.field_70331_k.field_72995_K && GCMarsConfigManager.launchControllerChunkLoad) {
            if (ticket == null) {
                return;
            }
            if (this.chunkLoadTicket == null) {
                this.chunkLoadTicket = ticket;
            }
            NBTTagCompound nbt = this.chunkLoadTicket.getModData();
            nbt.func_74768_a("ChunkLoaderTileX", this.field_70329_l);
            nbt.func_74768_a("ChunkLoaderTileY", this.field_70330_m);
            nbt.func_74768_a("ChunkLoaderTileZ", this.field_70327_n);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    int blockID = this.field_70331_k.func_72798_a(this.field_70329_l + x, this.field_70330_m, this.field_70327_n + z);
                    if (blockID <= 0 || !(Block.field_71973_m[blockID] instanceof GCCoreBlockLandingPadFull) || this.field_70329_l + x >> 4 == this.field_70329_l >> 4 && this.field_70327_n + z >> 4 == this.field_70327_n >> 4) continue;
                    this.connectedPads.add(new ChunkCoordinates(this.field_70329_l + x, this.field_70330_m, this.field_70327_n + z));
                    if (placed) {
                        ChunkLoadingCallback.forceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (World)this.field_70331_k, (int)(this.field_70329_l + x), (int)this.field_70330_m, (int)(this.field_70327_n + z), (String)this.getOwnerName());
                        continue;
                    }
                    ChunkLoadingCallback.addToList((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (String)this.getOwnerName());
                }
            }
            ChunkLoadingCallback.forceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (String)this.getOwnerName());
        }
    }

    public ForgeChunkManager.Ticket getTicket() {
        return this.chunkLoadTicket;
    }

    public ChunkCoordinates getCoords() {
        return new ChunkCoordinates(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.ownerName = nbt.func_74779_i("OwnerName");
        this.launchDropdownSelection = nbt.func_74762_e("LaunchSelection");
        this.frequency = nbt.func_74762_e("ControllerFrequency");
        this.destFrequency = nbt.func_74762_e("TargetFrequency");
        this.launchPadRemovalDisabled = nbt.func_74767_n("LaunchPadRemovalDisabled");
        this.launchSchedulingEnabled = nbt.func_74767_n("LaunchPadSchedulingEnabled");
        this.requiresClientUpdate = true;
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
        nbt.func_74778_a("OwnerName", this.ownerName);
        nbt.func_74768_a("LaunchSelection", this.launchDropdownSelection);
        nbt.func_74768_a("ControllerFrequency", this.frequency);
        nbt.func_74768_a("TargetFrequency", this.destFrequency);
        nbt.func_74757_a("LaunchPadRemovalDisabled", this.launchPadRemovalDisabled);
        nbt.func_74757_a("LaunchPadSchedulingEnabled", this.launchSchedulingEnabled);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return StatCollector.func_74838_a((String)"container.launchcontroller.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 ? itemStack.func_77973_b() instanceof IItemElectric : false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 0;
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    public boolean shouldPullEnergy() {
        return this.getEnergyStored() <= this.getMaxEnergyStored() - this.ueWattsPerTick;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_70322_n() - 8 + 2));
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    break;
                }
                case 1: {
                    this.launchSchedulingEnabled = disabled;
                }
            }
            this.disableCooldown = 20;
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
            case 1: {
                return this.launchSchedulingEnabled;
            }
        }
        return true;
    }

    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        return tile instanceof GCCoreTileEntityLandingPad;
    }

    public void setFrequency(int frequency) {
        block4: {
            this.frequency = frequency;
            if (this.frequency >= 0) {
                this.frequencyValid = true;
                for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++i) {
                    WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i];
                    for (int j = 0; j < world.field_73009_h.size(); ++j) {
                        TileEntity tile2 = (TileEntity)world.field_73009_h.get(j);
                        if (this == tile2 || !((tile2 = world.func_72796_p(tile2.field_70329_l, tile2.field_70330_m, tile2.field_70327_n)) instanceof GCMarsTileEntityLaunchController)) continue;
                        GCMarsTileEntityLaunchController launchController2 = (GCMarsTileEntityLaunchController)tile2;
                        if (launchController2.frequency != this.frequency) continue;
                        this.frequencyValid = false;
                        break block4;
                    }
                }
            } else {
                this.frequencyValid = false;
            }
        }
    }

    public void setDestinationFrequency(int frequency) {
        block4: {
            this.destFrequency = frequency;
            if (this.destFrequency >= 0) {
                this.destFrequencyValid = false;
                for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++i) {
                    WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i];
                    for (int j = 0; j < world.field_73009_h.size(); ++j) {
                        TileEntity tile2 = (TileEntity)world.field_73009_h.get(j);
                        if (this == tile2 || !((tile2 = world.func_72796_p(tile2.field_70329_l, tile2.field_70330_m, tile2.field_70327_n)) instanceof GCMarsTileEntityLaunchController)) continue;
                        GCMarsTileEntityLaunchController launchController2 = (GCMarsTileEntityLaunchController)tile2;
                        if (launchController2.frequency != this.destFrequency) continue;
                        this.destFrequencyValid = true;
                        break block4;
                    }
                }
            } else {
                this.destFrequencyValid = false;
            }
        }
    }

    public boolean validFrequency() {
        return !this.getDisabled(0) && this.getEnergyStored() > 0.0f && this.frequencyValid && this.destFrequencyValid;
    }
}

