/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.world.gen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreMapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;

public class GCMarsRoomSpawner
extends GCCoreDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    Random rand;
    private final ArrayList<ChunkCoordinates> spawners = new ArrayList();

    public GCMarsRoomSpawner(GCCoreMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            this.rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = this.rand.nextInt(5) + 6;
            this.sizeY = this.rand.nextInt(2) + 7;
            this.sizeZ = this.rand.nextInt(5) + 6;
        }
    }

    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                    if (!(this.rand.nextFloat() < 0.05f)) continue;
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Block.field_71955_W.field_71990_ca, 0);
                }
            }
        }
        if (this.placeBlock(chunk, meta, this.posX + 1, this.posY - 1, this.posZ + 1, cx, cz, Block.field_72065_as.field_71990_ca, 0)) {
            this.spawners.add(new ChunkCoordinates(this.posX + 1, this.posY - 1, this.posZ + 1));
        }
        if (this.placeBlock(chunk, meta, this.posX + this.sizeX - 1, this.posY - 1, this.posZ + this.sizeZ - 1, cx, cz, Block.field_72065_as.field_71990_ca, 0)) {
            this.spawners.add(new ChunkCoordinates(this.posX + this.sizeX - 1, this.posY - 1, this.posZ + this.sizeZ - 1));
        }
    }

    public GCCoreDungeonBoundingBox getBoundingBox() {
        return new GCCoreDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected GCCoreDungeonRoom makeRoom(GCCoreMapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new GCMarsRoomSpawner(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand) {
        for (ChunkCoordinates spawnerCoords : this.spawners) {
            TileEntityMobSpawner spawner;
            if (this.worldObj.func_72798_a(spawnerCoords.field_71574_a, spawnerCoords.field_71572_b, spawnerCoords.field_71573_c) != Block.field_72065_as.field_71990_ca || (spawner = (TileEntityMobSpawner)this.worldObj.func_72796_p(spawnerCoords.field_71574_a, spawnerCoords.field_71572_b, spawnerCoords.field_71573_c)) == null) continue;
            spawner.func_98049_a().func_98272_a(GCMarsRoomSpawner.getMob(rand));
        }
    }

    private static String getMob(Random rand) {
        switch (rand.nextInt(6)) {
            case 0: {
                return "EvolvedSpider";
            }
            case 1: {
                return "EvolvedZombie";
            }
            case 2: {
                return "EvolvedCreeper";
            }
            case 3: {
                return "EvolvedSkeleton";
            }
        }
        return "EvolvedCreeper";
    }
}

