/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeDirection;

public class Coord4D {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public int dimensionId;

    public Coord4D(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = 0;
    }

    public Coord4D(int x, int y, int z, int dimension) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = dimension;
    }

    public int getMetadata(IBlockAccess world) {
        return world.func_72805_g(this.xCoord, this.yCoord, this.zCoord);
    }

    public int getBlockId(IBlockAccess world) {
        return world.func_72798_a(this.xCoord, this.yCoord, this.zCoord);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        if (world instanceof World && !this.exists((World)world)) {
            return null;
        }
        return world.func_72796_p(this.xCoord, this.yCoord, this.zCoord);
    }

    public Block getBlock(IBlockAccess world) {
        if (world instanceof World && !this.exists((World)world)) {
            return null;
        }
        return Block.field_71973_m[this.getBlockId(world)];
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("x", this.xCoord);
        nbtTags.func_74768_a("y", this.yCoord);
        nbtTags.func_74768_a("z", this.zCoord);
        nbtTags.func_74768_a("dimensionId", this.dimensionId);
        return nbtTags;
    }

    public void write(ArrayList data) {
        data.add(this.xCoord);
        data.add(this.yCoord);
        data.add(this.zCoord);
        data.add(this.dimensionId);
    }

    public Coord4D translate(int x, int y, int z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
        return this;
    }

    public Coord4D getFromSide(ForgeDirection side) {
        return this.getFromSide(side, 1);
    }

    public Coord4D getFromSide(ForgeDirection side, int amount) {
        return new Coord4D(this.xCoord + side.offsetX * amount, this.yCoord + side.offsetY * amount, this.zCoord + side.offsetZ * amount, this.dimensionId);
    }

    public static Coord4D get(TileEntity tileEntity) {
        return new Coord4D(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, tileEntity.field_70331_k.field_73011_w.field_76574_g);
    }

    public static Coord4D read(NBTTagCompound nbtTags) {
        return new Coord4D(nbtTags.func_74762_e("x"), nbtTags.func_74762_e("y"), nbtTags.func_74762_e("z"), nbtTags.func_74762_e("dimensionId"));
    }

    public static Coord4D read(ByteArrayDataInput dataStream) {
        return new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
    }

    public Coord4D difference(Coord4D other) {
        return new Coord4D(this.xCoord - other.xCoord, this.yCoord - other.yCoord, this.zCoord - other.zCoord, this.dimensionId);
    }

    public ForgeDirection sideDifference(Coord4D other) {
        Coord4D diff = this.difference(other);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (side.offsetX != diff.xCoord || side.offsetY != diff.yCoord || side.offsetZ != diff.zCoord) continue;
            return side;
        }
        return ForgeDirection.UNKNOWN;
    }

    public int distanceTo(Coord4D obj) {
        int subX = this.xCoord - obj.xCoord;
        int subY = this.yCoord - obj.yCoord;
        int subZ = this.zCoord - obj.zCoord;
        return (int)MathHelper.func_76133_a((double)(subX * subX + subY * subY + subZ * subZ));
    }

    public boolean sideVisible(ForgeDirection side, IBlockAccess world) {
        return world.func_72799_c(this.xCoord + side.offsetX, this.yCoord + side.offsetY, this.zCoord + side.offsetZ);
    }

    public Coord4D step(ForgeDirection side) {
        return this.translate(side.offsetX, side.offsetY, side.offsetZ);
    }

    public boolean exists(World world) {
        return world.func_72863_F().func_73149_a(this.xCoord >> 4, this.zCoord >> 4);
    }

    public Chunk getChunk(World world) {
        return world.func_72938_d(this.xCoord >> 4, this.zCoord >> 4);
    }

    public boolean isAirBlock(IBlockAccess world) {
        return world.func_72799_c(this.xCoord, this.yCoord, this.zCoord);
    }

    public Coord4D clone() {
        return new Coord4D(this.xCoord, this.yCoord, this.zCoord, this.dimensionId);
    }

    public String toString() {
        return "[Object3D: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Coord4D && ((Coord4D)obj).xCoord == this.xCoord && ((Coord4D)obj).yCoord == this.yCoord && ((Coord4D)obj).zCoord == this.zCoord && ((Coord4D)obj).dimensionId == this.dimensionId;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.xCoord;
        code = 31 * code + this.yCoord;
        code = 31 * code + this.zCoord;
        code = 31 * code + this.dimensionId;
        return code;
    }
}

