/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.ListUtils;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiConfigurationTab;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiPowerBar;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.gui.GuiUpgradeManagement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.ContainerAdvancedElectricMachine;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAdvancedElectricMachine
extends GuiMekanism {
    public TileEntityAdvancedElectricMachine tileEntity;

    public GuiAdvancedElectricMachine(InventoryPlayer inventory, TileEntityAdvancedElectricMachine tentity) {
        super(tentity, new ContainerAdvancedElectricMachine(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiUpgradeManagement(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiConfigurationTab(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiPowerBar(this, this.tileEntity, this.tileEntity.guiLocation, 164, 15));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(MekanismUtils.getEnergyPerTick(GuiAdvancedElectricMachine.this.tileEntity.getSpeedMultiplier(new Object[0]), GuiAdvancedElectricMachine.this.tileEntity.getEnergyMultiplier(new Object[0]), GuiAdvancedElectricMachine.this.tileEntity.ENERGY_PER_TICK));
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiAdvancedElectricMachine.this.tileEntity.getMaxEnergy() - GuiAdvancedElectricMachine.this.tileEntity.getEnergy()));
            }
        }, (GuiMekanism)this, (TileEntity)this.tileEntity, this.tileEntity.guiLocation));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), this.field_74194_b / 2 - this.field_73886_k.func_78256_a(this.tileEntity.func_70303_b()) / 2, 6, 0x404040);
        this.field_73886_k.func_78276_b("Inventory", 8, this.field_74195_c - 96 + 2, 0x404040);
        if (xAxis >= 61 && xAxis <= 67 && yAxis >= 37 && yAxis <= 49) {
            this.func_74190_a(this.tileEntity.gasTank.getGas() != null ? this.tileEntity.gasTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.gasTank.getStored() : MekanismUtils.localize("gui.none"), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        this.field_73882_e.field_71446_o.func_110577_a(this.tileEntity.guiLocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        int displayInt = this.tileEntity.getScaledProgress(24);
        this.func_73729_b(guiWidth + 79, guiHeight + 39, 176, 0, displayInt + 1, 7);
        if (this.tileEntity.getScaledGasLevel(12) > 0) {
            displayInt = this.tileEntity.getScaledGasLevel(12);
            this.displayGauge(61, 49 - displayInt, 6, displayInt, this.tileEntity.gasTank.getGas());
        }
        super.func_74185_a(partialTick, mouseX, mouseY);
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, GasStack gas) {
        if (gas == null) {
            return;
        }
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73882_e.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
        this.func_94065_a(guiWidth + xPos, guiHeight + yPos, gas.getGas().getIcon(), sizeX, sizeY);
    }
}

