/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiBucket;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerChemicalWasher;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalWasher
extends GuiMekanism {
    public TileEntityChemicalWasher tileEntity;

    public GuiChemicalWasher(InventoryPlayer inventory, TileEntityChemicalWasher tentity) {
        super(tentity, new ContainerChemicalWasher(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalWasher.png")));
        this.guiElements.add(new GuiBucket(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalWasher.png")));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiChemicalWasher.this.tileEntity.ENERGY_USAGE);
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiChemicalWasher.this.tileEntity.getMaxEnergy() - GuiChemicalWasher.this.tileEntity.getEnergy()));
            }
        }, (GuiMekanism)this, (TileEntity)this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalWasher.png")));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), 45, 4, 0x404040);
        if (xAxis >= 116 && xAxis <= 168 && yAxis >= 76 && yAxis <= 80) {
            this.func_74190_a(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy()), xAxis, yAxis);
        }
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 5 && yAxis <= 63) {
            this.func_74190_a(this.tileEntity.fluidTank.getFluid() != null ? this.tileEntity.fluidTank.getFluid().getFluid().getLocalizedName() + ": " + this.tileEntity.fluidTank.getFluidAmount() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 27 && xAxis <= 43 && yAxis >= 14 && yAxis <= 72) {
            this.func_74190_a(this.tileEntity.inputTank.getGas() != null ? this.tileEntity.inputTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.inputTank.getStored() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 134 && xAxis <= 150 && yAxis >= 14 && yAxis <= 72) {
            this.func_74190_a(this.tileEntity.outputTank.getGas() != null ? this.tileEntity.outputTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.outputTank.getStored() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        super.func_74185_a(partialTick, mouseX, mouseY);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalWasher.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        int displayInt = this.tileEntity.getScaledEnergyLevel(52);
        this.func_73729_b(guiWidth + 116, guiHeight + 76, 176, 0, displayInt, 4);
        if (this.tileEntity.isActive) {
            this.func_73729_b(guiWidth + 61, guiHeight + 39, 176, 63, 55, 8);
        }
        if (this.tileEntity.getScaledFluidLevel(58) > 0) {
            this.displayGauge(6, 5, this.tileEntity.getScaledFluidLevel(58), this.tileEntity.fluidTank.getFluid(), null);
        }
        if (this.tileEntity.getScaledInputGasLevel(58) > 0) {
            this.displayGauge(27, 14, this.tileEntity.getScaledInputGasLevel(58), null, this.tileEntity.inputTank.getGas());
        }
        if (this.tileEntity.getScaledOutputGasLevel(58) > 0) {
            this.displayGauge(134, 14, this.tileEntity.getScaledOutputGasLevel(58), null, this.tileEntity.outputTank.getGas());
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            int xAxis = x - (this.field_73880_f - this.field_74194_b) / 2;
            int yAxis = y - (this.field_73881_g - this.field_74195_c) / 2;
            if (xAxis > 45 && xAxis < 63 && yAxis > 13 && yAxis < 21) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(0);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Coord4D.get(this.tileEntity), data), new Object[0]);
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
            }
        }
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_73882_e.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, fluid.getFluid().getIcon(), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, gas.getGas().getIcon(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalWasher.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, 4, 16, 59);
    }
}

