/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerElectrolyticSeparator;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiElectrolyticSeparator
extends GuiMekanism {
    public TileEntityElectrolyticSeparator tileEntity;

    public GuiElectrolyticSeparator(InventoryPlayer inventory, TileEntityElectrolyticSeparator tentity) {
        super(new ContainerElectrolyticSeparator(inventory, tentity));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(Mekanism.electrolyticSeparatorUsage);
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiElectrolyticSeparator.this.tileEntity.getMaxEnergy() - GuiElectrolyticSeparator.this.tileEntity.getEnergy()));
            }
        }, (GuiMekanism)this, (TileEntity)this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png")));
        this.tileEntity = tentity;
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        int xAxis = x - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = y - (this.field_73881_g - this.field_74195_c) / 2;
        if (xAxis > 8 && xAxis < 17 && yAxis > 73 && yAxis < 82) {
            ArrayList<Byte> data = new ArrayList<Byte>();
            data.add((byte)0);
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Coord4D.get(this.tileEntity), data), new Object[0]);
            this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
        } else if (xAxis > 160 && xAxis < 169 && yAxis > 73 && yAxis < 82) {
            ArrayList<Byte> data = new ArrayList<Byte>();
            data.add((byte)1);
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Coord4D.get(this.tileEntity), data), new Object[0]);
            this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
        }
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), 45, 6, 0x404040);
        String name = this.tileEntity.dumpLeft ? "Dumping..." : (this.tileEntity.leftTank.getGas() == null ? MekanismUtils.localize("gui.none") : this.tileEntity.leftTank.getGas().getGas().getLocalizedName());
        this.field_73886_k.func_78276_b(name, 21, 73, 0x404040);
        name = this.tileEntity.dumpRight ? "Dumping..." : (this.tileEntity.rightTank.getGas() == null ? MekanismUtils.localize("gui.none") : this.tileEntity.rightTank.getGas().getGas().getLocalizedName());
        this.field_73886_k.func_78276_b(name, 156 - this.field_73886_k.func_78256_a(name), 73, 0x404040);
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 11 && yAxis <= 69) {
            this.func_74190_a(this.tileEntity.fluidTank.getFluid() != null ? this.tileEntity.fluidTank.getFluid().getFluid().getLocalizedName() + ": " + this.tileEntity.fluidTank.getFluidAmount() + "mB" : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 59 && xAxis <= 75 && yAxis >= 19 && yAxis <= 47) {
            this.func_74190_a(this.tileEntity.leftTank.getGas() != null ? this.tileEntity.leftTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.leftTank.getStored() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 101 && xAxis <= 117 && yAxis >= 19 && yAxis <= 47) {
            this.func_74190_a(this.tileEntity.rightTank.getGas() != null ? this.tileEntity.rightTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.rightTank.getStored() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 165 && xAxis <= 169 && yAxis >= 17 && yAxis <= 69) {
            this.func_74190_a(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy()), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        super.func_74185_a(partialTick, mouseX, mouseY);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        int displayInt = this.tileEntity.dumpLeft ? 60 : 52;
        this.func_73729_b(guiWidth + 8, guiHeight + 73, 176, displayInt, 8, 8);
        displayInt = this.tileEntity.dumpRight ? 60 : 52;
        this.func_73729_b(guiWidth + 160, guiHeight + 73, 176, displayInt, 8, 8);
        if (this.tileEntity.fluidTank.getFluid() != null) {
            this.displayGauge(58, 6, 11, this.tileEntity.getScaledFluidLevel(58), this.tileEntity.fluidTank.getFluid(), null);
        }
        if (this.tileEntity.leftTank.getGas() != null) {
            this.displayGauge(28, 59, 19, this.tileEntity.getLeftScaledLevel(28), null, this.tileEntity.leftTank.getGas());
        }
        if (this.tileEntity.rightTank.getGas() != null) {
            this.displayGauge(28, 101, 19, this.tileEntity.getRightScaledLevel(28), null, this.tileEntity.rightTank.getGas());
        }
        displayInt = this.tileEntity.getScaledEnergyLevel(52);
        this.func_73729_b(guiWidth + 165, guiHeight + 17 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);
    }

    public void displayGauge(int length, int xPos, int yPos, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_73882_e.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + length - renderRemaining - start, fluid.getFluid().getIcon(), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + length - renderRemaining - start, gas.getGas().getIcon(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiElectrolyticSeparator.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, 68, 16, length + 1);
    }
}

