/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.client.gui.GuiSalinationController;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class SalinationControllerRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    private static Map<FluidStack, FluidStack> recipes = new HashMap<FluidStack, FluidStack>();
    public static int xOffset = 5;
    public static int yOffset = 12;

    public String getRecipeName() {
        return MekanismUtils.localize("tile.BasicBlock.SalinationController.name");
    }

    public String getOverlayIdentifier() {
        return "salinationcontroller";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiSalinationController.png";
    }

    public Class getGuiClass() {
        return GuiSalinationController.class;
    }

    public String getRecipeId() {
        return "mekanism.salinationcontroller";
    }

    public Set<Map.Entry<FluidStack, FluidStack>> getRecipes() {
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)62);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        this.drawProgressBar(49 - xOffset, 64 - yOffset, 176, 59, 78, 8, this.ticksPassed < 20 ? (float)(this.ticksPassed % 20) / 20.0f : 1.0f, 0);
        if (recipe.fluidInput != null) {
            this.displayGauge(58, 7 - xOffset, 14 - yOffset, 176, 0, 58, recipe.fluidInput, null);
        }
        if (recipe.fluidOutput != null) {
            this.displayGauge(58, 153 - xOffset, 14 - yOffset, 176, 0, 58, recipe.fluidOutput, null);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<FluidStack, FluidStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("fluid") && results.length == 1 && results[0] instanceof FluidStack) {
            for (Map.Entry<FluidStack, FluidStack> irecipe : this.getRecipes()) {
                if (!((FluidStack)results[0]).isFluidEqual(irecipe.getValue())) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fluid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            for (Map.Entry<FluidStack, FluidStack> irecipe : this.getRecipes()) {
                if (!irecipe.getKey().isFluidEqual((FluidStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput.getFluid().getLocalizedName());
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidOutput.getFluid().getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        FluidStack stack = null;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput;
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidOutput;
        }
        if (stack != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doFluidLookup(stack, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doFluidLookup(stack, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        FluidStack stack = null;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidInput;
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 18 && yAxis <= 76) {
            stack = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).fluidOutput;
        }
        if (stack != null && (button == 0 ? this.doFluidLookup(stack, false) : button == 1 && this.doFluidLookup(stack, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    static {
        if (recipes.isEmpty()) {
            recipes.put(new FluidStack(FluidRegistry.WATER, 1), new FluidStack(FluidRegistry.getFluid((String)"brine"), 1));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public FluidStack fluidInput;
        public FluidStack fluidOutput;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(FluidStack input, FluidStack output) {
            super((TemplateRecipeHandler)SalinationControllerRecipeHandler.this);
            this.fluidInput = input;
            this.fluidOutput = output;
        }

        public CachedIORecipe(Map.Entry recipe) {
            this((FluidStack)recipe.getKey(), (FluidStack)recipe.getValue());
        }
    }
}

