/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.Coord4D;
import mekanism.common.tile.TileEntityBin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBin
extends TileEntitySpecialRenderer {
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private final RenderItem renderItem = (RenderItem)RenderManager.field_78727_a.func_78715_a(EntityItem.class);

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityBin)tileEntity, x, y, z, partialTick);
    }

    private void renderAModelAt(TileEntityBin tileEntity, double x, double y, double z, float partialTick) {
        if (tileEntity instanceof TileEntityBin) {
            String amount = "";
            ItemStack itemStack = tileEntity.itemType;
            if (itemStack != null) {
                amount = Integer.toString(tileEntity.clientAmount);
            }
            Coord4D obj = Coord4D.get(tileEntity).getFromSide(ForgeDirection.getOrientation((int)tileEntity.facing));
            if (tileEntity.field_70331_k.isBlockSolidOnSide(obj.xCoord, obj.yCoord, obj.zCoord, ForgeDirection.getOrientation((int)tileEntity.facing).getOpposite())) {
                return;
            }
            this.doLight(tileEntity.field_70331_k, obj);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            if (itemStack != null) {
                GL11.glPushMatrix();
                switch (ForgeDirection.getOrientation((int)tileEntity.facing)) {
                    case NORTH: {
                        GL11.glTranslated((double)(x + 0.73), (double)(y + 0.83), (double)(z - 0.01));
                        break;
                    }
                    case SOUTH: {
                        GL11.glTranslated((double)(x + 0.27), (double)(y + 0.83), (double)(z + 1.01));
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GL11.glTranslated((double)(x - 0.01), (double)(y + 0.83), (double)(z + 0.27));
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GL11.glTranslated((double)(x + 1.01), (double)(y + 0.83), (double)(z + 0.73));
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                float scale = 0.03125f;
                float scaler = 0.9f;
                GL11.glScalef((float)(scale * scaler), (float)(scale * scaler), (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
                GL11.glDisable((int)2896);
                this.renderItem.func_82406_b(this.func_76895_b(), renderEngine, itemStack, 0, 0);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
            if (amount != "") {
                this.renderText(amount, ForgeDirection.getOrientation((int)tileEntity.facing), 0.02f, x, y - (double)0.31f, z);
            }
        }
    }

    private void doLight(World world, Coord4D obj) {
        if (world.func_72804_r(obj.xCoord, obj.yCoord, obj.zCoord)) {
            return;
        }
        int brightness = world.func_72802_i(obj.xCoord, obj.yCoord, obj.zCoord, 0);
        int lightX = brightness % 65536;
        int lightY = brightness / 65536;
        float scale = 0.6f;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lightX * scale), (float)((float)lightY * scale));
    }

    private void renderText(String text, ForgeDirection side, float maxScale, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glPolygonOffset((float)-10.0f, (float)-10.0f);
        GL11.glEnable((int)32823);
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        GL11.glTranslated((double)x, (double)y, (double)z);
        switch (side) {
            case SOUTH: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GL11.glTranslatef((float)(displayWidth / 2.0f), (float)1.0f, (float)(displayHeight / 2.0f));
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FontRenderer fontRenderer = this.func_76895_b();
        int requiredWidth = Math.max(fontRenderer.func_78256_a(text), 1);
        int lineHeight = fontRenderer.field_78288_b + 2;
        int requiredHeight = lineHeight * 1;
        float scaler = 0.4f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scale = scaleX * scaler;
        if (maxScale > 0.0f) {
            scale = Math.min(scale, maxScale);
        }
        GL11.glScalef((float)scale, (float)(-scale), (float)scale);
        GL11.glDepthMask((boolean)false);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        GL11.glDisable((int)2896);
        fontRenderer.func_78276_b("\u00a7f" + text, offsetX - realWidth / 2, 1 + offsetY - realHeight / 2, 1);
        GL11.glEnable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)32823);
        GL11.glPopMatrix();
    }
}

