/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.IInvConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderConfigurableMachine
extends TileEntitySpecialRenderer {
    private Minecraft mc = FMLClientHandler.instance().getClient();
    private HashMap<ForgeDirection, HashMap<EnumColor, MekanismRenderer.DisplayInteger>> cachedOverlays = new HashMap();

    public RenderConfigurableMachine() {
        this.field_76898_b = TileEntityRenderer.field_76963_a;
    }

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((IInvConfiguration)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(IInvConfiguration configurable, double x, double y, double z, float partialTick) {
        GL11.glPushMatrix();
        TileEntity tileEntity = (TileEntity)configurable;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        World world = this.mc.field_71439_g.field_70170_p;
        ItemStack itemStack = player.func_71045_bC();
        MovingObjectPosition pos = player.func_70614_a(8.0, 1.0f);
        if (pos != null && itemStack != null && itemStack.func_77973_b() instanceof ItemConfigurator && ((ItemConfigurator)itemStack.func_77973_b()).getState(itemStack) == 0) {
            int xPos = MathHelper.func_76128_c((double)pos.field_72311_b);
            int yPos = MathHelper.func_76128_c((double)pos.field_72312_c);
            int zPos = MathHelper.func_76128_c((double)pos.field_72309_d);
            Coord4D obj = new Coord4D(xPos, yPos, zPos, tileEntity.field_70331_k.field_73011_w.field_76574_g);
            if (xPos == tileEntity.field_70329_l && yPos == tileEntity.field_70330_m && zPos == tileEntity.field_70327_n) {
                EnumColor color = configurable.getSideData().get((int)configurable.getConfiguration()[MekanismUtils.getBaseOrientation((int)pos.field_72310_e, (int)configurable.getOrientation())]).color;
                this.push();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                this.func_110628_a(MekanismRenderer.getBlocksTexture());
                GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                int display = this.getOverlayDisplay((World)world, (ForgeDirection)ForgeDirection.getOrientation((int)pos.field_72310_e), (EnumColor)color).display;
                GL11.glCallList((int)display);
                this.pop();
            }
        }
        GL11.glPopMatrix();
    }

    private void pop() {
        GL11.glPopAttrib();
        MekanismRenderer.glowOff();
        MekanismRenderer.blendOff();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        MekanismRenderer.glowOn();
        MekanismRenderer.blendOn();
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(World world, ForgeDirection side, EnumColor color) {
        if (this.cachedOverlays.containsKey(side) && this.cachedOverlays.get(side).containsKey((Object)color)) {
            return this.cachedOverlays.get(side).get((Object)color);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71981_t;
        toReturn.setTexture(MekanismRenderer.getColorIcon(color));
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedOverlays.containsKey(side)) {
            this.cachedOverlays.get(side).put(color, display);
        } else {
            HashMap<EnumColor, MekanismRenderer.DisplayInteger> map = new HashMap<EnumColor, MekanismRenderer.DisplayInteger>();
            map.put(color, display);
            this.cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = 0.0;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.0;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = 0.0;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.0;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = 0.0;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.0;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        return display;
    }
}

