/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.net.URL;
import java.util.Map;
import mekanism.api.Pos3D;
import mekanism.client.MekanismClient;
import mekanism.client.sound.SoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;

public abstract class Sound {
    public String soundPath;
    public String identifier;
    public boolean isPlaying = false;
    public int ticksSincePlay = 0;
    private Object objRef;
    protected Minecraft mc = Minecraft.func_71410_x();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sound(String id, String sound, Object obj, Pos3D loc) {
        if (MekanismClient.audioHandler.getFrom(obj) != null) {
            return;
        }
        Map<Object, Sound> map = MekanismClient.audioHandler.sounds;
        synchronized (map) {
            this.soundPath = sound;
            this.identifier = id;
            this.objRef = obj;
            URL url = this.getClass().getClassLoader().getResource("assets/mekanism/sound/" + sound);
            if (url == null) {
                System.out.println("[Mekanism] Invalid sound file: " + sound);
            }
            if (SoundHandler.getSoundSystem() != null) {
                SoundHandler.getSoundSystem().newSource(false, id, url, sound, true, (float)loc.xPos, (float)loc.yPos, (float)loc.zPos, 0, 16.0f);
                this.updateVolume();
                SoundHandler.getSoundSystem().activate(id);
            }
            MekanismClient.audioHandler.sounds.put(obj, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Map<Object, Sound> map = MekanismClient.audioHandler.sounds;
        synchronized (map) {
            if (this.isPlaying) {
                return;
            }
            this.ticksSincePlay = 0;
            if (SoundHandler.getSoundSystem() != null) {
                this.updateVolume();
                SoundHandler.getSoundSystem().play(this.identifier);
            }
            this.isPlaying = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoop() {
        Map<Object, Sound> map = MekanismClient.audioHandler.sounds;
        synchronized (map) {
            if (!this.isPlaying) {
                return;
            }
            if (SoundHandler.getSoundSystem() != null) {
                this.updateVolume();
                SoundHandler.getSoundSystem().stop(this.identifier);
            }
            this.isPlaying = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        Map<Object, Sound> map = MekanismClient.audioHandler.sounds;
        synchronized (map) {
            if (this.isPlaying) {
                this.stopLoop();
            }
            MekanismClient.audioHandler.sounds.remove(this.objRef);
            if (SoundHandler.getSoundSystem() != null) {
                this.updateVolume();
                SoundHandler.getSoundSystem().removeSource(this.identifier);
            }
        }
    }

    public abstract boolean update(World var1);

    public abstract Pos3D getLocation();

    public float getMultiplier() {
        return Math.min(1.0f, (float)this.ticksSincePlay / 30.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVolume() {
        Map<Object, Sound> map = MekanismClient.audioHandler.sounds;
        synchronized (map) {
            try {
                float multiplier = this.getMultiplier();
                float volume = 0.0f;
                float masterVolume = MekanismClient.audioHandler.masterVolume;
                double distance = this.mc.field_71439_g.func_70011_f(this.getLocation().xPos, this.getLocation().yPos, this.getLocation().zPos);
                volume = (float)Math.min(Math.max((double)masterVolume - distance * (double)0.08f * (double)masterVolume, 0.0) * (double)multiplier, 1.0);
                volume = (float)((double)volume * Math.max(0.0, Math.min(1.0, MekanismClient.baseSoundVolume)));
                if (SoundHandler.getSoundSystem() != null) {
                    SoundHandler.getSoundSystem().setVolume(this.identifier, volume);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

