/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mekanism.api.Coord4D;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.sound.IHasSound;
import mekanism.client.sound.Sound;
import mekanism.client.sound.TileSound;
import mekanism.common.Mekanism;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;
import paulscode.sound.SoundSystem;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    public Map<Object, Sound> sounds = Collections.synchronizedMap(new HashMap());
    public float masterVolume = 0.0f;
    public Minecraft mc = Minecraft.func_71410_x();

    public SoundHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        System.out.println("[Mekanism] Successfully set up SoundHandler.");
    }

    public void preloadSounds() {
        CodeSource src = this.getClass().getProtectionDomain().getCodeSource();
        String corePath = src.getLocation().getFile().split("/mekanism/client")[0];
        List<String> listings = this.listFiles(corePath.replace("%20", " ").replace(".jar!", ".jar").replace("file:", ""), "assets/mekanism/sound");
        for (String s : listings) {
            if (s.contains("etc") || s.contains("holiday")) continue;
            if (s.contains("/mekanism/sound/")) {
                s = s.split("/mekanism/sound/")[1];
            }
            this.preloadSound(s);
        }
        System.out.println("[Mekanism] Preloaded " + listings.size() + " object sounds.");
        listings = this.listFiles(corePath.replace("%20", " ").replace(".jar!", ".jar").replace("file:", ""), "assets/mekanism/sound/etc");
        for (String s : listings) {
            if (s.contains("/mekanism/sound/etc/")) {
                s = s.split("/mekanism/sound/etc/")[1];
            }
            this.mc.field_71416_A.func_77372_a("mekanism:etc/" + s);
        }
        System.out.println("[Mekanism] Initialized " + listings.size() + " sound effects.");
        if (MekanismClient.holidays) {
            listings = this.listFiles(corePath.replace("%20", " ").replace(".jar!", ".jar").replace("file:", ""), "assets/mekanism/sound/holiday");
            for (String s : listings) {
                if (s.contains("/mekanism/sound/")) {
                    s = s.split("/mekanism/sound/")[1];
                }
                if (!s.contains("holiday")) {
                    s = "holiday/" + s;
                }
                this.preloadSound(s);
            }
        }
    }

    private List<String> listFiles(String path, String s) {
        ArrayList<String> names = new ArrayList<String>();
        File f = new File(path);
        if (!f.exists()) {
            return names;
        }
        if (!f.isDirectory()) {
            try {
                ZipEntry e;
                ZipInputStream zip = new ZipInputStream(new FileInputStream(path));
                while ((e = zip.getNextEntry()) != null) {
                    String name = e.getName();
                    if (!name.contains(s) || !name.endsWith(".ogg")) continue;
                    names.add(name);
                }
                zip.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            f = new File(path + "/" + s);
            for (File file : f.listFiles()) {
                if (!file.getPath().contains(s) || !file.getName().endsWith(".ogg")) continue;
                names.add(file.getName());
            }
        }
        return names;
    }

    private void preloadSound(String sound) {
        String id = "pre_" + sound;
        URL url = this.getClass().getClassLoader().getResource("assets/mekanism/sound/" + sound);
        if (SoundHandler.getSoundSystem() != null) {
            SoundHandler.getSoundSystem().newSource(false, id, url, sound, true, 0.0f, 0.0f, 0.0f, 0, 16.0f);
            SoundHandler.getSoundSystem().activate(id);
            SoundHandler.getSoundSystem().removeSource(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            if (SoundHandler.getSoundSystem() != null) {
                if (!Mekanism.proxy.isPaused()) {
                    ArrayList<Sound> soundsToRemove = new ArrayList<Sound>();
                    WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
                    for (Sound sound : this.sounds.values()) {
                        if (FMLClientHandler.instance().getClient().field_71439_g == null || world == null || sound.update((World)world)) continue;
                        soundsToRemove.add(sound);
                    }
                    for (Sound sound : soundsToRemove) {
                        sound.remove();
                    }
                    for (Sound sound : this.sounds.values()) {
                        if (!sound.isPlaying) continue;
                        sound.updateVolume();
                    }
                    this.masterVolume = FMLClientHandler.instance().getClient().field_71474_y.field_74340_b;
                } else {
                    for (Sound sound : this.sounds.values()) {
                        if (!sound.isPlaying) continue;
                        sound.stopLoop();
                    }
                }
            } else {
                Mekanism.proxy.unloadSoundHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sound getFrom(Object obj) {
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            return this.sounds.get(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object obj) {
        if (obj instanceof TileEntity && !(obj instanceof IHasSound)) {
            return;
        }
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            if (this.getFrom(obj) == null && obj instanceof TileEntity) {
                new TileSound(this.getIdentifier(), HolidayManager.filterSound(((IHasSound)obj).getSoundPath()), (TileEntity)obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdentifier() {
        Map<Object, Sound> map = this.sounds;
        synchronized (map) {
            String toReturn = "Mekanism_" + this.sounds.size() + "_" + new Random().nextInt(10000);
            for (Sound sound : this.sounds.values()) {
                if (!sound.identifier.equals(toReturn)) continue;
                return this.getIdentifier();
            }
            return toReturn;
        }
    }

    public void quickPlay(String soundPath, World world, Coord4D object) {
        URL url = this.getClass().getClassLoader().getResource("assets/mekanism/sound/" + soundPath);
        if (url == null) {
            System.out.println("[Mekanism] Invalid sound file: " + soundPath);
        }
        String s = SoundHandler.getSoundSystem().quickPlay(false, url, soundPath, false, (float)object.xCoord, (float)object.yCoord, (float)object.zCoord, 0, 16.0f);
        SoundHandler.getSoundSystem().setVolume(s, this.masterVolume);
    }

    public static SoundSystem getSoundSystem() {
        return Minecraft.func_71410_x().field_71416_A.field_77381_a;
    }

    @ForgeSubscribe
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getChunk() != null) {
            for (Object obj : event.getChunk().field_76648_i.values()) {
                TileEntity tileEntity;
                if (!(obj instanceof TileEntity) || !((tileEntity = (TileEntity)obj) instanceof IHasSound) || this.getFrom(tileEntity) == null || !this.sounds.containsKey(tileEntity)) continue;
                this.getFrom(tileEntity).remove();
            }
        }
    }
}

