/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.tile.IEnergySink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mekanism.api.ListUtils;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class EnergyNetwork
extends DynamicNetwork<TileEntity, EnergyNetwork> {
    private double lastPowerScale = 0.0;
    private double joulesTransmitted = 0.0;
    private double jouleBufferLastTick = 0.0;
    public double clientEnergyScale = 0.0;
    public double electricityStored;

    public EnergyNetwork(IGridTransmitter<EnergyNetwork> ... varCables) {
        this.transmitters.addAll(Arrays.asList(varCables));
        this.register();
    }

    public EnergyNetwork(Collection<IGridTransmitter<EnergyNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public static double round(double d) {
        return Math.round(d * 10000.0) / 10000L;
    }

    public EnergyNetwork(Set<EnergyNetwork> networks) {
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            if (net.jouleBufferLastTick > this.jouleBufferLastTick || net.clientEnergyScale > this.clientEnergyScale) {
                this.clientEnergyScale = net.clientEnergyScale;
                this.jouleBufferLastTick = net.jouleBufferLastTick;
                this.joulesTransmitted = net.joulesTransmitted;
                this.lastPowerScale = net.lastPowerScale;
            }
            this.electricityStored += net.electricityStored;
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.refresh();
        this.register();
    }

    @Override
    public double getMeanCapacity() {
        int numCables = this.transmitters.size();
        double reciprocalSum = 0.0;
        for (IGridTransmitter cable : this.transmitters) {
            reciprocalSum += 1.0 / (double)cable.getCapacity();
        }
        return (double)numCables / reciprocalSum;
    }

    @Override
    public void onNetworksCreated(List<EnergyNetwork> networks) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            double[] caps = new double[networks.size()];
            double cap = 0.0;
            for (EnergyNetwork network : networks) {
                caps[networks.indexOf((Object)network)] = network.getCapacity();
                cap += (double)network.getCapacity();
            }
            this.electricityStored = Math.min(cap, this.electricityStored);
            double[] percent = ListUtils.percent(caps);
            for (EnergyNetwork network : networks) {
                network.electricityStored = EnergyNetwork.round(percent[networks.indexOf(network)] * this.electricityStored);
            }
        }
    }

    public synchronized double getEnergyNeeded() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        return (double)this.getCapacity() - this.electricityStored;
    }

    public synchronized double tickEmit(double energyToSend) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        double sent = 0.0;
        boolean tryAgain = false;
        do {
            tryAgain = false;
            double prev = sent;
            if (!(energyToSend - (sent += this.doEmit(energyToSend - sent)) > 0.0) || !(sent - prev > 0.0)) continue;
            tryAgain = true;
        } while (tryAgain);
        this.joulesTransmitted = sent;
        return sent;
    }

    public synchronized double emit(double energyToSend) {
        double toUse = Math.min(this.getEnergyNeeded(), energyToSend);
        this.electricityStored += toUse;
        return energyToSend - toUse;
    }

    public synchronized double doEmit(double energyToSend) {
        double sent = 0.0;
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(new Object[0]).toArray());
        Collections.shuffle(availableAcceptors);
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            double remaining = energyToSend % (double)divider;
            double sending = (energyToSend - remaining) / (double)divider;
            for (Object obj : availableAcceptors) {
                PowerHandler.PowerReceiver receiver;
                if (!(obj instanceof TileEntity)) continue;
                TileEntity acceptor = (TileEntity)obj;
                double currentSending = sending + remaining;
                ForgeDirection side = (ForgeDirection)this.acceptorDirections.get(acceptor);
                if (side == null) continue;
                remaining = 0.0;
                if (acceptor instanceof IStrictEnergyAcceptor) {
                    sent += ((IStrictEnergyAcceptor)acceptor).transferEnergyToAcceptor(side.getOpposite(), currentSending);
                    continue;
                }
                if (acceptor instanceof IEnergyHandler) {
                    IEnergyHandler handler = (IEnergyHandler)acceptor;
                    int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(currentSending * Mekanism.TO_TE), false);
                    sent += (double)used * Mekanism.FROM_TE;
                    continue;
                }
                if (acceptor instanceof IEnergySink) {
                    double toSend = Math.min(currentSending, (double)((IEnergySink)acceptor).getMaxSafeInput() * Mekanism.FROM_IC2);
                    toSend = Math.min(toSend, ((IEnergySink)acceptor).demandedEnergyUnits() * Mekanism.FROM_IC2);
                    sent += toSend - ((IEnergySink)acceptor).injectEnergyUnits(side.getOpposite(), toSend * Mekanism.TO_IC2) * Mekanism.FROM_IC2;
                    continue;
                }
                if (!(acceptor instanceof IPowerReceptor) || !MekanismUtils.useBuildCraft() || (receiver = ((IPowerReceptor)acceptor).getPowerReceiver(side.getOpposite())) == null) continue;
                float toSend = receiver.receiveEnergy(PowerHandler.Type.PIPE, (float)Math.min((double)receiver.powerRequest(), currentSending * Mekanism.TO_BC), side.getOpposite());
                sent += (double)toSend * Mekanism.FROM_BC;
            }
        }
        return sent;
    }

    @Override
    public synchronized Set<TileEntity> getAcceptors(Object ... data) {
        HashSet<TileEntity> toReturn = new HashSet<TileEntity>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        Set copy = (Set)this.possibleAcceptors.clone();
        for (TileEntity acceptor : copy) {
            Object handler;
            ForgeDirection side = (ForgeDirection)this.acceptorDirections.get(acceptor);
            if (side == null) continue;
            if (acceptor instanceof IStrictEnergyAcceptor) {
                handler = (IStrictEnergyAcceptor)acceptor;
                if (!handler.canReceiveEnergy(side.getOpposite()) || !(handler.getMaxEnergy() - handler.getEnergy() > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (acceptor instanceof IEnergyHandler) {
                handler = (IEnergyHandler)acceptor;
                if (!handler.canInterface(side.getOpposite()) || handler.getMaxEnergyStored(side.getOpposite()) - handler.getEnergyStored(side.getOpposite()) <= 0 && handler.receiveEnergy(side.getOpposite(), 1, true) <= 0) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (acceptor instanceof IEnergySink) {
                handler = (IEnergySink)acceptor;
                if (!handler.acceptsEnergyFrom(null, side.getOpposite()) || !(Math.min(handler.demandedEnergyUnits() * Mekanism.FROM_IC2, (double)handler.getMaxSafeInput() * Mekanism.FROM_IC2) > 0.0)) continue;
                toReturn.add(acceptor);
                continue;
            }
            if (!(acceptor instanceof IPowerReceptor) || !MekanismUtils.useBuildCraft() || (handler = (IPowerReceptor)acceptor).getPowerReceiver(side.getOpposite()) == null || !((double)handler.getPowerReceiver(side.getOpposite()).powerRequest() * Mekanism.FROM_BC > 0.0) || handler instanceof IPowerEmitter && ((IPowerEmitter)handler).canEmitPowerFrom(side.getOpposite())) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterCables = (Set)this.transmitters.clone();
        Iterator it = iterCables.iterator();
        this.possibleAcceptors.clear();
        this.acceptorDirections.clear();
        while (it.hasNext()) {
            IGridTransmitter conductor = (IGridTransmitter)it.next();
            if (conductor == null || ((TileEntity)conductor).func_70320_p()) {
                it.remove();
                this.transmitters.remove(conductor);
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        for (IGridTransmitter transmitter : iterCables) {
            TileEntity[] acceptors;
            for (TileEntity acceptor : acceptors = CableUtils.getConnectedEnergyAcceptors((TileEntity)transmitter)) {
                ForgeDirection side = ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor));
                if (side == null || acceptor == null || acceptor instanceof IGridTransmitter || !transmitter.canConnectToAcceptor(side, true)) continue;
                this.possibleAcceptors.add(acceptor);
                this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
            }
        }
        this.needsUpdate = true;
    }

    @Override
    public synchronized void merge(EnergyNetwork network) {
        if (network != null && network != this) {
            HashSet<EnergyNetwork> networks = new HashSet<EnergyNetwork>();
            networks.add(this);
            networks.add(network);
            ITransmitterNetwork newNetwork = this.create(networks);
            ((EnergyNetwork)newNetwork).refresh();
        }
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.clearJoulesTransmitted();
        double currentPowerScale = this.getPowerScale();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (Math.abs(currentPowerScale - this.lastPowerScale) > 0.01 || currentPowerScale != this.lastPowerScale && (currentPowerScale == 0.0 || currentPowerScale == 1.0)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this, currentPowerScale));
                this.lastPowerScale = currentPowerScale;
                this.needsUpdate = false;
            }
            if (this.electricityStored > 0.0) {
                this.electricityStored -= this.tickEmit(this.electricityStored);
            }
        }
    }

    public double getPowerScale() {
        return Math.max(this.jouleBufferLastTick == 0.0 ? 0.0 : Math.min(Math.ceil(Math.log10(this.getPower()) * 2.0) / 10.0, 1.0), this.getCapacity() == 0 ? 0.0 : this.electricityStored / (double)this.getCapacity());
    }

    public void clearJoulesTransmitted() {
        this.jouleBufferLastTick = this.electricityStored;
        this.joulesTransmitted = 0.0;
    }

    public double getPower() {
        return this.jouleBufferLastTick * 20.0;
    }

    protected EnergyNetwork create(IGridTransmitter<EnergyNetwork> ... varTransmitters) {
        EnergyNetwork network = new EnergyNetwork(varTransmitters);
        network.clientEnergyScale = this.clientEnergyScale;
        network.jouleBufferLastTick = this.jouleBufferLastTick;
        network.joulesTransmitted = this.joulesTransmitted;
        network.lastPowerScale = this.lastPowerScale;
        network.electricityStored += this.electricityStored;
        return network;
    }

    protected EnergyNetwork create(Collection<IGridTransmitter<EnergyNetwork>> collection) {
        EnergyNetwork network = new EnergyNetwork(collection);
        network.clientEnergyScale = this.clientEnergyScale;
        network.jouleBufferLastTick = this.jouleBufferLastTick;
        network.joulesTransmitted = this.joulesTransmitted;
        network.lastPowerScale = this.lastPowerScale;
        network.electricityStored += this.electricityStored;
        return network;
    }

    protected EnergyNetwork create(Set<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public String getNeeded() {
        return MekanismUtils.getEnergyDisplay(this.getEnergyNeeded());
    }

    @Override
    public String getStored() {
        return MekanismUtils.getEnergyDisplay(this.electricityStored);
    }

    @Override
    public String getFlow() {
        return MekanismUtils.getEnergyDisplay(20.0 * this.joulesTransmitted) + " per second";
    }

    public static class EnergyTransferEvent
    extends Event {
        public final EnergyNetwork energyNetwork;
        public final double power;

        public EnergyTransferEvent(EnergyNetwork network, double currentPower) {
            this.energyNetwork = network;
            this.power = currentPower;
        }
    }
}

