/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Map;
import mekanism.api.AdvancedInput;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.ForgeDirection;

public interface IFactory {
    public int getRecipeType(ItemStack var1);

    public void setRecipeType(int var1, ItemStack var2);

    public static enum RecipeType {
        SMELTING("smelting", "Smelter.ogg", BlockMachine.MachineType.ENERGIZED_SMELTER.getStack(), false, null),
        ENRICHING("enriching", "Chamber.ogg", BlockMachine.MachineType.ENRICHMENT_CHAMBER.getStack(), false, RecipeHandler.Recipe.ENRICHMENT_CHAMBER),
        CRUSHING("crushing", "Crusher.ogg", BlockMachine.MachineType.CRUSHER.getStack(), false, RecipeHandler.Recipe.CRUSHER),
        COMPRESSING("compressing", "Compressor.ogg", BlockMachine.MachineType.OSMIUM_COMPRESSOR.getStack(), true, RecipeHandler.Recipe.OSMIUM_COMPRESSOR),
        COMBINING("combining", "Combiner.ogg", BlockMachine.MachineType.COMBINER.getStack(), true, RecipeHandler.Recipe.COMBINER),
        PURIFYING("purifying", "PurificationChamber.ogg", BlockMachine.MachineType.PURIFICATION_CHAMBER.getStack(), true, RecipeHandler.Recipe.PURIFICATION_CHAMBER),
        INJECTING("injecting", "ChemicalInjectionChamber.ogg", BlockMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.getStack(), true, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER);

        private String name;
        private String sound;
        private ItemStack stack;
        private boolean usesFuel;
        private RecipeHandler.Recipe recipe;
        private TileEntityAdvancedElectricMachine cacheTile;

        public ItemStack getCopiedOutput(ItemStack input, Gas gas, boolean stackDecrease) {
            if (input == null) {
                return null;
            }
            if (this == SMELTING) {
                if (FurnaceRecipes.func_77602_a().getSmeltingResult(input) != null) {
                    ItemStack toReturn = FurnaceRecipes.func_77602_a().getSmeltingResult(input).func_77946_l();
                    if (stackDecrease) {
                        --input.field_77994_a;
                    }
                    return toReturn;
                }
                return null;
            }
            if (this.usesFuel()) {
                return RecipeHandler.getOutput(new AdvancedInput(input, gas), stackDecrease, this.recipe.get());
            }
            return RecipeHandler.getOutput(input, stackDecrease, this.recipe.get());
        }

        public GasStack getItemGas(ItemStack itemstack) {
            if (this.usesFuel) {
                return this.getTile().getItemGas(itemstack);
            }
            return null;
        }

        public int getSecondaryEnergyPerTick() {
            if (this.usesFuel) {
                return this.getTile().SECONDARY_ENERGY_PER_TICK;
            }
            return 0;
        }

        public boolean canReceiveGas(ForgeDirection side, Gas type) {
            if (this.usesFuel) {
                return this.getTile().canReceiveGas(side, type);
            }
            return false;
        }

        public boolean canTubeConnect(ForgeDirection side) {
            if (this.usesFuel) {
                return this.getTile().canTubeConnect(side);
            }
            return false;
        }

        public boolean isValidGas(Gas gas) {
            if (this.usesFuel) {
                return this.getTile().isValidGas(gas);
            }
            return false;
        }

        public boolean hasRecipe(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            for (Map.Entry obj : this.recipe.get().entrySet()) {
                if (!(obj.getKey() instanceof AdvancedInput)) continue;
                Map.Entry entry = obj;
                ItemStack stack = ((AdvancedInput)entry.getKey()).itemStack;
                if (!StackUtils.equalsWildcard(stack, itemStack)) continue;
                return true;
            }
            return false;
        }

        public TileEntityAdvancedElectricMachine getTile() {
            if (this.cacheTile == null) {
                BlockMachine.MachineType type = BlockMachine.MachineType.get(this.getStack().field_77993_c, this.getStack().func_77960_j());
                this.cacheTile = (TileEntityAdvancedElectricMachine)type.create();
            }
            return this.cacheTile;
        }

        public int getMaxSecondaryEnergy() {
            return 200;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getName() {
            return MekanismUtils.localize("gui.factory." + this.name);
        }

        public String getSound() {
            return this.sound;
        }

        public boolean usesFuel() {
            return this.usesFuel;
        }

        private RecipeType(String s, String s1, ItemStack is, boolean b, RecipeHandler.Recipe r) {
            this.name = s;
            this.sound = s1;
            this.stack = is;
            this.usesFuel = b;
            this.recipe = r;
        }
    }
}

