/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.ClientProxy;
import mekanism.common.IActiveState;
import mekanism.common.IBoundingBlock;
import mekanism.common.IElectricChest;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISpecialBounds;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.IUpgradeManagement;
import mekanism.common.ItemAttacher;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.tile.TileEntityAdvancedFactory;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystalizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityElectricChest;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEliteFactory;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockMachine
extends BlockContainer
implements ISpecialBounds {
    public Icon[][] icons = new Icon[16][16];
    public Random machineRand = new Random();

    public BlockMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(3.5f);
        this.func_71894_b(8.0f);
        this.func_71849_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        if (this.field_71990_ca == Mekanism.machineBlockID) {
            this.icons[0][0] = register.func_94245_a("mekanism:EnrichmentChamberFrontOff");
            this.icons[0][1] = register.func_94245_a("mekanism:EnrichmentChamberFrontOn");
            this.icons[0][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[1][0] = register.func_94245_a("mekanism:OsmiumCompressorFrontOff");
            this.icons[1][1] = register.func_94245_a("mekanism:OsmiumCompressorFrontOn");
            this.icons[1][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[2][0] = register.func_94245_a("mekanism:CombinerFrontOff");
            this.icons[2][1] = register.func_94245_a("mekanism:CombinerFrontOn");
            this.icons[2][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[3][0] = register.func_94245_a("mekanism:CrusherFrontOff");
            this.icons[3][1] = register.func_94245_a("mekanism:CrusherFrontOn");
            this.icons[3][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[5][0] = register.func_94245_a("mekanism:BasicFactoryFront");
            this.icons[5][1] = register.func_94245_a("mekanism:BasicFactorySide");
            this.icons[5][2] = register.func_94245_a("mekanism:BasicFactoryTop");
            this.icons[6][0] = register.func_94245_a("mekanism:AdvancedFactoryFront");
            this.icons[6][1] = register.func_94245_a("mekanism:AdvancedFactorySide");
            this.icons[6][2] = register.func_94245_a("mekanism:AdvancedFactoryTop");
            this.icons[7][0] = register.func_94245_a("mekanism:EliteFactoryFront");
            this.icons[7][1] = register.func_94245_a("mekanism:EliteFactorySide");
            this.icons[7][2] = register.func_94245_a("mekanism:EliteFactoryTop");
            this.icons[9][0] = register.func_94245_a("mekanism:PurificationChamberFrontOff");
            this.icons[9][1] = register.func_94245_a("mekanism:PurificationChamberFrontOn");
            this.icons[9][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[10][0] = register.func_94245_a("mekanism:EnergizedSmelterFrontOff");
            this.icons[10][1] = register.func_94245_a("mekanism:EnergizedSmelterFrontOn");
            this.icons[10][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[11][0] = register.func_94245_a("mekanism:Teleporter");
        } else if (this.field_71990_ca == Mekanism.machineBlock2ID) {
            this.icons[2][0] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOff");
            this.icons[2][1] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOn");
            this.icons[2][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[3][0] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOff");
            this.icons[3][1] = register.func_94245_a("mekanism:ChemicalInjectionChamberFrontOn");
            this.icons[3][2] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[5][0] = register.func_94245_a("mekanism:PrecisionSawmillFrontOff");
            this.icons[5][1] = register.func_94245_a("mekanism:PrecisionSawmillFrontOn");
            this.icons[5][2] = register.func_94245_a("mekanism:SteelCasing");
        }
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityLogisticalSorter transporter;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        if (tileEntity instanceof TileEntityLogisticalSorter && !(transporter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = Coord4D.get(transporter).getFromSide(dir).getTileEntity((IBlockAccess)world);
                if (!(tile instanceof IInventory)) continue;
                change = dir.getOpposite().ordinal();
                break;
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_72864_z(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onPlace();
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int i1, int i2) {
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_72796_p(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onBreak();
        }
        super.func_71852_a(world, x, y, z, i1, i2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        if (MekanismUtils.isActive((IBlockAccess)world, x, y, z) && ((IActiveState)((Object)tileEntity)).renderUpdate() && Mekanism.machineEffects) {
            float xRandom = (float)x + 0.5f;
            float yRandom = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)z + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            int side = tileEntity.facing;
            if (tileEntity instanceof TileEntityMetallurgicInfuser) {
                side = ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            if (side == 4) {
                world.func_72869_a("smoke", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (side == 5) {
                world.func_72869_a("smoke", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (side == 2) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
            } else if (side == 3) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (Mekanism.machineEffects && tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (this.field_71990_ca == Mekanism.machineBlockID) {
            if (meta == 0) {
                if (side == 3) {
                    return this.icons[0][0];
                }
                return this.icons[0][2];
            }
            if (meta == 1) {
                if (side == 3) {
                    return this.icons[1][0];
                }
                return this.icons[1][2];
            }
            if (meta == 2) {
                if (side == 3) {
                    return this.icons[2][0];
                }
                return this.icons[2][2];
            }
            if (meta == 3) {
                if (side == 3) {
                    return this.icons[3][0];
                }
                return this.icons[3][2];
            }
            if (meta == 5) {
                if (side == 3) {
                    return this.icons[5][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[5][2];
                }
                return this.icons[5][1];
            }
            if (meta == 6) {
                if (side == 3) {
                    return this.icons[6][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[6][2];
                }
                return this.icons[6][1];
            }
            if (meta == 7) {
                if (side == 3) {
                    return this.icons[7][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[7][2];
                }
                return this.icons[7][1];
            }
            if (meta == 9) {
                if (side == 3) {
                    return this.icons[9][0];
                }
                return this.icons[9][2];
            }
            if (meta == 10) {
                if (side == 3) {
                    return this.icons[10][0];
                }
                return this.icons[10][2];
            }
            if (meta == 11) {
                return this.icons[11][0];
            }
        } else if (this.field_71990_ca == Mekanism.machineBlock2ID && (meta == 3 || meta == 5)) {
            if (side == 3) {
                return this.icons[meta][0];
            }
            return this.icons[meta][2];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        if (this.field_71990_ca == Mekanism.machineBlockID) {
            if (metadata == 0) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[0][1] : this.icons[0][0];
                }
                return this.icons[0][2];
            }
            if (metadata == 1) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[1][1] : this.icons[1][0];
                }
                return this.icons[1][2];
            }
            if (metadata == 2) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[2][1] : this.icons[2][0];
                }
                return this.icons[2][2];
            }
            if (metadata == 3) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[3][1] : this.icons[3][0];
                }
                return this.icons[3][2];
            }
            if (metadata == 5) {
                if (side == tileEntity.facing) {
                    return this.icons[5][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[5][2];
                }
                return this.icons[5][1];
            }
            if (metadata == 6) {
                if (side == tileEntity.facing) {
                    return this.icons[6][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[6][2];
                }
                return this.icons[6][1];
            }
            if (metadata == 7) {
                if (side == tileEntity.facing) {
                    return this.icons[7][0];
                }
                if (side == 0 || side == 1) {
                    return this.icons[7][2];
                }
                return this.icons[7][1];
            }
            if (metadata == 9) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[9][1] : this.icons[9][0];
                }
                return this.icons[9][2];
            }
            if (metadata == 10) {
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[10][1] : this.icons[10][0];
                }
                return this.icons[10][2];
            }
            if (metadata == 11) {
                return this.icons[11][0];
            }
        } else if (this.field_71990_ca == Mekanism.machineBlock2ID && (metadata == 3 || metadata == 5)) {
            if (side == tileEntity.facing) {
                return MekanismUtils.isActive(world, x, y, z) ? this.icons[metadata][1] : this.icons[metadata][0];
            }
            return this.icons[metadata][2];
        }
        return null;
    }

    public int func_71899_b(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs creativetabs, List list) {
        for (MachineType type : MachineType.values()) {
            if (type.typeId != this.field_71990_ca) continue;
            if (type == MachineType.BASIC_FACTORY || type == MachineType.ADVANCED_FACTORY || type == MachineType.ELITE_FACTORY) {
                for (IFactory.RecipeType recipe : IFactory.RecipeType.values()) {
                    ItemStack stack = new ItemStack(i, 1, type.meta);
                    ((IFactory)stack.func_77973_b()).setRecipeType(recipe.ordinal(), stack);
                    list.add(stack);
                }
                continue;
            }
            list.add(new ItemStack(i, 1, type.meta));
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float posX, float posY, float posZ) {
        Item tool;
        if (ItemAttacher.canAttach(entityplayer.func_71045_bC())) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null && (tool = entityplayer.func_71045_bC().func_77973_b()) instanceof IToolWrench && !tool.func_77658_a().contains("omniwrench") && ((IToolWrench)tool).canWrench(entityplayer, x, y, z)) {
            if (entityplayer.func_70093_af() && metadata != 13) {
                this.dismantleBlock(world, x, y, z, false);
                return true;
            }
            ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
            int change = 0;
            switch (tileEntity.facing) {
                case 3: {
                    change = 5;
                    break;
                }
                case 5: {
                    change = 2;
                    break;
                }
                case 2: {
                    change = 4;
                    break;
                }
                case 4: {
                    change = 3;
                }
            }
            if (tileEntity instanceof TileEntityLogisticalSorter && !((TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = Coord4D.get(tileEntity).getFromSide(dir).getTileEntity((IBlockAccess)world);
                    if (!(tileEntity instanceof IInventory)) continue;
                    change = dir.getOpposite().ordinal();
                    break;
                }
            }
            tileEntity.setFacing((short)change);
            world.func_72898_h(x, y, z, this.field_71990_ca);
            return true;
        }
        if (tileEntity != null) {
            if (metadata == MachineType.ELECTRIC_CHEST.meta) {
                TileEntityElectricChest electricChest = (TileEntityElectricChest)tileEntity;
                if (!entityplayer.func_70093_af()) {
                    if (electricChest.canAccess()) {
                        MekanismUtils.openElectricChestGui((EntityPlayerMP)entityplayer, electricChest, null, true);
                    } else if (!electricChest.authenticated) {
                        PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 2, 0, true, Coord4D.get(electricChest)}), entityplayer);
                    } else {
                        PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 1, 0, true, Coord4D.get(electricChest)}), entityplayer);
                    }
                    return true;
                }
            } else {
                if (metadata == MachineType.LOGISTICAL_SORTER.meta) {
                    TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tileEntity;
                    PacketLogisticalSorterGui.openServerGui(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, 0, world, (EntityPlayerMP)entityplayer, Coord4D.get(tileEntity), -1);
                    return true;
                }
                if (!entityplayer.func_70093_af() && MachineType.get((int)this.field_71990_ca, (int)metadata).guiId != -1) {
                    entityplayer.openGui((Object)Mekanism.instance, MachineType.get((int)this.field_71990_ca, (int)metadata).guiId, world, x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (MachineType.get(this.field_71990_ca, metadata) == null) {
            return null;
        }
        return MachineType.get(this.field_71990_ca, metadata).create();
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return ClientProxy.MACHINE_RENDER_ID;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != 13) {
            return this.field_71989_cb;
        }
        TileEntityElectricChest tileEntity = (TileEntityElectricChest)world.func_72796_p(x, y, z);
        return tileEntity.canAccess() ? 3.5f : -1.0f;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_94571_i(x, y, z);
    }

    public int func_71885_a(int i, Random random, int j) {
        return 0;
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        if (!world.field_72995_K) {
            TileEntityLogisticalSorter sorter;
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(id);
            }
            if (tileEntity instanceof TileEntityLogisticalSorter && !(sorter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = Coord4D.get(tileEntity).getFromSide(dir).getTileEntity((IBlockAccess)world);
                    if (!(tile instanceof IInventory)) continue;
                    sorter.setFacing((short)dir.getOpposite().ordinal());
                    return;
                }
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
        ItemStack itemStack = new ItemStack(this.field_71990_ca, 1, world.func_72805_g(x, y, z));
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (((IUpgradeManagement)itemStack.func_77973_b()).supportsUpgrades(itemStack)) {
            IUpgradeManagement upgrade = (IUpgradeManagement)itemStack.func_77973_b();
            upgrade.setEnergyMultiplier(((IUpgradeManagement)((Object)tileEntity)).getEnergyMultiplier(new Object[0]), itemStack);
            upgrade.setSpeedMultiplier(((IUpgradeManagement)((Object)tileEntity)).getSpeedMultiplier(new Object[0]), itemStack);
        }
        if (tileEntity instanceof IInvConfiguration) {
            IInvConfiguration config = (IInvConfiguration)((Object)tileEntity);
            itemStack.field_77990_d.func_74757_a("hasSideData", true);
            itemStack.field_77990_d.func_74757_a("ejecting", config.getEjector().isEjecting());
            for (int i = 0; i < 6; ++i) {
                itemStack.field_77990_d.func_74774_a("config" + i, config.getConfiguration()[i]);
            }
        }
        if (tileEntity instanceof TileEntityDigitalMiner) {
            TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tileEntity;
            itemStack.field_77990_d.func_74757_a("hasMinerConfig", true);
            itemStack.field_77990_d.func_74768_a("radius", miner.radius);
            itemStack.field_77990_d.func_74768_a("minY", miner.minY);
            itemStack.field_77990_d.func_74768_a("maxY", miner.maxY);
            itemStack.field_77990_d.func_74757_a("doEject", miner.doEject);
            itemStack.field_77990_d.func_74757_a("doPull", miner.doPull);
            itemStack.field_77990_d.func_74757_a("silkTouch", miner.silkTouch);
            if (miner.replaceStack != null) {
                itemStack.field_77990_d.func_74766_a("replaceStack", miner.replaceStack.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList filterTags = new NBTTagList();
            for (MinerFilter minerFilter : miner.filters) {
                filterTags.func_74742_a((NBTBase)minerFilter.write(new NBTTagCompound()));
            }
            if (filterTags.func_74745_c() != 0) {
                itemStack.field_77990_d.func_74782_a("filters", (NBTBase)filterTags);
            }
        }
        if (tileEntity instanceof TileEntityLogisticalSorter) {
            TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tileEntity;
            itemStack.field_77990_d.func_74757_a("hasSorterConfig", true);
            if (sorter.color != null) {
                itemStack.field_77990_d.func_74768_a("color", TransporterUtils.colors.indexOf((Object)sorter.color));
            }
            itemStack.field_77990_d.func_74757_a("autoEject", sorter.autoEject);
            itemStack.field_77990_d.func_74757_a("roundRobin", sorter.roundRobin);
            NBTTagList filterTags = new NBTTagList();
            for (TransporterFilter transporterFilter : sorter.filters) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                transporterFilter.write(tagCompound);
                filterTags.func_74742_a((NBTBase)tagCompound);
            }
            if (filterTags.func_74745_c() != 0) {
                itemStack.field_77990_d.func_74782_a("filters", (NBTBase)filterTags);
            }
        }
        if (tileEntity instanceof IRedstoneControl) {
            IRedstoneControl control = (IRedstoneControl)((Object)tileEntity);
            itemStack.field_77990_d.func_74768_a("controlType", control.getControlType().ordinal());
        }
        if (tileEntity instanceof TileEntityElectricBlock) {
            IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
            energizedItem.setEnergy(itemStack, ((TileEntityElectricBlock)tileEntity).electricityStored);
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).inventory.length > 0) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((ISustainedInventory)((Object)tileEntity)).getInventory(new Object[0]), itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(itemStack) && tileEntity instanceof ISustainedTank && ((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]), itemStack);
        }
        if (tileEntity instanceof TileEntityElectricChest) {
            IElectricChest electricChest = (IElectricChest)itemStack.func_77973_b();
            electricChest.setAuthenticated(itemStack, ((TileEntityElectricChest)tileEntity).authenticated);
            electricChest.setLocked(itemStack, ((TileEntityElectricChest)tileEntity).locked);
            electricChest.setPassword(itemStack, ((TileEntityElectricChest)tileEntity).password);
        }
        if (tileEntity instanceof TileEntityFactory) {
            IFactory factoryItem = (IFactory)itemStack.func_77973_b();
            factoryItem.setRecipeType(((TileEntityFactory)tileEntity).recipeType, itemStack);
        }
        if (tileEntity instanceof TileEntityRotaryCondensentrator) {
            TileEntityRotaryCondensentrator condensentrator = (TileEntityRotaryCondensentrator)tileEntity;
            if (condensentrator.gasTank.getGas() != null) {
                itemStack.field_77990_d.func_74766_a("gasStack", condensentrator.gasTank.getGas().write(new NBTTagCompound()));
            }
        }
        if (tileEntity instanceof TileEntityChemicalOxidizer) {
            TileEntityChemicalOxidizer formulator = (TileEntityChemicalOxidizer)tileEntity;
            if (formulator.gasTank.getGas() != null) {
                itemStack.field_77990_d.func_74766_a("gasTank", formulator.gasTank.getGas().write(new NBTTagCompound()));
            }
        }
        if (tileEntity instanceof TileEntityChemicalInfuser) {
            TileEntityChemicalInfuser infuser = (TileEntityChemicalInfuser)tileEntity;
            if (infuser.leftTank.getGas() != null) {
                itemStack.field_77990_d.func_74766_a("leftTank", infuser.leftTank.getGas().write(new NBTTagCompound()));
            }
            if (infuser.rightTank.getGas() != null) {
                itemStack.field_77990_d.func_74766_a("rightTank", infuser.rightTank.getGas().write(new NBTTagCompound()));
            }
            if (infuser.centerTank.getGas() != null) {
                itemStack.field_77990_d.func_74766_a("leftTank", infuser.centerTank.getGas().write(new NBTTagCompound()));
            }
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_94571_i(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == MachineType.CHARGEPAD.meta) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.06f, 1.0f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (world.func_72796_p(x, y, z) instanceof TileEntityChargepad) {
            return null;
        }
        return super.func_71872_e(world, x, y, z);
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata != MachineType.CHARGEPAD.meta;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K) {
            ((TileEntityElectricBlock)tileEntity).register();
        }
    }

    @Override
    public void setRenderBounds(Block block, int metadata) {
    }

    @Override
    public boolean doDefaultBoundSetting(int metadata) {
        return false;
    }

    public static enum MachineType {
        ENRICHMENT_CHAMBER(Mekanism.machineBlockID, 0, "EnrichmentChamber", 3, Mekanism.enrichmentChamberUsage * 400.0, TileEntityEnrichmentChamber.class, false, true),
        OSMIUM_COMPRESSOR(Mekanism.machineBlockID, 1, "OsmiumCompressor", 4, Mekanism.osmiumCompressorUsage * 400.0, TileEntityOsmiumCompressor.class, false, true),
        COMBINER(Mekanism.machineBlockID, 2, "Combiner", 5, Mekanism.combinerUsage * 400.0, TileEntityCombiner.class, false, true),
        CRUSHER(Mekanism.machineBlockID, 3, "Crusher", 6, Mekanism.crusherUsage * 400.0, TileEntityCrusher.class, false, true),
        DIGITAL_MINER(Mekanism.machineBlockID, 4, "DigitalMiner", 2, 100000.0, TileEntityDigitalMiner.class, true, true),
        BASIC_FACTORY(Mekanism.machineBlockID, 5, "BasicFactory", 11, Mekanism.factoryUsage * 3.0 * 400.0, TileEntityFactory.class, false, true),
        ADVANCED_FACTORY(Mekanism.machineBlockID, 6, "AdvancedFactory", 11, Mekanism.factoryUsage * 5.0 * 400.0, TileEntityAdvancedFactory.class, false, true),
        ELITE_FACTORY(Mekanism.machineBlockID, 7, "EliteFactory", 11, Mekanism.factoryUsage * 7.0 * 400.0, TileEntityEliteFactory.class, false, true),
        METALLURGIC_INFUSER(Mekanism.machineBlockID, 8, "MetallurgicInfuser", 12, Mekanism.metallurgicInfuserUsage * 400.0, TileEntityMetallurgicInfuser.class, true, true),
        PURIFICATION_CHAMBER(Mekanism.machineBlockID, 9, "PurificationChamber", 15, Mekanism.purificationChamberUsage * 400.0, TileEntityPurificationChamber.class, false, true),
        ENERGIZED_SMELTER(Mekanism.machineBlockID, 10, "EnergizedSmelter", 16, Mekanism.energizedSmelterUsage * 400.0, TileEntityEnergizedSmelter.class, false, true),
        TELEPORTER(Mekanism.machineBlockID, 11, "Teleporter", 13, 5000000.0, TileEntityTeleporter.class, false, false),
        ELECTRIC_PUMP(Mekanism.machineBlockID, 12, "ElectricPump", 17, 10000.0, TileEntityElectricPump.class, true, false),
        ELECTRIC_CHEST(Mekanism.machineBlockID, 13, "ElectricChest", -1, 12000.0, TileEntityElectricChest.class, true, false),
        CHARGEPAD(Mekanism.machineBlockID, 14, "Chargepad", -1, 10000.0, TileEntityChargepad.class, true, false),
        LOGISTICAL_SORTER(Mekanism.machineBlockID, 15, "LogisticalSorter", -1, 0.0, TileEntityLogisticalSorter.class, true, false),
        ROTARY_CONDENSENTRATOR(Mekanism.machineBlock2ID, 0, "RotaryCondensentrator", 7, 20000.0, TileEntityRotaryCondensentrator.class, true, false),
        CHEMICAL_OXIDIZER(Mekanism.machineBlock2ID, 1, "ChemicalOxidizer", 29, 20000.0, TileEntityChemicalOxidizer.class, true, false),
        CHEMICAL_INFUSER(Mekanism.machineBlock2ID, 2, "ChemicalInfuser", 30, 20000.0, TileEntityChemicalInfuser.class, true, false),
        CHEMICAL_INJECTION_CHAMBER(Mekanism.machineBlock2ID, 3, "ChemicalInjectionChamber", 31, Mekanism.chemicalInjectionChamberUsage * 400.0, TileEntityChemicalInjectionChamber.class, false, true),
        ELECTROLYTIC_SEPARATOR(Mekanism.machineBlock2ID, 4, "ElectrolyticSeparator", 32, 20000.0, TileEntityElectrolyticSeparator.class, true, false),
        PRECISION_SAWMILL(Mekanism.machineBlock2ID, 5, "PrecisionSawmill", 34, Mekanism.precisionSawmillUsage * 400.0, TileEntityPrecisionSawmill.class, false, true),
        CHEMICAL_DISSOLUTION_CHAMBER(Mekanism.machineBlock2ID, 6, "ChemicalDissolutionChamber", 35, 20000.0, TileEntityChemicalDissolutionChamber.class, true, false),
        CHEMICAL_WASHER(Mekanism.machineBlock2ID, 7, "ChemicalWasher", 36, 20000.0, TileEntityChemicalWasher.class, true, false),
        CHEMICAL_CRYSTALIZER(Mekanism.machineBlock2ID, 8, "ChemicalCrystalizer", 37, 20000.0, TileEntityChemicalCrystalizer.class, true, false);

        public int typeId;
        public int meta;
        public String name;
        public int guiId;
        public double baseEnergy;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean hasModel;
        public boolean supportsUpgrades;

        private MachineType(int id, int i, String s, int j, double k, Class<? extends TileEntity> tileClass, boolean model, boolean upgrades) {
            this.typeId = id;
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.baseEnergy = k;
            this.tileEntityClass = tileClass;
            this.hasModel = model;
            this.supportsUpgrades = upgrades;
        }

        public static MachineType get(int id, int meta) {
            for (MachineType type : MachineType.values()) {
                if (type.meta != meta || type.typeId != id) continue;
                return type;
            }
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String getDescription() {
            return MekanismUtils.localize("tooltip." + this.name);
        }

        public ItemStack getStack() {
            return new ItemStack(this.typeId, 1, this.meta);
        }

        public static MachineType get(ItemStack stack) {
            return MachineType.get(stack.field_77993_c, stack.func_77960_j());
        }

        public String toString() {
            return Integer.toString(this.meta);
        }
    }
}

