/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.ISustainedInventory;
import mekanism.common.Mekanism;
import mekanism.common.RobitAIFollow;
import mekanism.common.RobitAIPickup;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemRobit;
import mekanism.common.tile.TileEntityChargepad;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityRobit
extends EntityCreature
implements IInventory,
ISustainedInventory,
IEntityBreathable {
    public double MAX_ELECTRICITY = 100000.0;
    public Coord4D homeLocation;
    public ItemStack[] inventory = new ItemStack[31];
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    public boolean texTick;

    public EntityRobit(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RobitAIPickup(this, 1.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new RobitAIFollow(this, 1.0f, 4.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.func_94061_f(true);
    }

    public EntityRobit(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70629_bd() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)new String(""));
        this.field_70180_af.func_75682_a(13, (Object)new String(""));
        this.field_70180_af.func_75682_a(14, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(15, (Object)new String(""));
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    public double getRoundedTravelEnergy() {
        return new BigDecimal(this.func_70011_f(this.field_70169_q, this.field_70167_r, this.field_70166_s) * 1.5).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.getFollowing() && this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) > 4.0 && !this.func_70661_as().func_75500_f() && this.getEnergy() > 0.0) {
            this.setEnergy(this.getEnergy() - this.getRoundedTravelEnergy());
        }
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getDropPickup()) {
                this.collectItems();
            }
            if (this.homeLocation == null) {
                this.func_70106_y();
                return;
            }
            if (!(this.homeLocation.getTileEntity((IBlockAccess)MinecraftServer.func_71276_C().func_71218_a(this.homeLocation.dimensionId)) instanceof TileEntityChargepad)) {
                this.drop();
                this.func_70106_y();
                return;
            }
            if (this.getEnergy() == 0.0 && !this.isOnChargepad()) {
                this.goHome();
            }
            if (this.inventory[27] != null && this.getEnergy() < this.MAX_ELECTRICITY) {
                if (this.inventory[27].func_77973_b() instanceof IEnergizedItem) {
                    this.setEnergy(this.getEnergy() + EnergizedItemManager.discharge(this.inventory[27], this.MAX_ELECTRICITY - this.getEnergy()));
                } else if (Mekanism.hooks.IC2Loaded && this.inventory[27].func_77973_b() instanceof IElectricItem) {
                    IElectricItem item = (IElectricItem)this.inventory[27].func_77973_b();
                    if (item.canProvideEnergy(this.inventory[27])) {
                        double gain = (double)ElectricItem.manager.discharge(this.inventory[27], (int)((this.MAX_ELECTRICITY - this.getEnergy()) * Mekanism.TO_IC2), 4, true, false) * Mekanism.FROM_IC2;
                        this.setEnergy(this.getEnergy() + gain);
                    }
                } else if (this.inventory[27].func_77973_b() instanceof IEnergyContainerItem) {
                    ItemStack itemStack = this.inventory[27];
                    IEnergyContainerItem item = (IEnergyContainerItem)this.inventory[27].func_77973_b();
                    int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)item.getEnergyStored(itemStack)));
                    int toTransfer = (int)Math.round(Math.min((double)itemEnergy, (this.MAX_ELECTRICITY - this.getEnergy()) * Mekanism.TO_TE));
                    this.setEnergy(this.getEnergy() + (double)item.extractEnergy(itemStack, toTransfer, false) * Mekanism.FROM_TE);
                } else if (this.inventory[27].field_77993_c == Item.field_77767_aC.field_77779_bT && this.getEnergy() + Mekanism.ENERGY_PER_REDSTONE <= this.MAX_ELECTRICITY) {
                    this.setEnergy(this.getEnergy() + Mekanism.ENERGY_PER_REDSTONE);
                    --this.inventory[27].field_77994_a;
                    if (this.inventory[27].field_77994_a <= 0) {
                        this.inventory[27] = null;
                    }
                }
            }
            if (this.furnaceBurnTime > 0) {
                --this.furnaceBurnTime;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_70398_a((ItemStack)this.inventory[29]);
                    if (this.furnaceBurnTime > 0 && this.inventory[29] != null) {
                        --this.inventory[29].field_77994_a;
                        if (this.inventory[29].field_77994_a == 0) {
                            this.inventory[29] = this.inventory[29].func_77973_b().getContainerItemStack(this.inventory[29]);
                        }
                    }
                }
                if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
        }
    }

    private void collectItems() {
        List items = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.5, 1.5, 1.5));
        if (items != null && !items.isEmpty()) {
            block0: for (EntityItem item : items) {
                if (item.field_70293_c > 0 || item.func_92059_d().func_77973_b() instanceof ItemRobit) continue;
                for (int i = 0; i < 27; ++i) {
                    ItemStack itemStack = this.inventory[i];
                    if (itemStack == null) {
                        this.inventory[i] = item.func_92059_d();
                        this.func_71001_a((Entity)item, item.func_92059_d().field_77994_a);
                        item.func_70106_y();
                        this.func_85030_a("random.pop", 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        continue block0;
                    }
                    if (!itemStack.func_77969_a(item.func_92059_d()) || itemStack.field_77994_a >= itemStack.func_77976_d()) continue;
                    int needed = itemStack.func_77976_d() - itemStack.field_77994_a;
                    int toAdd = Math.min(needed, item.func_92059_d().field_77994_a);
                    itemStack.field_77994_a += toAdd;
                    item.func_92059_d().field_77994_a -= toAdd;
                    this.func_71001_a((Entity)item, toAdd);
                    if (item.func_92059_d().field_77994_a == 0) {
                        item.func_70106_y();
                    }
                    this.func_85030_a("random.pop", 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue block0;
                }
            }
        }
    }

    public void goHome() {
        this.setFollowing(false);
        if (this.field_70170_p.field_73011_w.field_76574_g != this.homeLocation.dimensionId) {
            this.func_71027_c(this.homeLocation.dimensionId);
        }
        this.func_70634_a((double)this.homeLocation.xCoord + 0.5, (double)this.homeLocation.yCoord + 0.3, (double)this.homeLocation.zCoord + 0.5);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    private boolean canSmelt() {
        if (this.inventory[28] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().getSmeltingResult(this.inventory[28]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[30] == null) {
            return true;
        }
        if (!this.inventory[30].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventory[30].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().getSmeltingResult(this.inventory[28]);
            if (this.inventory[30] == null) {
                this.inventory[30] = itemstack.func_77946_l();
            } else if (this.inventory[30].func_77969_a(itemstack)) {
                this.inventory[30].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[28].field_77994_a;
            if (this.inventory[28].field_77994_a <= 0) {
                this.inventory[28] = null;
            }
        }
    }

    public boolean isOnChargepad() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        return this.field_70170_p.func_72796_p(x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v)) instanceof TileEntityChargepad;
    }

    public boolean func_70085_c(EntityPlayer entityplayer) {
        if (entityplayer.func_70093_af()) {
            ItemStack itemStack = entityplayer.func_71045_bC();
            if (itemStack != null && itemStack.func_77973_b() instanceof ItemConfigurator) {
                if (!this.field_70170_p.field_72995_K) {
                    this.drop();
                }
                this.func_70106_y();
                entityplayer.func_71038_i();
                return true;
            }
        } else {
            entityplayer.openGui((Object)Mekanism.instance, 21, this.field_70170_p, this.field_70157_k, 0, 0);
        }
        return false;
    }

    public void drop() {
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, new ItemStack((Item)Mekanism.Robit));
        ItemRobit item = (ItemRobit)entityItem.func_92059_d().func_77973_b();
        item.setEnergy(entityItem.func_92059_d(), this.getEnergy());
        item.setInventory(this.getInventory(new Object[0]), entityItem.func_92059_d());
        item.setName(entityItem.func_92059_d(), this.func_96090_ax());
        float k = 0.05f;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = this.field_70146_Z.nextGaussian() * (double)k + (double)0.2f;
        entityItem.field_70179_y = 0.0;
        this.field_70170_p.func_72838_d((Entity)entityItem);
    }

    public void func_70014_b(NBTTagCompound nbtTags) {
        super.func_70014_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
        nbtTags.func_74778_a("name", this.getName());
        if (this.getOwnerName() != null) {
            nbtTags.func_74778_a("owner", this.getOwnerName());
        }
        nbtTags.func_74757_a("follow", this.getFollowing());
        nbtTags.func_74757_a("dropPickup", this.getDropPickup());
        this.homeLocation.write(nbtTags);
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < this.inventory.length; ++slotCount) {
            if (this.inventory[slotCount] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            this.inventory[slotCount].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
    }

    public void func_70037_a(NBTTagCompound nbtTags) {
        super.func_70037_a(nbtTags);
        this.setEnergy(nbtTags.func_74769_h("electricityStored"));
        this.setName(nbtTags.func_74779_i("name"));
        if (nbtTags.func_74764_b("owner")) {
            this.setOwner(nbtTags.func_74779_i("owner"));
        }
        this.setFollowing(nbtTags.func_74767_n("follow"));
        this.setDropPickup(nbtTags.func_74767_n("dropPickup"));
        this.homeLocation = Coord4D.read(nbtTags);
        NBTTagList tagList = nbtTags.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = (NBTTagCompound)tagList.func_74743_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    protected void func_70665_d(DamageSource damageSource, float amount) {
        if ((amount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSource, (float)amount)) <= 0.0f) {
            return;
        }
        amount = this.func_70655_b(damageSource, amount);
        amount = this.func_70672_c(damageSource, amount);
        float j = this.func_110143_aJ();
        this.setEnergy(Math.max(0.0, this.getEnergy() - (double)(amount * 1000.0f)));
        this.func_110142_aN().func_94547_a(damageSource, j, amount);
    }

    protected void func_70609_aI() {
    }

    public void setHome(Coord4D home) {
        this.homeLocation = home;
    }

    public boolean func_70104_M() {
        return this.getEnergy() > 0.0;
    }

    public double getEnergy() {
        return Double.parseDouble(this.field_70180_af.func_75681_e(12));
    }

    public void setEnergy(double energy) {
        this.field_70180_af.func_75692_b(12, (Object)Double.toString(Math.max(Math.min(energy, this.MAX_ELECTRICITY), 0.0)));
    }

    public EntityPlayer getOwner() {
        return this.field_70170_p.func_72924_a(this.getOwnerName());
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(13);
    }

    public void setOwner(String username) {
        this.field_70180_af.func_75692_b(13, (Object)username);
    }

    public boolean getFollowing() {
        return this.field_70180_af.func_75683_a(14) == 1;
    }

    public void setFollowing(boolean follow) {
        this.field_70180_af.func_75692_b(14, (Object)(follow ? (byte)1 : 0));
    }

    public String getName() {
        return this.field_70180_af.func_75681_e(15);
    }

    public void setName(String name) {
        this.field_70180_af.func_75692_b(15, (Object)name);
    }

    public boolean getDropPickup() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public void setDropPickup(boolean pickup) {
        this.field_70180_af.func_75692_b(16, (Object)(pickup ? (byte)1 : 0));
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotID) {
        return this.inventory[slotID];
    }

    public ItemStack func_70298_a(int slotID, int amount) {
        if (this.func_70301_a(slotID) != null) {
            if (this.func_70301_a((int)slotID).field_77994_a <= amount) {
                ItemStack tempStack = this.func_70301_a(slotID);
                this.func_70299_a(slotID, null);
                return tempStack;
            }
            ItemStack tempStack = this.func_70301_a(slotID).func_77979_a(amount);
            if (this.func_70301_a((int)slotID).field_77994_a == 0) {
                this.func_70299_a(slotID, null);
            }
            return tempStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotID) {
        if (this.func_70301_a(slotID) != null) {
            ItemStack tempStack = this.func_70301_a(slotID);
            this.func_70299_a(slotID, null);
            return tempStack;
        }
        return null;
    }

    public void func_70299_a(int slotID, ItemStack itemstack) {
        this.inventory[slotID] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Robit";
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (nbtTags == null || nbtTags.func_74745_c() == 0) {
            return;
        }
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int slots = 0; slots < nbtTags.func_74745_c(); ++slots) {
            NBTTagCompound tagCompound = (NBTTagCompound)nbtTags.func_74743_b(slots);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        NBTTagList tagList = new NBTTagList();
        for (int slots = 0; slots < this.inventory.length; ++slots) {
            if (this.inventory[slots] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slots);
            this.inventory[slots].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        return tagList;
    }

    public String func_96090_ax() {
        return this.getName().isEmpty() ? "Robit" : this.getName();
    }

    public float func_70053_R() {
        return 0.25f;
    }

    @Override
    public boolean canBreath() {
        return true;
    }
}

