/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.util.List;
import java.util.Map;
import mekanism.common.Mekanism;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class MekanismHooks {
    private Class BasicComponents;
    private Class BuildCraftEnergy;
    public boolean IC2Loaded = false;
    public boolean RailcraftLoaded = false;
    public boolean BasicComponentsLoaded = false;
    public boolean BuildCraftLoaded = false;
    public boolean TELoaded = false;
    public boolean MetallurgyCoreLoaded = false;
    public boolean MetallurgyBaseLoaded = false;

    public void hook() {
        if (Loader.isModLoaded((String)"IC2")) {
            this.IC2Loaded = true;
        }
        if (Loader.isModLoaded((String)"Railcraft")) {
            this.RailcraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"BasicComponents")) {
            this.BasicComponentsLoaded = true;
        }
        if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
            this.BuildCraftLoaded = true;
        }
        if (Loader.isModLoaded((String)"ThermalExpansion")) {
            this.TELoaded = true;
        }
        if (Loader.isModLoaded((String)"Metallurgy3Core")) {
            this.MetallurgyCoreLoaded = true;
            if (Loader.isModLoaded((String)"Metallurgy3Base")) {
                this.MetallurgyBaseLoaded = true;
            }
        }
        if (this.IC2Loaded) {
            block6: for (Map.Entry<IRecipeInput, RecipeOutput> entry : Recipes.macerator.getRecipes().entrySet()) {
                if (entry.getKey().getInputs().isEmpty()) continue;
                List<String> names = MekanismUtils.getOreDictName(entry.getKey().getInputs().get(0));
                for (String name : names) {
                    boolean did = false;
                    if (name.startsWith("ingot")) {
                        RecipeHandler.addCrusherRecipe(entry.getKey().getInputs().get(0), entry.getValue().items.get(0));
                        did = true;
                    }
                    if (!did) continue;
                    continue block6;
                }
            }
            try {
                Recipes.macerator.addRecipe(new RecipeInputOreDict("oreOsmium"), null, new ItemStack(Mekanism.Dust, 2, 2));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Recipes.macerator.addRecipe(new RecipeInputOreDict("ingotOsmium"), null, new ItemStack(Mekanism.Dust, 1, 2));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("ingotRefinedObsidian"), null, new ItemStack(Mekanism.Dust, 1, 3));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("ingotRefinedGlowstone"), null, new ItemStack(Item.field_77751_aT));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("ingotSteel"), null, new ItemStack(Mekanism.Dust, 1, 5));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpIron"), null, new ItemStack(Mekanism.DirtyDust, 1, 0));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpGold"), null, new ItemStack(Mekanism.DirtyDust, 1, 1));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpOsmium"), null, new ItemStack(Mekanism.DirtyDust, 1, 2));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpCopper"), null, new ItemStack(Mekanism.DirtyDust, 1, 3));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpTin"), null, new ItemStack(Mekanism.DirtyDust, 1, 4));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpSilver"), null, new ItemStack(Mekanism.DirtyDust, 1, 5));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpObsidian"), null, new ItemStack(Mekanism.DirtyDust, 1, 6));
                Recipes.macerator.addRecipe(new RecipeInputOreDict("clumpLead"), null, new ItemStack(Mekanism.DirtyDust, 1, 7));
            }
            catch (Exception e) {
                // empty catch block
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("amplification", 50000);
            Recipes.matterAmplifier.addRecipe(new RecipeInputItemStack(new ItemStack(Mekanism.EnrichedAlloy), 1), tag, new ItemStack[0]);
            System.out.println("[Mekanism] Hooked into IC2 successfully.");
        }
        if (this.BasicComponentsLoaded) {
            if (Mekanism.disableBCSteelCrafting) {
                MekanismUtils.removeRecipes(this.getBasicComponentsItem("itemSteelDust"));
                MekanismUtils.removeRecipes(this.getBasicComponentsItem("itemSteelIngot"));
            }
            if (Mekanism.disableBCBronzeCrafting) {
                MekanismUtils.removeRecipes(this.getBasicComponentsItem("itemBronzeDust"));
                MekanismUtils.removeRecipes(this.getBasicComponentsItem("itemBronzeIngot"));
            }
            System.out.println("[Mekanism] Hooked into BasicComponents successfully.");
        }
        if (this.BuildCraftLoaded) {
            System.out.println("[Mekanism] Hooked into BuildCraft successfully.");
        }
    }

    public void addPulverizerRecipe(ItemStack input, ItemStack output, int energy) {
        NBTTagCompound nbtTags = new NBTTagCompound();
        nbtTags.func_74768_a("energy", energy);
        nbtTags.func_74766_a("input", input.func_77955_b(new NBTTagCompound()));
        nbtTags.func_74766_a("primaryOutput", output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"PulverizerRecipe", (NBTTagCompound)nbtTags);
    }

    public ItemStack getBuildCraftItem(String name) {
        try {
            Object ret;
            if (this.BuildCraftEnergy == null) {
                this.BuildCraftEnergy = Class.forName("buildcraft.BuildCraftEnergy");
            }
            if (this.BuildCraftEnergy == null) {
                this.BuildCraftEnergy = Class.forName("net.minecraft.src.buildcraft.BuildCraftEnergy");
            }
            if ((ret = this.BuildCraftEnergy.getField(name).get(null)) instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            throw new Exception("not instanceof ItemStack");
        }
        catch (Exception e) {
            System.out.println("[Mekanism] Unable to retrieve BuildCraft item " + name + ".");
            return null;
        }
    }

    public ItemStack getBasicComponentsItem(String name) {
        try {
            Object ret;
            if (this.BasicComponents == null) {
                this.BasicComponents = Class.forName("basiccomponents.common.BasicComponents");
            }
            if (this.BasicComponents == null) {
                this.BasicComponents = Class.forName("net.minecraft.src.basiccomponents.common.BasicComponents");
            }
            if ((ret = this.BasicComponents.getField(name).get(null)) instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            throw new Exception("not instanceof ItemStack");
        }
        catch (Exception e) {
            System.out.println("[Mekanism] Unable to retrieve Basic Components item " + name + ".");
            return null;
        }
    }
}

