/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import mekanism.common.IFactory;
import mekanism.common.Tier;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.slot.SlotEnergy;
import mekanism.common.inventory.slot.SlotMachineUpgrade;
import mekanism.common.inventory.slot.SlotOutput;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemMachineUpgrade;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.ChargeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerFactory
extends Container {
    private TileEntityFactory tileEntity;

    public ContainerFactory(InventoryPlayer inventory, TileEntityFactory tentity) {
        int slotX;
        int xAxis;
        int i;
        this.tileEntity = tentity;
        this.func_75146_a(new SlotMachineUpgrade((IInventory)tentity, 0, 180, 11));
        this.func_75146_a(new SlotEnergy.SlotDischarge((IInventory)tentity, 1, 7, 13));
        this.func_75146_a(new Slot((IInventory)tentity, 2, 180, 75));
        this.func_75146_a(new Slot((IInventory)tentity, 3, 180, 112));
        this.func_75146_a(new Slot((IInventory)tentity, 4, 7, 57));
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 55 + i * 38;
                this.func_75146_a(new Slot((IInventory)tentity, 5 + i, xAxis, 13));
            }
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 55 + i * 38;
                this.func_75146_a(new SlotOutput((IInventory)tentity, this.tileEntity.tier.processes + 5 + i, xAxis, 57));
            }
        } else if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 35 + i * 26;
                this.func_75146_a(new Slot((IInventory)tentity, 5 + i, xAxis, 13));
            }
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 35 + i * 26;
                this.func_75146_a(new SlotOutput((IInventory)tentity, this.tileEntity.tier.processes + 5 + i, xAxis, 57));
            }
        } else if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 29 + i * 19;
                this.func_75146_a(new Slot((IInventory)tentity, 5 + i, xAxis, 13));
            }
            for (i = 0; i < this.tileEntity.tier.processes; ++i) {
                xAxis = 29 + i * 19;
                this.func_75146_a(new SlotOutput((IInventory)tentity, this.tileEntity.tier.processes + 5 + i, xAxis, 57));
            }
        }
        for (slotX = 0; slotX < 3; ++slotX) {
            for (int slotY = 0; slotY < 9; ++slotY) {
                this.func_75146_a(new Slot((IInventory)inventory, slotY + slotX * 9 + 9, 8 + slotY * 18, 95 + slotX * 18));
            }
        }
        for (slotX = 0; slotX < 9; ++slotX) {
            this.func_75146_a(new Slot((IInventory)inventory, slotX, 8 + slotX * 18, 153));
        }
        this.tileEntity.open(inventory.field_70458_d);
        this.tileEntity.func_70295_k_();
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        super.func_75134_a(entityplayer);
        this.tileEntity.close(entityplayer);
        this.tileEntity.func_70305_f();
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.tileEntity.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot != null && currentSlot.func_75216_d()) {
            int slotEnd;
            ItemStack slotStack = currentSlot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (this.isOutputSlot(slotID) ? !this.func_75135_a(slotStack, this.tileEntity.inventory.length, this.field_75151_b.size(), true) : (slotID != 2 && slotID != 3 && this.isProperMachine(slotStack) && !slotStack.func_77969_a(this.tileEntity.getMachineStack()) ? !this.func_75135_a(slotStack, 2, 3, false) : (slotID == 3 ? !this.func_75135_a(slotStack, this.tileEntity.inventory.length, this.field_75151_b.size(), true) : (IFactory.RecipeType.values()[this.tileEntity.recipeType].getCopiedOutput(slotStack, this.tileEntity.gasTank.getGas() != null ? this.tileEntity.gasTank.getGas().getGas() : null, false) != null ? (!this.isInputSlot(slotID) ? !this.func_75135_a(slotStack, 5, 5 + this.tileEntity.tier.processes, false) : !this.func_75135_a(slotStack, this.tileEntity.inventory.length, this.field_75151_b.size(), true)) : (ChargeUtils.canBeDischarged(slotStack) ? (slotID != 1 ? !this.func_75135_a(slotStack, 1, 2, false) : slotID == 1 && !this.func_75135_a(slotStack, this.tileEntity.inventory.length, this.field_75151_b.size(), true)) : (IFactory.RecipeType.values()[this.tileEntity.recipeType].getItemGas(slotStack) != null ? (slotID > this.tileEntity.inventory.length - 1 ? !this.func_75135_a(slotStack, 4, 5, false) : !this.func_75135_a(slotStack, this.tileEntity.inventory.length, this.field_75151_b.size(), true)) : (slotStack.func_77973_b() instanceof ItemMachineUpgrade ? (slotID != 0 ? !this.func_75135_a(slotStack, 0, 1, false) : !this.func_75135_a(slotStack, this.tileEntity.inventory.length, this.field_75151_b.size(), true)) : (slotID >= (slotEnd = this.tileEntity.inventory.length) && slotID <= slotEnd + 26 ? !this.func_75135_a(slotStack, slotEnd + 27, this.field_75151_b.size(), false) : (slotID > slotEnd + 26 ? !this.func_75135_a(slotStack, slotEnd, slotEnd + 26, false) : !this.func_75135_a(slotStack, slotEnd, this.field_75151_b.size(), true)))))))))) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                currentSlot.func_75215_d((ItemStack)null);
            } else {
                currentSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == stack.field_77994_a) {
                return null;
            }
            currentSlot.func_82870_a(player, slotStack);
        }
        return stack;
    }

    public boolean isProperMachine(ItemStack itemStack) {
        BlockMachine.MachineType type;
        return itemStack != null && itemStack.func_77973_b() instanceof ItemBlockMachine && ((type = BlockMachine.MachineType.get(itemStack)) == BlockMachine.MachineType.ENERGIZED_SMELTER || type == BlockMachine.MachineType.ENRICHMENT_CHAMBER || type == BlockMachine.MachineType.CRUSHER || type == BlockMachine.MachineType.OSMIUM_COMPRESSOR || type == BlockMachine.MachineType.COMBINER || type == BlockMachine.MachineType.PURIFICATION_CHAMBER);
    }

    public boolean isInputSlot(int slot) {
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            return slot >= 5 && slot <= 7;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            return slot >= 5 && slot <= 9;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            return slot >= 5 && slot <= 11;
        }
        return false;
    }

    public boolean isOutputSlot(int slot) {
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            return slot >= 8 && slot <= 10;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            return slot >= 10 && slot <= 14;
        }
        if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            return slot >= 12 && slot <= 18;
        }
        return false;
    }
}

