/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.GasStack;
import mekanism.common.IElectricChest;
import mekanism.common.IFactory;
import mekanism.common.IInvConfiguration;
import mekanism.common.IRedstoneControl;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.IUpgradeManagement;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.inventory.InventoryElectricChest;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.PacketElectricChest;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.tile.TileEntityElectricChest;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class ItemBlockMachine
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
IUpgradeManagement,
IFactory,
ISustainedInventory,
ISustainedTank,
IElectricChest,
IEnergyContainerItem {
    public Block metaBlock;

    public ItemBlockMachine(int id, Block block) {
        super(id);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockMachine.MachineType.get(itemstack) != null) {
            return this.func_77658_a() + "." + BlockMachine.MachineType.get((ItemStack)itemstack).name;
        }
        return "null";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockMachine.MachineType type = BlockMachine.MachineType.get(itemstack);
        if (!Keyboard.isKeyDown((int)42)) {
            list.add("Hold " + (Object)((Object)EnumColor.AQUA) + (Object)((Object)EnumColor.INDIGO) + "shift" + (Object)((Object)EnumColor.GREY) + " for more details.");
            list.add("Hold " + (Object)((Object)EnumColor.AQUA) + "shift" + (Object)((Object)EnumColor.GREY) + " and " + (Object)((Object)EnumColor.AQUA) + "M" + (Object)((Object)EnumColor.GREY) + " for a description.");
        } else if (!Keyboard.isKeyDown((int)50)) {
            if (type == BlockMachine.MachineType.BASIC_FACTORY || type == BlockMachine.MachineType.ADVANCED_FACTORY || type == BlockMachine.MachineType.ELITE_FACTORY) {
                list.add((Object)((Object)EnumColor.INDIGO) + "Recipe Type: " + (Object)((Object)EnumColor.GREY) + IFactory.RecipeType.values()[this.getRecipeType(itemstack)].getName());
            }
            if (type == BlockMachine.MachineType.ELECTRIC_CHEST) {
                list.add((Object)((Object)EnumColor.INDIGO) + "Authenticated: " + (Object)((Object)EnumColor.GREY) + this.getAuthenticated(itemstack));
                list.add((Object)((Object)EnumColor.INDIGO) + "Locked: " + (Object)((Object)EnumColor.GREY) + this.getLocked(itemstack));
            }
            if (type != BlockMachine.MachineType.LOGISTICAL_SORTER) {
                list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + "Stored Energy: " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergyStored(itemstack)));
            }
            if (this.hasTank(itemstack) && this.getFluidStack(itemstack) != null) {
                list.add((Object)((Object)EnumColor.PINK) + FluidRegistry.getFluidName((FluidStack)this.getFluidStack(itemstack)) + ": " + (Object)((Object)EnumColor.GREY) + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            if (this.supportsUpgrades(itemstack)) {
                list.add((Object)((Object)EnumColor.PURPLE) + "Energy: " + (Object)((Object)EnumColor.GREY) + "x" + (this.getEnergyMultiplier(itemstack) + 1));
                list.add((Object)((Object)EnumColor.PURPLE) + "Speed: " + (Object)((Object)EnumColor.GREY) + "x" + (this.getSpeedMultiplier(itemstack) + 1));
            }
            if (type != BlockMachine.MachineType.CHARGEPAD && type != BlockMachine.MachineType.LOGISTICAL_SORTER) {
                list.add((Object)((Object)EnumColor.AQUA) + "Inventory: " + (Object)((Object)EnumColor.GREY) + (this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
            }
        } else {
            list.addAll(MekanismUtils.splitLines(type.getDescription()));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = true;
        if (BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.DIGITAL_MINER) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = y; yPos <= y + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block b = Block.field_71973_m[world.func_72798_a(xPos, yPos, zPos)];
                        if (yPos > 255) {
                            place = false;
                        }
                        if (b == null || b.field_71990_ca == 0 || b.isBlockReplaceable(world, xPos, yPos, zPos)) continue;
                        return false;
                    }
                }
            }
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_72796_p(x, y, z);
            if (tileEntity instanceof IUpgradeManagement) {
                ((IUpgradeManagement)((Object)tileEntity)).setEnergyMultiplier(this.getEnergyMultiplier(stack), new Object[0]);
                ((IUpgradeManagement)((Object)tileEntity)).setSpeedMultiplier(this.getSpeedMultiplier(stack), new Object[0]);
            }
            if (tileEntity instanceof IInvConfiguration) {
                IInvConfiguration config = (IInvConfiguration)((Object)tileEntity);
                if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("hasSideData")) {
                    config.getEjector().setEjecting(stack.field_77990_d.func_74767_n("ejecting"));
                    for (int i = 0; i < 6; ++i) {
                        config.getConfiguration()[i] = stack.field_77990_d.func_74771_c("config" + i);
                    }
                }
            }
            if (tileEntity instanceof TileEntityDigitalMiner) {
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)tileEntity;
                if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("hasMinerConfig")) {
                    miner.radius = stack.field_77990_d.func_74762_e("radius");
                    miner.minY = stack.field_77990_d.func_74762_e("minY");
                    miner.maxY = stack.field_77990_d.func_74762_e("maxY");
                    miner.doEject = stack.field_77990_d.func_74767_n("doEject");
                    miner.doPull = stack.field_77990_d.func_74767_n("doPull");
                    miner.silkTouch = stack.field_77990_d.func_74767_n("silkTouch");
                    if (stack.field_77990_d.func_74764_b("replaceStack")) {
                        miner.replaceStack = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("replaceStack"));
                    }
                    if (stack.field_77990_d.func_74764_b("filters")) {
                        NBTTagList tagList = stack.field_77990_d.func_74761_m("filters");
                        for (int i = 0; i < tagList.func_74745_c(); ++i) {
                            miner.filters.add(MinerFilter.readFromNBT((NBTTagCompound)tagList.func_74743_b(i)));
                        }
                    }
                }
            }
            if (tileEntity instanceof TileEntityLogisticalSorter) {
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tileEntity;
                if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("hasSorterConfig")) {
                    if (stack.field_77990_d.func_74764_b("color")) {
                        sorter.color = TransporterUtils.colors.get(stack.field_77990_d.func_74762_e("color"));
                    }
                    sorter.autoEject = stack.field_77990_d.func_74767_n("autoEject");
                    sorter.roundRobin = stack.field_77990_d.func_74767_n("roundRobin");
                    if (stack.field_77990_d.func_74764_b("filters")) {
                        NBTTagList tagList = stack.field_77990_d.func_74761_m("filters");
                        for (int i = 0; i < tagList.func_74745_c(); ++i) {
                            sorter.filters.add(TransporterFilter.readFromNBT((NBTTagCompound)tagList.func_74743_b(i)));
                        }
                    }
                }
            }
            if (tileEntity instanceof IRedstoneControl && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("controlType")) {
                ((IRedstoneControl)((Object)tileEntity)).setControlType(IRedstoneControl.RedstoneControl.values()[stack.field_77990_d.func_74762_e("controlType")]);
            }
            if (tileEntity instanceof TileEntityFactory) {
                ((TileEntityFactory)tileEntity).recipeType = this.getRecipeType(stack);
                world.func_72898_h(x, y, z, tileEntity.func_70311_o().field_71990_ca);
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)((Object)tileEntity)).setFluidStack(this.getFluidStack(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityElectricChest) {
                ((TileEntityElectricChest)tileEntity).authenticated = this.getAuthenticated(stack);
                ((TileEntityElectricChest)tileEntity).locked = this.getLocked(stack);
                ((TileEntityElectricChest)tileEntity).password = this.getPassword(stack);
            }
            if (tileEntity instanceof TileEntityRotaryCondensentrator && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("gasStack")) {
                GasStack gasStack = GasStack.readFromNBT(stack.field_77990_d.func_74775_l("gasStack"));
                ((TileEntityRotaryCondensentrator)tileEntity).gasTank.setGas(gasStack);
            }
            if (tileEntity instanceof TileEntityChemicalOxidizer && stack.field_77990_d != null) {
                ((TileEntityChemicalOxidizer)tileEntity).gasTank.setGas(GasStack.readFromNBT(stack.field_77990_d.func_74775_l("gasTank")));
            }
            if (tileEntity instanceof TileEntityChemicalInfuser && stack.field_77990_d != null) {
                ((TileEntityChemicalInfuser)tileEntity).leftTank.setGas(GasStack.readFromNBT(stack.field_77990_d.func_74775_l("leftTank")));
                ((TileEntityChemicalInfuser)tileEntity).rightTank.setGas(GasStack.readFromNBT(stack.field_77990_d.func_74775_l("rightTank")));
                ((TileEntityChemicalInfuser)tileEntity).centerTank.setGas(GasStack.readFromNBT(stack.field_77990_d.func_74775_l("centerTank")));
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            tileEntity.electricityStored = this.getEnergy(stack);
            return true;
        }
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    @Override
    public int getMaxCharge(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Override
    public int getTransferLimit(ItemStack itemStack) {
        return 0;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        InventoryElectricChest inv;
        if (BlockMachine.MachineType.get(itemstack) == BlockMachine.MachineType.ELECTRIC_CHEST && world != null && !world.field_72995_K && (inv = new InventoryElectricChest(itemstack)).func_70301_a(54) != null && this.getEnergy(itemstack) < this.getMaxEnergy(itemstack)) {
            if (inv.func_70301_a(54).func_77973_b() instanceof IEnergizedItem) {
                this.setEnergy(itemstack, this.getEnergy(itemstack) + EnergizedItemManager.discharge(inv.func_70301_a(54), this.getMaxEnergy(itemstack) - this.getEnergy(itemstack)));
            } else if (Mekanism.hooks.IC2Loaded && inv.func_70301_a(54).func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)inv.func_70301_a(54).func_77973_b();
                if (item.canProvideEnergy(inv.func_70301_a(54))) {
                    double gain = (double)ElectricItem.manager.discharge(inv.func_70301_a(54), (int)((this.getMaxEnergy(itemstack) - this.getEnergy(itemstack)) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setEnergy(itemstack, this.getEnergy(itemstack) + gain);
                }
            } else if (inv.func_70301_a(54).func_77973_b() instanceof IEnergyContainerItem) {
                ItemStack itemStack = inv.func_70301_a(54);
                IEnergyContainerItem item = (IEnergyContainerItem)inv.func_70301_a(54).func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)item.getEnergyStored(itemStack)));
                int toTransfer = (int)Math.round(Math.min((double)itemEnergy, (this.getMaxEnergy(itemstack) - this.getEnergy(itemstack)) * Mekanism.TO_TE));
                this.setEnergy(itemstack, this.getEnergy(itemstack) + (double)item.extractEnergy(itemStack, toTransfer, false) * Mekanism.FROM_TE);
            } else if (inv.func_70301_a((int)54).field_77993_c == Item.field_77767_aC.field_77779_bT && this.getEnergy(itemstack) + Mekanism.ENERGY_PER_REDSTONE <= this.getMaxEnergy(itemstack)) {
                this.setEnergy(itemstack, this.getEnergy(itemstack) + Mekanism.ENERGY_PER_REDSTONE);
                --inv.func_70301_a((int)54).field_77994_a;
                if (inv.func_70301_a((int)54).field_77994_a <= 0) {
                    inv.func_70299_a(54, null);
                }
            }
            inv.write();
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.func_77663_a(entityItem.func_92059_d(), null, (Entity)entityItem, 0, false);
        return false;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return 0;
            }
            return itemStack.field_77990_d.func_74762_e("energyMultiplier");
        }
        return 0;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74768_a("energyMultiplier", multiplier);
        }
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return 0;
            }
            return itemStack.field_77990_d.func_74762_e("speedMultiplier");
        }
        return 0;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74768_a("speedMultiplier", multiplier);
        }
    }

    @Override
    public boolean supportsUpgrades(Object ... data) {
        if (data[0] instanceof ItemStack) {
            BlockMachine.MachineType type = BlockMachine.MachineType.get((ItemStack)data[0]);
            return type.supportsUpgrades;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K && BlockMachine.MachineType.get(itemstack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
            if (!this.getAuthenticated(itemstack)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 2, 0, false}), entityplayer);
            } else if (this.getLocked(itemstack) && this.getEnergy(itemstack) > 0.0) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketElectricChest().setParams(new Object[]{PacketElectricChest.ElectricChestPacketType.CLIENT_OPEN, 1, 0, false}), entityplayer);
            } else {
                InventoryElectricChest inventory = new InventoryElectricChest(entityplayer);
                MekanismUtils.openElectricChestGui((EntityPlayerMP)entityplayer, null, (IInventory)inventory, false);
            }
        }
        return itemstack;
    }

    @Override
    public int getRecipeType(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("recipeType");
    }

    @Override
    public void setRecipeType(int type, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("recipeType", type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_74761_m("Items");
        }
        return null;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (fluidStack == null || fluidStack.amount == 0 || fluidStack.fluidID == 0) {
            return;
        }
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("fluidTank")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank"));
            }
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && (BlockMachine.MachineType.get((ItemStack)data[0]) == BlockMachine.MachineType.ELECTRIC_PUMP || BlockMachine.MachineType.get((ItemStack)data[0]) == BlockMachine.MachineType.ROTARY_CONDENSENTRATOR);
    }

    @Override
    public void setAuthenticated(ItemStack itemStack, boolean auth) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("authenticated", auth);
    }

    @Override
    public boolean getAuthenticated(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("authenticated");
    }

    @Override
    public void setPassword(ItemStack itemStack, String pass) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74778_a("password", pass);
    }

    @Override
    public String getPassword(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return "";
        }
        return itemStack.field_77990_d.func_74779_i("password");
    }

    @Override
    public void setLocked(ItemStack itemStack, boolean locked) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("locked", locked);
    }

    @Override
    public boolean getLocked(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("locked");
    }

    @Override
    public void setOpen(ItemStack itemStack, boolean open) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74757_a("open", open);
    }

    @Override
    public boolean getOpen(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n("open");
    }

    @Override
    public void setLidAngle(ItemStack itemStack, float lidAngle) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74776_a("lidAngle", lidAngle);
    }

    @Override
    public float getLidAngle(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0f;
        }
        return itemStack.field_77990_d.func_74760_g("lidAngle");
    }

    @Override
    public void setPrevLidAngle(ItemStack itemStack, float prevLidAngle) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74776_a("prevLidAngle", prevLidAngle);
    }

    @Override
    public float getPrevLidAngle(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0f;
        }
        return itemStack.field_77990_d.func_74760_g("prevLidAngle");
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getMaxEnergy(this.getEnergyMultiplier(itemStack), BlockMachine.MachineType.get((int)itemStack.field_77993_c, (int)itemStack.func_77960_j()).baseEnergy);
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * Mekanism.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * Mekanism.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * Mekanism.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * Mekanism.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * Mekanism.TO_TE);
    }

    @Override
    public boolean isMetadataSpecific() {
        return true;
    }

    @Override
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }
}

